/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.a7tview;

import com.piercefuller.a7trk.a7tview.ColorDialog;
import com.piercefuller.a7trk.a7tview.Colors;
import com.piercefuller.a7trk.a7tview.ConfigDialog;
import com.piercefuller.a7trk.a7tview.ProgressView;
import com.piercefuller.a7trk.a7tview.SourceControl;
import com.piercefuller.a7trk.a7tview.ViewScreen;
import com.piercefuller.a7trk.decode.MultiSource;
import com.piercefuller.a7trk.decode.Record;
import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeDecoder;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class A7tView
extends JFrame {
    private MultiSource multiSource = null;
    private int zoom = 1;
    private ProgressView progress = null;
    private SourceControl[] sourceControl;
    private int screenWidth;
    private int screenHeight;
    private boolean ignoreRecnum = false;
    private Colors colors = new Colors();
    private JButton fileButton;
    private JFileChooser openFileDialog1;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private ViewScreen viewScreen;
    private JButton configButton;
    private JCheckBox rawCheckbox;
    private JCheckBox lumpCheckbox;
    private JButton zoomBackButton;
    private JCheckBox dirCheckbox;
    private JSpinner positionSpinner;
    private long maximum1;
    private long minimum1;
    private JCheckBox centerCheckbox;
    private JCheckBox zeroCheckbox;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JCheckBox clipCheckbox;
    private JButton colorButton;
    private JLabel zoomLabel;
    private JLabel infoLabel;
    private JButton evaluateButton;
    private JButton nextErrButton;
    private JButton calibrateButton;
    private JButton recordEndButton;
    private JButton writeButton;
    private JSpinner recordSpinner;
    private JButton recordBeginningButton;
    private JCheckBox baseCheckbox;
    private JButton markButton;
    private JCheckBox crowdCheckbox;
    private JLabel viewRangeLabel;
    private JButton setStartButton;
    private JButton setEndButton;
    private JButton writeInfoButton;
    private Action fileButtonClick = new AbstractAction("fileButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            A7tView.this.closeData();
            A7tView.this.openFileDialog1.showOpenDialog(A7tView.this);
            if (A7tView.this.openFileDialog1.getSelectedFile() != null) {
                A7tView.this.openData(A7tView.this.openFileDialog1.getSelectedFile().getPath());
            }
        }
    };
    private Action zoomInButtonClick = new AbstractAction("zoomInButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.zoom > 1) {
                A7tView.this.zoom /= 2;
            }
            A7tView.this.needUpdate();
        }
    };
    private Action zoomOutButtonClick = new AbstractAction("zoomOutButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null && 2L * A7tView.this.getZoomWidth() <= A7tView.this.multiSource.getLength()) {
                A7tView.this.zoom *= 2;
            }
            A7tView.this.needUpdate();
        }
    };
    private MouseListener viewScreenMouseDown = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getPoint().x;
            int n2 = mouseEvent.getPoint().y;
            int n3 = A7tView.this.screenHeight;
            A7tView.this.viewScreen.getClass();
            A7tView.this.viewScreen.getClass();
            if (n2 < n3 - (16 + 16)) {
                A7tView.this.setPosition(A7tView.this.getPosition() + A7tView.this.getZoomWidth(n - ((A7tView)A7tView.this).viewScreen.SideBorder - A7tView.this.screenWidth / 2));
            } else {
                int n4 = A7tView.this.screenHeight;
                A7tView.this.viewScreen.getClass();
                if (n2 < n4 - 16) {
                    A7tView.this.setPosition(A7tView.this.getPosition() + A7tView.this.getZoomWidth(n - ((A7tView)A7tView.this).viewScreen.SideBorder - A7tView.this.screenWidth / 2));
                } else {
                    A7tView.this.setPosition(A7tView.this.multiSource.getLength() * (long)(n - ((A7tView)A7tView.this).viewScreen.SideBorder) / (long)A7tView.this.screenWidth);
                }
            }
        }
    };
    private HierarchyBoundsListener viewScreenResize = new HierarchyBoundsAdapter(){

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            A7tView.this.needUpdate();
        }
    };
    private Action configButtonClick = new AbstractAction("configButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                ConfigDialog configDialog = new ConfigDialog(A7tView.this);
                configDialog.setVisible(true);
                A7tView.this.needUpdate();
            }
        }
    };
    private Action zoomBackButtonClick = new AbstractAction("zoomBackButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            A7tView.this.zoom = 1;
            A7tView.this.needUpdate();
        }
    };
    private Action somethingChanged = new AbstractAction("somethingChanged"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            A7tView.this.needUpdate();
        }
    };
    private ChangeListener positionSpinnerValueChanged = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            A7tView.this.setPosition(((Number)A7tView.this.positionSpinner.getModel().getValue()).longValue());
        }
    };
    private Action colorButtonClick = new AbstractAction("colorButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorDialog colorDialog = new ColorDialog(A7tView.this, A7tView.this.colors);
            colorDialog.setVisible(true);
        }
    };
    private Action evaluateButtonClick = new AbstractAction("evaluateButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                if (A7tView.this.progress != null) {
                    A7tView.this.progress.closeAll();
                }
                A7tView.this.progress = new ProgressView("Evaluating...");
                A7tView.this.progress.setVisible(true);
                new Thread(new Runner(2)).start();
            }
        }
    };
    private Action recordBeginningButtonClick = new AbstractAction("recordBeginningButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null && A7tView.this.multiSource.recordOriented()) {
                long l;
                long l2 = A7tView.this.getPosition();
                Record record = A7tView.this.multiSource.getRecord(l2);
                if (record == null) {
                    record = A7tView.this.multiSource.getPreviousRecord(l2);
                }
                if (record == null) {
                    record = A7tView.this.multiSource.getNextRecord(l2);
                }
                if (record != null && (l = record.getStart()) != l2) {
                    A7tView.this.setPosition(l);
                }
            }
        }
    };
    private Action nextErrButtonClick = new AbstractAction("nextErrButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null && A7tView.this.multiSource.recordOriented()) {
                A7tView.this.multiSource.setPosition(A7tView.this.getPosition());
                A7tView.this.setPosition(A7tView.this.multiSource.getNextError());
            }
        }
    };
    private Action calibrateButtonClick = new AbstractAction("calibrateButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                if (A7tView.this.progress != null) {
                    A7tView.this.progress.closeAll();
                }
                A7tView.this.progress = new ProgressView("Calibrating...");
                A7tView.this.progress.setVisible(true);
                new Thread(new Runner(0)).start();
            }
        }
    };
    private Action recordEndButtonClick = new AbstractAction("recordEndButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null && A7tView.this.multiSource.recordOriented()) {
                long l;
                long l2 = A7tView.this.getPosition();
                Record record = A7tView.this.multiSource.getRecord(l2);
                if (record != null && (l = record.getEnd()) != l2) {
                    A7tView.this.setPosition(l);
                }
            }
        }
    };
    private Action writeButtonClick = new AbstractAction("writeButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                if (A7tView.this.progress != null) {
                    A7tView.this.progress.closeAll();
                }
                A7tView.this.progress = new ProgressView("Writing...");
                A7tView.this.progress.setVisible(true);
                new Thread(new Runner(3)).start();
            }
        }
    };
    private ChangeListener recordSpinnerValueChanged = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Record record;
            if (A7tView.this.ignoreRecnum) {
                A7tView.this.ignoreRecnum = false;
                return;
            }
            int n = ((Number)A7tView.this.recordSpinner.getModel().getValue()).intValue();
            if (A7tView.this.multiSource != null && (record = A7tView.this.multiSource.getRecord(n)) != null) {
                A7tView.this.setPosition(record.getStart());
            }
        }
    };
    private Action markButtonClick = new AbstractAction("markButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                if (A7tView.this.progress != null) {
                    A7tView.this.progress.closeAll();
                }
                A7tView.this.progress = new ProgressView("Marking...");
                A7tView.this.progress.setVisible(true);
                new Thread(new Runner(1)).start();
            }
        }
    };
    private Action setStartButtonClick = new AbstractAction("setStartButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                A7tView.this.multiSource.setStart(A7tView.this.getPosition());
            }
            A7tView.this.needUpdate();
        }
    };
    private Action setEndButtonClick = new AbstractAction("setEndButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                A7tView.this.multiSource.setEnd(A7tView.this.getPosition());
            }
            A7tView.this.needUpdate();
        }
    };
    private Action writeInfoButtonClick = new AbstractAction("writeInfoButtonClick"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (A7tView.this.multiSource != null) {
                new Runner(4).run();
            }
        }
    };

    public A7tView() {
        super("A7tView");
        this.initialize();
    }

    public A7tView(String string) {
        super("A7tView " + string);
        this.initialize();
        this.openData(string);
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.fileButton = new JButton();
        this.openFileDialog1 = new JFileChooser();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.configButton = new JButton();
        this.rawCheckbox = new JCheckBox();
        this.lumpCheckbox = new JCheckBox();
        this.zoomBackButton = new JButton();
        this.dirCheckbox = new JCheckBox();
        this.positionSpinner = new JSpinner();
        this.centerCheckbox = new JCheckBox();
        this.zeroCheckbox = new JCheckBox();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.label7 = new JLabel();
        this.clipCheckbox = new JCheckBox();
        this.colorButton = new JButton();
        this.zoomLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.evaluateButton = new JButton();
        this.nextErrButton = new JButton();
        this.calibrateButton = new JButton();
        this.recordEndButton = new JButton();
        this.writeButton = new JButton();
        this.recordSpinner = new JSpinner();
        this.recordBeginningButton = new JButton();
        this.baseCheckbox = new JCheckBox();
        this.markButton = new JButton();
        this.crowdCheckbox = new JCheckBox();
        this.viewRangeLabel = new JLabel();
        this.setStartButton = new JButton();
        this.setEndButton = new JButton();
        this.writeInfoButton = new JButton();
        this.sourceControl = new SourceControl[5];
        this.sourceControl[0] = new SourceControl(this.rawCheckbox, this.colors.getRawColor(), 2048);
        this.sourceControl[1] = new SourceControl(this.lumpCheckbox, this.colors.getLumpColor(), 9000);
        this.sourceControl[2] = new SourceControl(this.baseCheckbox, this.colors.getBaseColor(), 9000);
        this.sourceControl[3] = new SourceControl(this.dirCheckbox, this.colors.getDirectionColor(), 9000);
        this.sourceControl[4] = new SourceControl(this.crowdCheckbox, this.colors.getCrowdColor(), 9000);
        Box box = new Box(0);
        Box box2 = new Box(0);
        this.fileButton.setText("File");
        this.fileButton.addActionListener(this.fileButtonClick);
        this.zoomInButton.setText("+");
        this.zoomInButton.addActionListener(this.zoomInButtonClick);
        this.zoomOutButton.setText("-");
        this.zoomOutButton.addActionListener(this.zoomOutButtonClick);
        this.configButton.setText("Conf");
        this.configButton.addActionListener(this.configButtonClick);
        this.rawCheckbox.setSelected(true);
        this.rawCheckbox.setText("Raw");
        this.rawCheckbox.addActionListener(this.somethingChanged);
        this.lumpCheckbox.setSelected(true);
        this.lumpCheckbox.setText("Lump");
        this.lumpCheckbox.addActionListener(this.somethingChanged);
        this.zoomBackButton.setText("1");
        this.zoomBackButton.addActionListener(this.zoomBackButtonClick);
        this.dirCheckbox.setSelected(true);
        this.dirCheckbox.setText("Dir");
        this.dirCheckbox.addActionListener(this.somethingChanged);
        this.positionSpinner.setSize(new Dimension(88, 20));
        this.positionSpinner.addChangeListener(this.positionSpinnerValueChanged);
        this.centerCheckbox.setSelected(true);
        this.centerCheckbox.setText("Center");
        this.centerCheckbox.addActionListener(this.somethingChanged);
        this.zeroCheckbox.setSelected(true);
        this.zeroCheckbox.setText("Zero");
        this.zeroCheckbox.addActionListener(this.somethingChanged);
        this.label1.setLocation(new Point(8, 56));
        this.label1.setName("label1");
        this.label1.setSize(new Dimension(16, 16));
        this.label1.setText("P");
        this.label2.setLocation(new Point(8, 104));
        this.label2.setName("label2");
        this.label2.setSize(new Dimension(16, 16));
        this.label2.setText("5");
        this.label3.setLocation(new Point(8, 152));
        this.label3.setName("label3");
        this.label3.setSize(new Dimension(16, 16));
        this.label3.setText("4");
        this.label4.setLocation(new Point(8, 200));
        this.label4.setName("label4");
        this.label4.setSize(new Dimension(16, 16));
        this.label4.setText("3");
        this.label5.setLocation(new Point(8, 256));
        this.label5.setName("label5");
        this.label5.setSize(new Dimension(16, 16));
        this.label5.setText("2");
        this.label6.setLocation(new Point(8, 304));
        this.label6.setName("label6");
        this.label6.setSize(new Dimension(16, 16));
        this.label6.setText("1");
        this.label7.setLocation(new Point(8, 352));
        this.label7.setName("label7");
        this.label7.setSize(new Dimension(16, 16));
        this.label7.setText("0");
        this.clipCheckbox.setSelected(true);
        this.clipCheckbox.setText("Clip");
        this.clipCheckbox.addActionListener(this.somethingChanged);
        this.colorButton.setText("Color");
        this.colorButton.addActionListener(this.colorButtonClick);
        this.zoomLabel.setText("zoom");
        this.evaluateButton.setText("Evaluate");
        this.evaluateButton.addActionListener(this.evaluateButtonClick);
        this.nextErrButton.setEnabled(false);
        this.nextErrButton.setText("Next Err");
        this.nextErrButton.addActionListener(this.nextErrButtonClick);
        this.calibrateButton.setText("Cal");
        this.calibrateButton.addActionListener(this.calibrateButtonClick);
        this.recordEndButton.setEnabled(false);
        this.recordEndButton.setText("End");
        this.recordEndButton.addActionListener(this.recordEndButtonClick);
        this.writeButton.setText("Write");
        this.writeButton.addActionListener(this.writeButtonClick);
        this.recordSpinner.setEnabled(false);
        this.recordSpinner.getModel().setValue(new Integer(1));
        this.recordSpinner.addChangeListener(this.recordSpinnerValueChanged);
        this.recordBeginningButton.setEnabled(false);
        this.recordBeginningButton.setText("Begin");
        this.recordBeginningButton.addActionListener(this.recordBeginningButtonClick);
        this.baseCheckbox.setSelected(true);
        this.baseCheckbox.setText("Base");
        this.baseCheckbox.addActionListener(this.somethingChanged);
        this.markButton.setText("Mark");
        this.markButton.addActionListener(this.markButtonClick);
        this.crowdCheckbox.setSelected(true);
        this.crowdCheckbox.setText("Cr");
        this.crowdCheckbox.addActionListener(this.somethingChanged);
        this.setStartButton.setText("S");
        this.setStartButton.addActionListener(this.setStartButtonClick);
        this.setEndButton.setText("E");
        this.setEndButton.addActionListener(this.setEndButtonClick);
        this.writeInfoButton.setText("WX");
        this.writeInfoButton.addActionListener(this.writeInfoButtonClick);
        box.add(this.fileButton);
        box.add(this.rawCheckbox);
        box.add(this.lumpCheckbox);
        box.add(this.baseCheckbox);
        box.add(this.dirCheckbox);
        box.add(this.crowdCheckbox);
        box.add(this.centerCheckbox);
        box.add(this.zeroCheckbox);
        box.add(this.clipCheckbox);
        box.add(Box.createGlue());
        box.add(this.calibrateButton);
        box.add(this.markButton);
        box.add(this.evaluateButton);
        box.add(this.writeButton);
        box.add(this.writeInfoButton);
        box.add(Box.createGlue());
        box.add(this.configButton);
        box.add(this.colorButton);
        box.add(Box.createGlue());
        box.add(this.zoomLabel);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.zoomInButton);
        box.add(this.zoomOutButton);
        box.add(this.zoomBackButton);
        box2.add(Box.createGlue());
        box2.add(this.setStartButton);
        box2.add(this.setEndButton);
        box2.add(Box.createHorizontalStrut(6));
        box2.add(this.positionSpinner);
        box2.add(Box.createGlue());
        box2.add(this.viewRangeLabel);
        box2.add(Box.createGlue());
        box2.add(Box.createGlue());
        box2.add(this.recordSpinner);
        box2.add(this.recordBeginningButton);
        box2.add(this.recordEndButton);
        box2.add(this.nextErrButton);
        box2.add(Box.createGlue());
        box2.add(this.infoLabel);
        box2.add(Box.createGlue());
        this.viewScreen = new ViewScreen(this, this.sourceControl, this.colors);
        this.viewScreen.addHierarchyBoundsListener(this.viewScreenResize);
        this.viewScreen.addMouseListener(this.viewScreenMouseDown);
        box.validate();
        box.setMaximumSize(new Dimension(10000, box.getPreferredSize().height));
        box2.validate();
        box2.setMaximumSize(new Dimension(10000, box2.getPreferredSize().height));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(box);
        this.add(this.viewScreen);
        this.add(box2);
        Dimension dimension = new Dimension(Math.max(box.getPreferredSize().width, box2.getPreferredSize().width), 600);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setName("A7tView");
        this.setTitle("A7tView");
        this.pack();
        this.setVisible(true);
    }

    public MultiSource getMultiSource() {
        return this.multiSource;
    }

    public int getRawZoom() {
        return this.sourceControl[0].getZoom();
    }

    public void setRawZoom(int n) {
        this.sourceControl[0].setZoom(n);
    }

    public int getLumpZoom() {
        return this.sourceControl[1].getZoom();
    }

    public void setLumpZoom(int n) {
        this.sourceControl[1].setZoom(n);
        this.sourceControl[2].setZoom(n);
        this.sourceControl[3].setZoom(n);
    }

    public Source getSource() {
        if (this.multiSource == null) {
            return null;
        }
        return this.multiSource.getSource();
    }

    public int getZoom() {
        return this.zoom;
    }

    public long getZoomWidth(int n) {
        return this.zoom * n / 2;
    }

    public long getZoomWidth() {
        return this.getZoomWidth(this.screenWidth);
    }

    public boolean centerEnabled() {
        return this.centerCheckbox.isSelected();
    }

    public boolean zeroEnabled() {
        return this.zeroCheckbox.isSelected();
    }

    public boolean clipEnabled() {
        return this.clipCheckbox.isSelected();
    }

    protected void setPosition(long l) {
        if (l > this.maximum1) {
            l = this.maximum1;
        }
        if (l < this.minimum1) {
            l = this.minimum1;
        }
        if (((Number)this.positionSpinner.getModel().getValue()).longValue() != l) {
            this.positionSpinner.setValue(new Long(l));
        } else {
            this.needUpdate();
        }
    }

    public long getPosition() {
        return ((Number)this.positionSpinner.getModel().getValue()).longValue();
    }

    public void needUpdate() {
        this.sourceControl[0].setColor(this.colors.getRawColor());
        this.sourceControl[1].setColor(this.colors.getLumpColor());
        this.sourceControl[2].setColor(this.colors.getBaseColor());
        this.sourceControl[3].setColor(this.colors.getDirectionColor());
        this.sourceControl[4].setColor(this.colors.getCrowdColor());
        this.zoomLabel.setText(Integer.toString(this.zoom));
        this.screenWidth = this.viewScreen.getWidth() - 2 * this.viewScreen.SideBorder;
        this.screenHeight = this.viewScreen.getHeight();
        int n = 0;
        int n2 = 0;
        if (this.multiSource != null) {
            this.viewRangeLabel.setText(this.multiSource.getStart() + " - " + this.multiSource.getEnd());
            this.multiSource.setPosition(this.getPosition());
            n = this.multiSource.getSource().getNumChannels();
            this.viewScreen.getClass();
            this.viewScreen.getClass();
            n2 = (this.screenHeight - 20 - (16 + 16)) / n;
            this.nextErrButton.setEnabled(this.multiSource.getErrorTotal() > 0);
            String string = "";
            if (this.multiSource.recordOriented()) {
                Record record = this.multiSource.getRecord(this.getPosition());
                if (record != null) {
                    if (((Number)this.recordSpinner.getModel().getValue()).intValue() != record.getNumber()) {
                        this.ignoreRecnum = true;
                        this.recordSpinner.setValue(new Integer(record.getNumber()));
                    }
                    this.recordSpinner.setEnabled(true);
                    this.recordBeginningButton.setEnabled(true);
                    this.recordEndButton.setEnabled(true);
                    long l = this.getPosition() - record.getStart();
                    string = "pos " + l + " cnt " + record.getCount() + " sp " + ((TapeDecoder)this.multiSource).getSpacing() + ", " + record.getErrors() + " err, " + this.multiSource.getErrorTotal() + " Err " + this.multiSource.getNumRecords() + " Rec";
                } else {
                    int n3 = this.multiSource.getNumRecords();
                    if (n3 > 0) {
                        this.recordSpinner.setEnabled(true);
                        this.recordBeginningButton.setEnabled(true);
                        this.recordEndButton.setEnabled(true);
                        string = this.multiSource.getErrorTotal() + " Total errors  " + n3 + " Records";
                    } else {
                        this.recordSpinner.setEnabled(false);
                        this.recordBeginningButton.setEnabled(false);
                        this.recordEndButton.setEnabled(false);
                    }
                }
            } else {
                this.recordSpinner.setEnabled(false);
                string = this.multiSource.getErrorTotal() + " Total errors";
            }
            this.infoLabel.setText(string);
            int n4 = 26 + n2 / 2;
            this.label1.setLocation(new Point(8, n4 + n2 * 0));
            this.label2.setLocation(new Point(8, n4 + n2 * 1));
            this.label3.setLocation(new Point(8, n4 + n2 * 2));
            this.label4.setLocation(new Point(8, n4 + n2 * 3));
            this.label5.setLocation(new Point(8, n4 + n2 * 4));
            this.label6.setLocation(new Point(8, n4 + n2 * 5));
            this.label7.setLocation(new Point(8, n4 + n2 * 6));
            int n5 = 1;
            Source source = this.multiSource.getSource().getSource();
            while (source != null) {
                source = source.getSource();
                ++n5;
            }
            for (SourceControl sourceControl : this.sourceControl) {
                sourceControl.getCheckBox().setEnabled(false);
            }
            source = this.multiSource.getSource();
            for (int i = 0; i < n5; ++i) {
                for (SourceControl sourceControl : this.sourceControl) {
                    if (!sourceControl.getCheckBox().getText().equals(source.getName())) continue;
                    sourceControl.getCheckBox().setEnabled(true);
                    break;
                }
                source = source.getSource();
            }
        }
        this.repaint();
    }

    private void openData(String string) {
        this.closeData();
        if (string != null) {
            try {
                this.multiSource = new TapeDecoder(string);
                this.setTitle("A7tView - " + string);
                this.minimum1 = 0L;
                this.maximum1 = this.multiSource.getLength();
            }
            catch (Exception exception) {
                this.infoLabel.setText(exception.toString());
                this.multiSource = null;
                this.minimum1 = 0L;
                this.maximum1 = 0L;
                this.positionSpinner.setValue(new Integer(0));
                exception.printStackTrace();
            }
        } else {
            this.setTitle("A7tView");
        }
        this.zoom = 1;
        this.setPosition(0L);
    }

    private void closeData() {
        if (this.multiSource != null) {
            this.multiSource.close();
            this.multiSource = null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                new A7tView(stringArray[0]);
            } else {
                new A7tView();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class Runner
    implements Runnable {
        public static final int Calibrate = 0;
        public static final int Mark = 1;
        public static final int Evaluate = 2;
        public static final int Write = 3;
        public static final int WriteInfo = 4;
        private int whatToDo;

        public Runner(int n) {
            this.whatToDo = n;
        }

        @Override
        public void run() {
            try {
                switch (this.whatToDo) {
                    case 0: {
                        A7tView.this.multiSource.clone().calibrate(A7tView.this.progress, A7tView.this.multiSource);
                        break;
                    }
                    case 1: {
                        A7tView.this.multiSource.clone().mark(A7tView.this.progress, A7tView.this.multiSource);
                        break;
                    }
                    case 2: {
                        A7tView.this.multiSource.clone().evaluate(A7tView.this.progress, A7tView.this.multiSource);
                        break;
                    }
                    case 3: {
                        A7tView.this.multiSource.clone().write(A7tView.this.progress, A7tView.this.multiSource);
                        break;
                    }
                    case 4: {
                        A7tView.this.multiSource.clone().writeInfo();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

