/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.a7tview;

import com.piercefuller.a7trk.a7tview.A7tView;
import com.piercefuller.a7trk.decode.DataFile;
import com.piercefuller.a7trk.decode.MultiSource;
import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeParameters;
import com.piercefuller.a7trk.decode.TapeParametersList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfigDialog
extends JDialog {
    private A7tView parent;
    private int nchannel = 0;
    private TapeParameters tp = null;
    private Label[] channelLabels = null;
    private JTextField[] skewTextBoxes = null;
    private JTextField[] clipTextBoxes = null;
    private JTextField[] baseTextBoxes = null;
    private JLabel rawDataSectionLabel;
    private JLabel rawDataScaleLabel;
    private JTextField rawDataScaleTextbox;
    private JTextField lowSpaceTextbox;
    private JLabel lowSpaceLabel;
    private JLabel parametersSectionLabel;
    private JButton updateButton;
    private JTextField processedScaleTextbox;
    private JLabel processedScaleLabel;
    private JLabel processedSectionLabel;
    private JTextField gainTextbox;
    private JLabel gainLabel;
    private JTextField widthTextbox;
    private JLabel widthLabel;
    private JTextField gatherTextbox;
    private JLabel gatherLabel;
    private JLabel crowdLabel;
    private JTextField crowdTextbox;
    private JLabel highSpaceLabel;
    private JTextField highSpaceTextbox;
    private JButton insertButton;
    private JButton setEndButton;
    private JButton deleteButton;
    private JLabel maxSpaceLabel;
    private JLabel minGapLabel;
    private JLabel maxJunkLabel;
    private JTextField maxSpaceTextbox;
    private JTextField minGapTextbox;
    private JTextField maxJunkTextbox;
    private JLabel startPositionLabel;
    private JLabel endPositionLabel;
    private JLabel setEndPositionLabel;
    private JLabel insertPositionLabel;
    private JCheckBox compensateCheckbox;
    private Action button1_Click = new AbstractAction("button1_Click"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConfigDialog.this.updateValues();
            ConfigDialog.this.close();
        }
    };
    private Action button2_Click = new AbstractAction("button2_Click"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TapeParametersList tapeParametersList = ConfigDialog.this.parent.getMultiSource().getDataFile().getTapeParameters();
                long l = ConfigDialog.this.parent.getPosition();
                ConfigDialog.this.tp = tapeParametersList.add(l, tapeParametersList.getTapeParameters(l).getEnd());
                ConfigDialog.this.updateValues();
                ConfigDialog.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private Action button3_Click = new AbstractAction("button3_Click"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ConfigDialog.this.tp.setEnd(ConfigDialog.this.parent.getPosition());
                ConfigDialog.this.updateValues();
                ConfigDialog.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private Action button4_Click = new AbstractAction("button4_Click"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TapeParametersList tapeParametersList = ConfigDialog.this.parent.getMultiSource().getDataFile().getTapeParameters();
            tapeParametersList.remove(ConfigDialog.this.tp);
            ConfigDialog.this.close();
        }
    };

    public ConfigDialog(A7tView a7tView) {
        this.parent = a7tView;
        Font font = this.getFont();
        this.rawDataSectionLabel = new JLabel();
        this.rawDataSectionLabel.setFont(font);
        this.rawDataSectionLabel.setName("rawDataSectionLabel");
        this.rawDataSectionLabel.setText("Raw Data");
        this.rawDataScaleLabel = new JLabel();
        this.rawDataScaleLabel.setName("rawDataScaleLabel");
        this.rawDataScaleLabel.setText("Scale");
        this.rawDataScaleTextbox = new JTextField();
        this.rawDataScaleTextbox.setName("rawDataScaleTextbox");
        this.rawDataScaleTextbox.setColumns(5);
        this.rawDataScaleTextbox.setHorizontalAlignment(4);
        this.processedSectionLabel = new JLabel();
        this.processedSectionLabel.setFont(font);
        this.processedSectionLabel.setName("processedSectionLabel");
        this.processedSectionLabel.setText("Lump / Baseline");
        this.processedScaleLabel = new JLabel();
        this.processedScaleLabel.setName("processedScaleLabel");
        this.processedScaleLabel.setText("Scale");
        this.processedScaleTextbox = new JTextField();
        this.processedScaleTextbox.setName("processedScaleTextbox");
        this.processedScaleTextbox.setColumns(5);
        this.processedScaleTextbox.setHorizontalAlignment(4);
        this.parametersSectionLabel = new JLabel();
        this.parametersSectionLabel.setFont(font);
        this.parametersSectionLabel.setName("parametersSectionLabel");
        this.parametersSectionLabel.setText("Parameters");
        this.gainLabel = new JLabel();
        this.gainLabel.setName("gainLabel");
        this.gainLabel.setText("Gain");
        this.gainTextbox = new JTextField();
        this.gainTextbox.setName("gainTextbox");
        this.gainTextbox.setColumns(5);
        this.gainTextbox.setHorizontalAlignment(4);
        this.widthLabel = new JLabel();
        this.widthLabel.setName("widthLabel");
        this.widthLabel.setText("Width");
        this.widthTextbox = new JTextField();
        this.widthTextbox.setName("widthTextbox");
        this.widthTextbox.setColumns(5);
        this.widthTextbox.setHorizontalAlignment(4);
        this.crowdLabel = new JLabel();
        this.crowdLabel.setName("crowdLabel");
        this.crowdLabel.setText("Crowd");
        this.crowdTextbox = new JTextField();
        this.crowdTextbox.setName("crowdTextbox");
        this.crowdTextbox.setColumns(5);
        this.crowdTextbox.setHorizontalAlignment(4);
        this.gatherLabel = new JLabel();
        this.gatherLabel.setName("gatherLabel");
        this.gatherLabel.setText("Gather");
        this.gatherTextbox = new JTextField();
        this.gatherTextbox.setName("gatherTextbox");
        this.gatherTextbox.setColumns(5);
        this.gatherTextbox.setHorizontalAlignment(4);
        this.lowSpaceLabel = new JLabel();
        this.lowSpaceLabel.setName("lowSpaceLabel");
        this.lowSpaceLabel.setText("Low Sp");
        this.lowSpaceTextbox = new JTextField();
        this.lowSpaceTextbox.setName("lowSpaceTextbox");
        this.lowSpaceTextbox.setColumns(5);
        this.lowSpaceTextbox.setHorizontalAlignment(4);
        this.highSpaceLabel = new JLabel();
        this.highSpaceLabel.setName("highSpaceLabel");
        this.highSpaceLabel.setText("High Sp");
        this.highSpaceTextbox = new JTextField();
        this.highSpaceTextbox.setName("highSpaceTextbox");
        this.highSpaceTextbox.setColumns(5);
        this.highSpaceTextbox.setHorizontalAlignment(4);
        this.maxSpaceLabel = new JLabel();
        this.maxSpaceLabel.setName("maxSpaceLabel");
        this.maxSpaceLabel.setText("MaxSpace");
        this.maxSpaceTextbox = new JTextField();
        this.maxSpaceTextbox.setName("maxSpaceTextbox");
        this.maxSpaceTextbox.setColumns(5);
        this.maxSpaceTextbox.setHorizontalAlignment(4);
        this.minGapLabel = new JLabel();
        this.minGapLabel.setName("minGapLabel");
        this.minGapLabel.setText("MinGap");
        this.minGapTextbox = new JTextField();
        this.minGapTextbox.setName("minGapTextbox");
        this.minGapTextbox.setColumns(5);
        this.minGapTextbox.setHorizontalAlignment(4);
        this.maxJunkLabel = new JLabel();
        this.maxJunkLabel.setName("maxJunkLabel");
        this.maxJunkLabel.setText("MaxJunk");
        this.maxJunkTextbox = new JTextField();
        this.maxJunkTextbox.setName("maxJunkTextbox");
        this.maxJunkTextbox.setColumns(5);
        this.maxJunkTextbox.setHorizontalAlignment(4);
        this.insertButton = new JButton();
        this.insertButton.setName("insertButton");
        this.insertButton.setText("Start New");
        this.insertButton.addActionListener(this.button2_Click);
        this.setEndButton = new JButton();
        this.setEndButton.setName("setEndButton");
        this.setEndButton.setText("Set End");
        this.setEndButton.addActionListener(this.button3_Click);
        this.updateButton = new JButton();
        this.updateButton.setName("updateButton");
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(this.button1_Click);
        this.deleteButton = new JButton();
        this.deleteButton.setName("deleteButton");
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(this.button4_Click);
        this.startPositionLabel = new JLabel();
        this.startPositionLabel.setName("startPositionLabel");
        this.endPositionLabel = new JLabel();
        this.endPositionLabel.setName("endPositionLabel");
        this.setEndPositionLabel = new JLabel();
        this.setEndPositionLabel.setName("setEndPositionLabel");
        this.insertPositionLabel = new JLabel();
        this.insertPositionLabel.setName("insertPositionLabel");
        this.compensateCheckbox = new JCheckBox();
        this.compensateCheckbox.setName("compensateCheckbox");
        this.compensateCheckbox.setText("Compensate");
        Insets insets = new Insets(0, 3, 0, 6);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 21;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 21;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        jPanel.add((Component)this.rawDataSectionLabel, gridBagConstraints);
        jPanel.add((Component)this.rawDataScaleLabel, gridBagConstraints2);
        jPanel.add((Component)this.rawDataScaleTextbox, gridBagConstraints3);
        jPanel.add((Component)this.processedSectionLabel, gridBagConstraints);
        jPanel.add((Component)this.processedScaleLabel, gridBagConstraints2);
        jPanel.add((Component)this.processedScaleTextbox, gridBagConstraints3);
        jPanel.add((Component)this.parametersSectionLabel, gridBagConstraints);
        jPanel.add((Component)this.gainLabel, gridBagConstraints2);
        jPanel.add((Component)this.gainTextbox, gridBagConstraints3);
        jPanel.add((Component)this.widthLabel, gridBagConstraints2);
        jPanel.add((Component)this.widthTextbox, gridBagConstraints3);
        jPanel.add((Component)this.crowdLabel, gridBagConstraints2);
        jPanel.add((Component)this.crowdTextbox, gridBagConstraints3);
        jPanel.add((Component)this.gatherLabel, gridBagConstraints2);
        jPanel.add((Component)this.gatherTextbox, gridBagConstraints3);
        jPanel.add((Component)this.lowSpaceLabel, gridBagConstraints2);
        jPanel.add((Component)this.lowSpaceTextbox, gridBagConstraints3);
        jPanel.add((Component)this.highSpaceLabel, gridBagConstraints2);
        jPanel.add((Component)this.highSpaceTextbox, gridBagConstraints3);
        jPanel.add((Component)this.maxSpaceLabel, gridBagConstraints2);
        jPanel.add((Component)this.maxSpaceTextbox, gridBagConstraints3);
        jPanel.add((Component)this.minGapLabel, gridBagConstraints2);
        jPanel.add((Component)this.minGapTextbox, gridBagConstraints3);
        jPanel.add((Component)this.maxJunkLabel, gridBagConstraints2);
        jPanel.add((Component)this.maxJunkTextbox, gridBagConstraints3);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridy = 2;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridy = 0;
        jPanel2.add((Component)this.insertButton, gridBagConstraints4);
        jPanel2.add((Component)this.setEndButton, gridBagConstraints4);
        jPanel2.add((Component)this.updateButton, gridBagConstraints4);
        jPanel2.add((Component)this.deleteButton, gridBagConstraints4);
        jPanel2.add((Component)this.insertPositionLabel, gridBagConstraints5);
        jPanel2.add((Component)this.setEndPositionLabel, gridBagConstraints5);
        jPanel2.add((Component)new JLabel(""), gridBagConstraints5);
        jPanel2.add((Component)new JLabel(""), gridBagConstraints5);
        jPanel2.add((Component)this.startPositionLabel, gridBagConstraints6);
        jPanel2.add((Component)new JLabel(" - "), gridBagConstraints6);
        jPanel2.add((Component)this.endPositionLabel, gridBagConstraints6);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 21;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.insets = insets;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 21;
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.insets = insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.anchor = 21;
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.insets = insets;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 21;
        gridBagConstraints10.gridx = 3;
        gridBagConstraints10.insets = insets;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 21;
        gridBagConstraints11.gridx = 3;
        gridBagConstraints11.gridwidth = 2;
        gridBagConstraints11.insets = insets;
        this.getContentPane().setLayout(new BorderLayout());
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel3, "East");
        this.setName("ConfigDialog");
        this.setTitle("ConfigDialog");
        this.updateButton.setEnabled(true);
        this.insertButton.setEnabled(false);
        this.setEndButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        MultiSource multiSource = a7tView.getMultiSource();
        DataFile dataFile = multiSource.getDataFile();
        Source source = multiSource.getSource();
        if (dataFile != null) {
            this.nchannel = dataFile.getChannels();
            this.channelLabels = new Label[this.nchannel];
            this.skewTextBoxes = new JTextField[this.nchannel];
            this.clipTextBoxes = new JTextField[this.nchannel];
            this.baseTextBoxes = new JTextField[this.nchannel];
            jPanel3.add((Component)new JLabel("Channel"), gridBagConstraints7);
            jPanel3.add((Component)new JLabel("Skew"), gridBagConstraints8);
            jPanel3.add((Component)new JLabel("Clip"), gridBagConstraints9);
            jPanel3.add((Component)new JLabel("Baselimit"), gridBagConstraints10);
            for (int i = this.nchannel - 1; i >= 0; --i) {
                this.channelLabels[i] = new Label();
                this.channelLabels[i].setName("channelLabel" + i);
                this.channelLabels[i].setText(source.getChannelName(i));
                this.channelLabels[i].setAlignment(1);
                jPanel3.add((Component)this.channelLabels[i], gridBagConstraints7);
                this.skewTextBoxes[i] = new JTextField();
                this.skewTextBoxes[i].setName("skewTextBox" + i);
                this.skewTextBoxes[i].setColumns(2);
                this.skewTextBoxes[i].setHorizontalAlignment(4);
                jPanel3.add((Component)this.skewTextBoxes[i], gridBagConstraints8);
                this.clipTextBoxes[i] = new JTextField();
                this.clipTextBoxes[i].setName("clipTextBox" + i);
                this.clipTextBoxes[i].setColumns(5);
                this.clipTextBoxes[i].setHorizontalAlignment(4);
                jPanel3.add((Component)this.clipTextBoxes[i], gridBagConstraints9);
                this.baseTextBoxes[i] = new JTextField();
                this.baseTextBoxes[i].setName("baseTextBox" + i);
                this.baseTextBoxes[i].setColumns(5);
                this.baseTextBoxes[i].setHorizontalAlignment(4);
                jPanel3.add((Component)this.baseTextBoxes[i], gridBagConstraints10);
            }
            jPanel3.add((Component)this.compensateCheckbox, gridBagConstraints9);
        }
        this.pack();
        Dimension dimension = this.getPreferredSize();
        dimension.width = 4 * dimension.width / 3;
        dimension.height += 24;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.rawDataScaleTextbox.setText(Integer.toString(this.parent.getRawZoom()));
        this.processedScaleTextbox.setText(Integer.toString(this.parent.getLumpZoom()));
        if (this.nchannel > 0) {
            this.tp = dataFile.getTapeParameters().getTapeParameters(this.parent.getPosition());
            if (this.tp.getParent() != null) {
                this.deleteButton.setEnabled(true);
                if (this.tp.getEnd() == this.tp.getParent().getEnd()) {
                    this.setEndButton.setEnabled(true);
                } else if (this.tp.getStart() < this.parent.getPosition()) {
                    this.insertButton.setEnabled(true);
                }
            } else {
                this.insertButton.setEnabled(true);
            }
            this.startPositionLabel.setText(Long.toString(this.tp.getStart()));
            this.endPositionLabel.setText(Long.toString(this.tp.getEnd()));
            if (this.insertButton.isEnabled()) {
                this.insertPositionLabel.setText(Long.toString(this.parent.getPosition()));
            } else if (this.setEndButton.isEnabled()) {
                this.setEndPositionLabel.setText(Long.toString(this.parent.getPosition()));
            }
            this.gainTextbox.setText(Double.toString(this.tp.getGain()));
            this.widthTextbox.setText(Integer.toString(this.tp.getWidth()));
            for (int i = 0; i < this.nchannel; ++i) {
                this.skewTextBoxes[i].setText(Integer.toString(this.tp.getSkew()[i]));
                this.clipTextBoxes[i].setText(Integer.toString(this.tp.getClip(true, i)));
                this.baseTextBoxes[i].setText(Integer.toString(this.tp.getBaseLimit()[i]));
            }
            this.compensateCheckbox.setSelected(this.tp.getLowClip());
            this.compensateCheckbox.setEnabled(this.tp.canChangeLowClip());
            this.lowSpaceTextbox.setText(Integer.toString(this.tp.getLowSpace()));
            this.highSpaceTextbox.setText(Integer.toString(this.tp.getHighSpace()));
            this.crowdTextbox.setText(Integer.toString(this.tp.getCrowd()));
            this.gatherTextbox.setText(Integer.toString(this.tp.getGather()));
            this.maxSpaceTextbox.setText(Integer.toString(this.tp.getMaxSpace()));
            this.minGapTextbox.setText(Integer.toString(this.tp.getMinGap()));
            this.maxJunkTextbox.setText(Integer.toString(this.tp.getMaxJunk()));
        } else {
            this.compensateCheckbox.setSelected(false);
            this.gainTextbox.setText("");
            this.widthTextbox.setText("");
            this.lowSpaceTextbox.setText("");
            this.highSpaceTextbox.setText("");
            this.crowdTextbox.setText("");
            this.gatherTextbox.setText("");
            this.maxSpaceTextbox.setText("");
            this.minGapTextbox.setText("");
            this.maxJunkTextbox.setText("");
        }
    }

    public void updateValues() {
        this.parent.setRawZoom(Integer.parseInt(this.rawDataScaleTextbox.getText()));
        this.parent.setLumpZoom(Integer.parseInt(this.processedScaleTextbox.getText()));
        if (this.tp != null) {
            this.tp.setGain(Double.parseDouble(this.gainTextbox.getText()));
            this.tp.setWidth(Integer.parseInt(this.widthTextbox.getText()));
            if (this.compensateCheckbox.isEnabled()) {
                this.tp.setLowClip(this.compensateCheckbox.isSelected());
            }
            for (int i = 0; i < this.nchannel; ++i) {
                this.tp.getSkew()[i] = Integer.parseInt(this.skewTextBoxes[i].getText());
                this.tp.setClip(Integer.parseInt(this.clipTextBoxes[i].getText()), i);
                this.tp.getBaseLimit()[i] = Integer.parseInt(this.baseTextBoxes[i].getText());
            }
            this.tp.setLowSpace(Integer.parseInt(this.lowSpaceTextbox.getText()));
            this.tp.setHighSpace(Integer.parseInt(this.highSpaceTextbox.getText()));
            this.tp.setCrowd(Integer.parseInt(this.crowdTextbox.getText()));
            this.tp.setGather(Integer.parseInt(this.gatherTextbox.getText()));
            this.tp.setMaxSpace(Integer.parseInt(this.maxSpaceTextbox.getText()));
            this.tp.setMinGap(Integer.parseInt(this.minGapTextbox.getText()));
            this.tp.setMaxJunk(Integer.parseInt(this.maxJunkTextbox.getText()));
            this.parent.getMultiSource().reEvaluate();
        }
    }

    private void close() {
        this.setVisible(false);
    }
}

