/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.a7tview;

import com.piercefuller.a7trk.decode.Plottable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlotView
extends JFrame {
    private Plottable plot;
    private Color[] colors = new Color[3];
    private JCheckBox[] legend = new JCheckBox[6];
    private JPanel panel1;
    private JLabel xMinLabel;
    private JLabel xMaxLabel;
    private JLabel yMinLabel;
    private JLabel yMaxLabel;
    private Action checkBox_CheckedChanged = new AbstractAction("checkBox_CheckedChanged"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlotView.this.repaint();
        }
    };

    public PlotView(Plottable plottable) {
        this.plot = plottable;
        Box box = new Box(0);
        Box box2 = new Box(1);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        Box box5 = new Box(0);
        this.panel1 = new JPanel();
        this.xMinLabel = new JLabel();
        this.xMaxLabel = new JLabel();
        this.yMinLabel = new JLabel();
        this.yMaxLabel = new JLabel();
        this.panel1.setPreferredSize(new Dimension(344, 200));
        box.add(Box.createGlue());
        box.add(new JLabel(this.plot.getName()));
        box.add(Box.createGlue());
        box.validate();
        box5.add(this.xMinLabel);
        box5.add(Box.createGlue());
        box5.add(new JLabel(this.plot.getYLabel()));
        box5.add(Box.createGlue());
        box5.add(this.xMaxLabel);
        box5.setMaximumSize(new Dimension(10000, box5.getPreferredSize().height));
        box5.validate();
        box2.add(Box.createVerticalStrut(box.getPreferredSize().height));
        box2.add(this.yMaxLabel);
        box2.add(Box.createGlue());
        box2.add(new JLabel(this.plot.getXLabel()));
        box2.add(Box.createGlue());
        box2.add(this.yMinLabel);
        box2.add(Box.createVerticalStrut(box5.getPreferredSize().height));
        box4.add(this.panel1);
        box4.add(box5);
        this.colors[0] = Color.black;
        this.colors[1] = Color.blue;
        this.colors[2] = Color.red;
        this.setTitle(this.plot.getName());
        box3.add(Box.createGlue());
        this.legend = new JCheckBox[this.plot.getNumDatasets()];
        for (int i = 0; i < this.legend.length; ++i) {
            this.legend[i] = new JCheckBox();
            this.legend[i].addActionListener(this.checkBox_CheckedChanged);
            this.legend[i].setText(this.plot.getDatasetName(i));
            this.legend[i].setForeground(this.colors[i % this.colors.length]);
            this.legend[i].setSelected(true);
            this.legend[i].setEnabled(true);
            this.legend[i].setVisible(true);
            box3.add(this.legend[i]);
        }
        box3.add(Box.createGlue());
        box3.add(Box.createVerticalStrut(this.xMinLabel.getHeight()));
        this.getContentPane().setLayout(new BorderLayout());
        this.add((Component)box, "North");
        this.add((Component)box2, "West");
        this.add((Component)box4, "Center");
        this.add((Component)box3, "East");
        this.validate();
        this.panel1.setSize(new Dimension(344, 200));
        this.pack();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        double d;
        double d2;
        super.paint(graphics);
        graphics = this.panel1.getGraphics();
        int n = this.plot.getNumDatasets();
        if (n > this.legend.length) {
            n = this.legend.length;
        }
        int[][] nArrayArray = new int[n][];
        int[] nArray = this.plot.getDataset(0);
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < n; ++i) {
            if (!this.legend[i].isSelected()) continue;
            nArrayArray[i] = this.plot.getDataset(i + 1);
        }
        double d3 = 1.0E9;
        double d4 = -1.0E9;
        double d5 = 1.0E9;
        double d6 = -1.0E9;
        for (int i = 0; i < n; ++i) {
            if (!this.legend[i].isSelected()) continue;
            for (int j = 0; j < nArray.length; ++j) {
                d2 = nArray[j];
                d = nArrayArray[i][j];
                if (d2 > d4) {
                    d4 = d2;
                }
                if (d2 < d3) {
                    d3 = d2;
                }
                if (d > d6) {
                    d6 = d;
                }
                if (!(d < d5)) continue;
                d5 = d;
            }
        }
        this.xMinLabel.setText(Double.toString(d3));
        this.xMaxLabel.setText(Double.toString(d4));
        this.yMinLabel.setText(Double.toString(d5));
        this.yMaxLabel.setText(Double.toString(d6));
        graphics.setColor(Color.white);
        graphics.fillRect(this.panel1.getX(), this.panel1.getY(), this.panel1.getWidth(), this.panel1.getHeight());
        double d7 = 1.0;
        if (this.plot.isXLog()) {
            d2 = d4 - d3;
            if (d2 > 0.0) {
                d2 = Math.log(d2);
                d7 = (double)this.panel1.getWidth() / d2;
            }
        } else if (d4 > d3) {
            d7 = (double)this.panel1.getWidth() / (d4 - d3);
        }
        d2 = 1.0;
        if (this.plot.isYLog()) {
            d = d6 - d5;
            if (d > 0.0) {
                d = Math.log(d);
                d2 = (double)this.panel1.getHeight() / d;
            }
        } else if (d6 > d5) {
            d2 = (double)this.panel1.getHeight() / (d6 - d5);
        }
        for (int i = 0; i < n; ++i) {
            if (!this.legend[i].isSelected()) continue;
            for (int j = 0; j < nArray.length; ++j) {
                double d8;
                double d9 = (double)nArray[j] - d3;
                if (d9 > 0.0 && this.plot.isXLog()) {
                    d9 = Math.log(d9);
                }
                if ((d8 = (double)nArrayArray[i][j] - d5) > 0.0 && this.plot.isYLog()) {
                    d8 = Math.log(d8);
                }
                d9 = d7 * d9;
                d8 = d2 * d8;
                nArray2[j] = this.panel1.getX() + (int)d9;
                nArray3[j] = this.panel1.getY() + this.panel1.getHeight() - (int)d8;
            }
            graphics.setColor(this.colors[i % this.colors.length]);
            graphics.drawPolyline(nArray2, nArray3, nArray.length);
        }
    }
}

