/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.a7tview;

import com.piercefuller.a7trk.a7tview.PlotView;
import com.piercefuller.a7trk.decode.Plottable;
import com.piercefuller.a7trk.decode.ProgressWatcher;
import com.piercefuller.a7trk.decode.StopException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressView
extends JFrame
implements ProgressWatcher {
    private boolean proceed = true;
    private boolean finished = false;
    private Plottable myplot = null;
    private PlotView myplotview = null;
    private JProgressBar progressBar1;
    private JLabel label1;
    private JButton button1;
    private Action button1_Click = new AbstractAction("button1_Click"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ProgressView.this.finished) {
                ProgressView.this.proceed = false;
            } else if (ProgressView.this.myplot != null && ProgressView.this.myplotview == null) {
                ProgressView.this.myplotview = new PlotView(ProgressView.this.myplot);
                ProgressView.this.myplotview.setVisible(true);
                ProgressView.this.button1.setText("Close");
                ProgressView.this.repaint();
            } else {
                ProgressView.this.closeAll();
            }
        }
    };

    public ProgressView(String string) {
        this.button1 = new JButton();
        this.button1.setAlignmentX(0.5f);
        this.button1.setText("Stop");
        this.button1.addActionListener(this.button1_Click);
        this.progressBar1 = new JProgressBar();
        this.progressBar1.setAlignmentX(0.5f);
        this.label1 = new JLabel();
        this.label1.setAlignmentX(0.5f);
        JLabel jLabel = new JLabel();
        jLabel.setAlignmentX(0.5f);
        jLabel.setText(string);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(jLabel);
        this.add(this.progressBar1);
        this.add(this.label1);
        this.add(this.button1);
        this.add(Box.createVerticalStrut(24));
        this.setName("ProgressView");
        this.setTitle(string);
        this.pack();
    }

    @Override
    public void reportProgress(String string, int n, int n2) throws StopException {
        if (!this.proceed) {
            throw new StopException();
        }
        this.label1.setText(string);
        this.progressBar1.setMinimum(0);
        this.progressBar1.setMaximum(n2);
        this.progressBar1.setValue(n);
    }

    @Override
    public void reportProgress(int n) throws StopException {
        if (!this.proceed) {
            throw new StopException();
        }
        this.progressBar1.setValue(this.progressBar1.getValue() + n);
    }

    @Override
    public void finished() {
        this.proceed = true;
        try {
            this.reportProgress("Done", 100, 100);
        }
        catch (StopException stopException) {
            // empty catch block
        }
        if (this.myplot != null) {
            this.button1.setText("Plot");
        } else {
            this.button1.setText("Close");
        }
        this.finished = true;
        this.repaint();
    }

    @Override
    public void setPlot(Plottable plottable) {
        this.myplot = plottable;
    }

    public PlotView getPlotView() {
        if (this.myplot != null) {
            return new PlotView(this.myplot);
        }
        return null;
    }

    @Override
    public void closeAll() {
        if (this.myplotview != null) {
            this.myplotview.setVisible(false);
        }
        this.setVisible(false);
    }
}

