/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeParameters;

public class BaselineSource
implements Source {
    private final String Name = "Base";
    private Source source;
    private long lastPosition = 0L;
    private long limit = 0L;
    private int nchannel = 0;
    private int nlevel = 0;
    private int[][][] history;
    private int historyIndex;
    private int hsize;
    private int[] dataPoints = null;
    private long dataPointsPosition;
    private long lastPoint;
    private long oldMid;

    public BaselineSource(Source source) {
        this.source = source;
        if (this.source == null) {
            throw new Error("BaselineSource has no source");
        }
        this.limit = source.getEnd();
        this.nchannel = source.getNumChannels();
        this.nlevel = 1;
        for (Source source2 = this.source; source2 != null; source2 = source2.getSource()) {
            ++this.nlevel;
        }
        this.checkParameters(0L);
    }

    private synchronized void checkParameters(long l) {
        if (this.source == null) {
            throw new Error("Source closed");
        }
        this.hsize = 12 * this.getTapeParameters(l).getGather();
        this.history = new int[this.hsize][][];
        for (int i = 0; i < this.hsize; ++i) {
            this.history[i] = new int[this.nlevel][];
            for (int j = 0; j < this.nlevel; ++j) {
                this.history[i][j] = new int[this.nchannel];
                for (int k = 0; k < this.nchannel; ++k) {
                    this.history[i][j][k] = 0;
                }
            }
        }
        this.historyIndex = 0;
        this.lastPoint = 0L;
        this.oldMid = 0L;
    }

    @Override
    public TapeParameters getTapeParameters() {
        return this.getTapeParameters(this.getPosition());
    }

    @Override
    public TapeParameters getTapeParameters(long l) {
        return this.source.getTapeParameters(l);
    }

    @Override
    public String getName() {
        return "Base";
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int getNumChannels() {
        return this.source.getNumChannels();
    }

    @Override
    public String getChannelName(int n) {
        return this.source.getChannelName(n);
    }

    @Override
    public long getStart() {
        return this.source.getStart();
    }

    @Override
    public long getEnd() {
        return this.source.getEnd();
    }

    @Override
    public void setStart(long l) {
        this.source.setStart(l);
    }

    @Override
    public void setEnd(long l) {
        this.source.setEnd(l);
    }

    @Override
    public long getLength() {
        return this.source.getLength();
    }

    @Override
    public long getPosition() {
        return this.source.getPosition() - (long)this.hsize;
    }

    public synchronized void setDataPoints(int[] nArray, long l) {
        this.dataPoints = nArray;
        this.dataPointsPosition = l;
    }

    @Override
    public synchronized void setPosition(long l) {
        int n;
        this.checkParameters(l);
        this.lastPosition = l;
        this.source.setPosition(l);
        for (n = 0; n < this.nchannel; ++n) {
            for (int i = 0; i < this.hsize; ++i) {
                this.history[i][0][n] = 0;
            }
        }
        for (n = 0; n < this.hsize; ++n) {
            this.advance();
        }
    }

    @Override
    public void resetPosition() {
        this.setPosition(this.lastPosition);
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long l) {
        this.limit = l;
    }

    @Override
    public void resetLimit() {
        this.limit = this.source.getEnd();
    }

    @Override
    public boolean atLimit() {
        return this.getPosition() >= this.limit;
    }

    public synchronized boolean inBaseline(long l) {
        int n;
        return this.dataPoints != null && (n = (int)(l - this.dataPointsPosition)) >= 0 && n < this.dataPoints.length;
    }

    @Override
    public synchronized void advance() {
        int n;
        for (n = 1; n < this.nlevel; ++n) {
            int[] nArray = this.source.getSamples(n - 1);
            for (int i = 0; i < this.nchannel; ++i) {
                this.history[this.historyIndex][n][i] = nArray[i];
            }
        }
        if (this.dataPoints != null && (n = (int)(this.source.getPosition() - this.dataPointsPosition)) >= 0 && n < this.dataPoints.length && this.dataPoints[n] != 0) {
            long l = this.source.getPosition();
            long l2 = 0L;
            int n2 = 0;
            for (int i = 0; i < this.nchannel; ++i) {
                if (this.history[this.historyIndex][1][i] <= 0) continue;
                n2 |= 1 << i;
            }
            if (this.lastPoint != 0L) {
                l2 = (l + this.lastPoint) / 2L;
                if (this.oldMid != 0L && (int)(l - this.oldMid) < this.hsize) {
                    this.doBaseline(this.oldMid, l2);
                }
            }
            this.lastPoint = l;
            this.oldMid = l2;
        }
        for (n = 0; n < this.nchannel; ++n) {
            this.history[this.historyIndex][0][n] = 0;
        }
        this.source.advance();
        ++this.historyIndex;
        if (this.historyIndex == this.hsize) {
            this.historyIndex = 0;
        }
    }

    private synchronized void doBaseline(long l, long l2) {
        int n;
        int n2;
        long l3 = this.source.getPosition();
        if (l == 0L || (int)(l2 - l) > this.hsize - 1) {
            n2 = this.historyIndex + 1;
            if (n2 == this.hsize) {
                n2 = 0;
            }
            n = this.hsize - 1;
            l = 0L;
        } else {
            n2 = this.historyIndex + (int)(l - l3);
            if (n2 < 0) {
                n2 += this.hsize;
            }
            n = (int)(l2 - l);
        }
        int n3 = this.historyIndex + (int)(l2 - l3);
        if (n3 < 0) {
            n3 += this.hsize;
        }
        int n4 = (int)(l3 - l2);
        for (int i = 0; i < this.nchannel; ++i) {
            int n5;
            int n6 = this.history[n2][0][i];
            int n7 = this.history[n3][1][i];
            int n8 = this.getTapeParameters().getBaseLimit()[i];
            if (n7 > n8) {
                n7 = n8;
            } else if (n7 < -n8) {
                n7 = -n8;
            }
            int n9 = n2;
            for (n5 = 0; n5 <= n; ++n5) {
                this.history[n9][0][i] = (n6 * (n - n5) + n7 * n5) / n;
                if (++n9 < this.hsize) continue;
                n9 = 0;
            }
            for (n5 = 1; n5 <= n4; ++n5) {
                this.history[n9][0][i] = n7 * (n4 - n5) / n4;
                if (++n9 < this.hsize) continue;
                n9 = 0;
            }
        }
    }

    @Override
    public synchronized int[] getSamples() {
        int[] nArray = new int[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            nArray[i] = this.history[this.historyIndex][1][i] - this.history[this.historyIndex][0][i];
        }
        return nArray;
    }

    @Override
    public synchronized int[] getSamples(int n) {
        if (n > 0) {
            return this.history[this.historyIndex][n];
        }
        return this.getSamples();
    }

    @Override
    public int getFlags() {
        return this.source.getFlags();
    }

    @Override
    public synchronized void close() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
    }
}

