/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeParameters;
import java.io.BufferedWriter;
import java.io.IOException;

public class CrowdSource
implements Source {
    private final String Name = "Cr";
    private Source source;
    private long lastPosition = 0L;
    private long limit = 0L;
    private int nchannel = 0;
    private int nlevel = 0;
    private int[][][] history;
    private int historyIndex;
    private int crowd;
    private int setup;
    private int[] tcount;
    private int[] before;
    private int[] after;
    private BufferedWriter log = null;
    private int setsn = 0;

    public CrowdSource(Source source) {
        this.source = source;
        if (this.source == null) {
            throw new Error("CrowdSource has no source");
        }
        this.limit = source.getEnd();
        this.nchannel = source.getNumChannels();
        this.tcount = new int[this.nchannel];
        this.before = new int[this.nchannel];
        this.after = new int[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.tcount[i] = 0;
            this.before[i] = 0;
            this.after[i] = 0;
        }
        this.nlevel = 1;
        for (Source source2 = this.source; source2 != null; source2 = source2.getSource()) {
            ++this.nlevel;
        }
        this.checkParameters(0L);
    }

    private void checkParameters(long l) {
        this.crowd = this.getTapeParameters(l).getCrowd();
        if (this.crowd > 0) {
            int n = this.crowd + 5;
            if (this.history == null || this.history.length < n) {
                this.history = new int[n][][];
                for (int i = 0; i < this.history.length; ++i) {
                    this.history[i] = new int[this.nlevel][];
                    for (int j = 0; j < this.nlevel; ++j) {
                        this.history[i][j] = new int[this.nchannel];
                        for (int k = 0; k < this.nchannel; ++k) {
                            this.history[i][j][k] = 0;
                        }
                    }
                }
            }
        }
        this.historyIndex = 0;
    }

    @Override
    public TapeParameters getTapeParameters() {
        return this.getTapeParameters(this.getPosition());
    }

    @Override
    public TapeParameters getTapeParameters(long l) {
        return this.source.getTapeParameters(l);
    }

    @Override
    public String getName() {
        return "Cr";
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int getNumChannels() {
        return this.source.getNumChannels();
    }

    @Override
    public String getChannelName(int n) {
        return this.source.getChannelName(n);
    }

    @Override
    public long getStart() {
        return this.source.getStart();
    }

    @Override
    public long getEnd() {
        return this.source.getEnd();
    }

    @Override
    public void setStart(long l) {
        this.source.setStart(l);
    }

    @Override
    public void setEnd(long l) {
        this.source.setEnd(l);
    }

    @Override
    public long getLength() {
        return this.source.getLength();
    }

    @Override
    public long getPosition() {
        if (this.crowd > 0) {
            return this.source.getPosition() - (long)this.crowd - 1L;
        }
        return this.source.getPosition();
    }

    @Override
    public void setPosition(long l) {
        if (this.log != null) {
            try {
                this.log.write(l + ". Set " + ++this.setsn);
                this.log.newLine();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        this.checkParameters(l);
        this.lastPosition = l;
        if (this.crowd > 0) {
            this.source.setPosition(l - (long)this.crowd);
            for (int i = 0; i < this.nchannel; ++i) {
                this.tcount[i] = 0;
                this.before[i] = this.crowd + 1;
                this.after[i] = this.crowd + 1;
                for (int j = 0; j < this.history[0].length; ++j) {
                    for (int k = 0; k < this.history.length; ++k) {
                        this.history[k][j][i] = 0;
                    }
                }
            }
            this.setup = this.crowd;
            while (this.getPosition() < l) {
                this.advance();
            }
        } else {
            this.source.setPosition(l);
        }
    }

    @Override
    public void resetPosition() {
        this.setPosition(this.lastPosition);
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long l) {
        this.limit = l;
    }

    @Override
    public void resetLimit() {
        this.limit = this.source.getEnd();
    }

    @Override
    public boolean atLimit() {
        return this.getPosition() >= this.limit;
    }

    @Override
    public void advance() {
        if (this.crowd > 0) {
            int n;
            int n2;
            for (n2 = 1; n2 < this.nlevel; ++n2) {
                int[] nArray = this.source.getSamples(n2 - 1);
                for (n = 0; n < this.nchannel; ++n) {
                    this.history[this.historyIndex][n2][n] = nArray[n];
                }
            }
            n2 = 0;
            for (int i = 0; i < this.nchannel; ++i) {
                int n3;
                int n4;
                n = this.historyIndex - this.crowd;
                if (n < 0) {
                    n += this.history.length;
                }
                n2 = 0;
                if (this.before[i] < this.crowd) {
                    ++n2;
                    if (this.before[i] < this.crowd / 2) {
                        ++n2;
                    }
                }
                if (this.after[i] < this.crowd) {
                    --n2;
                    if (this.after[i] < this.crowd / 2) {
                        --n2;
                    }
                }
                if ((n4 = n + n2) < 0) {
                    n4 += this.history.length;
                } else if (n4 >= this.history.length) {
                    n4 -= this.history.length;
                }
                this.history[n][0][i] = this.history[n4][1][i];
                n = this.historyIndex - this.crowd - 3;
                if (n < 0) {
                    n += this.history.length;
                }
                if ((n3 = n - 1) < 0) {
                    n3 += this.history.length;
                }
                if (this.setup > 0) {
                    if (i == this.nchannel - 1) {
                        --this.setup;
                    }
                } else if (this.history[n][1][i] != 0 && this.history[n][1][i] != this.history[n3][1][i]) {
                    int n5 = i;
                    this.tcount[n5] = this.tcount[n5] - 1;
                    this.before[i] = this.after[i];
                    if (this.tcount[i] > 1) {
                        n += this.after[i];
                        this.after[i] = 1;
                        while (true) {
                            if (++n >= this.history.length) {
                                n -= this.history.length;
                            }
                            if (n == this.historyIndex) {
                                this.tcount[i] = 1;
                            } else {
                                n3 = n - 1;
                                if (n3 < 0) {
                                    n3 += this.history.length;
                                }
                                if (this.history[n][1][i] == 0 || this.history[n][1][i] == this.history[n3][1][i]) {
                                    int n6 = i;
                                    this.after[n6] = this.after[n6] + 1;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else {
                        this.after[i] = this.tcount[i] == 1 ? this.crowd + 3 - this.after[i] : this.crowd + 3;
                    }
                }
                n = this.historyIndex;
                n3 = this.historyIndex - 1;
                if (n3 < 0) {
                    n3 += this.history.length;
                }
                if (this.history[n][1][i] != 0 && this.history[n][1][i] != this.history[n3][1][i]) {
                    int n7 = i;
                    this.tcount[n7] = this.tcount[n7] + 1;
                    if (this.tcount[i] != 1) continue;
                    this.after[i] = 1;
                    continue;
                }
                if (this.tcount[i] != 1) continue;
                int n8 = i;
                this.after[n8] = this.after[n8] + 1;
            }
            if (this.log != null) {
                try {
                    this.log.write(this.getPosition() + "." + this.setsn + (this.setup > 0 ? "* " : "  ") + this.before[6] + " " + this.after[6] + " " + this.tcount[6] + " " + n2 + ": " + this.getSamples(0)[6] + " " + this.getSamples(1)[6] + " " + this.getSamples(2)[6] + " " + this.getSamples(3)[6] + " " + this.getSamples(4)[6] + "   ");
                    this.log.newLine();
                    this.log.flush();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
            ++this.historyIndex;
            if (this.historyIndex == this.history.length) {
                this.historyIndex = 0;
            }
        }
        this.source.advance();
    }

    @Override
    public int[] getSamples() {
        return this.getSamples(0);
    }

    @Override
    public int[] getSamples(int n) {
        if (this.crowd > 0) {
            int n2 = this.historyIndex - this.crowd - 1;
            if (n2 < 0) {
                n2 += this.history.length;
            }
            return this.history[n2][n];
        }
        if (n == 0) {
            return this.source.getSamples();
        }
        return this.source.getSamples(n - 1);
    }

    @Override
    public int getFlags() {
        return this.source.getFlags();
    }

    @Override
    public void close() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
    }
}

