/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.DataFile;
import com.piercefuller.a7trk.decode.RawSource;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DatRawSource
extends RawSource {
    private static final int Channels = 7;
    private static final String ChannelNames = "0123456P";
    private RandomAccessFile file = null;
    private final long length;
    private final int sampleSize = 16;
    private byte[] buf = new byte[16];
    private boolean phase = false;

    public DatRawSource(DataFile dataFile) throws Exception {
        super(dataFile);
        this.file = new RandomAccessFile(dataFile.getFilename(), "r");
        this.length = 2L * this.file.length() / 16L;
        this.initialize();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Object clone() {
        try {
            return new DatRawSource(this.getDatafile());
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    @Override
    public void readFlat(int[] nArray) throws Exception {
        int n;
        int n2;
        if (this.file == null) {
            throw new Error("Source closed");
        }
        this.phase = (this.getPosition() & 1L) != 0L;
        int n3 = 0;
        for (n2 = 0; n2 < 7; ++n2) {
            n = this.buf[n3++] & 0xFF;
            n += this.buf[n3++] << 8;
            nArray[n2] = n -= 2048;
        }
        if (this.phase) {
            this.file.read(this.buf, 0, 16);
            n3 = 0;
            for (n2 = 0; n2 < 7; ++n2) {
                n = this.buf[n3++] & 0xFF;
                n += this.buf[n3++] << 8;
                nArray[n2] = (nArray[n2] + (n -= 2048)) / 2;
            }
            this.phase = false;
        } else {
            this.phase = true;
        }
    }

    @Override
    public int getNumChannels() {
        return 7;
    }

    @Override
    public String getChannelName(int n) {
        return ChannelNames.substring(n, n + 1);
    }

    @Override
    public int getFlags() {
        int n = this.buf[14] & 0xFF;
        return ~(n += this.buf[15] << 8);
    }

    @Override
    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        this.file = null;
    }

    @Override
    public void sampleSeek(long l) throws IOException {
        if (this.file == null) {
            throw new Error("Source closed");
        }
        this.file.seek(16L * l);
        this.file.read(this.buf, 0, 16);
    }
}

