/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.DataFile;
import com.piercefuller.a7trk.decode.Record;
import com.piercefuller.a7trk.decode.TapeParameters;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.avparade.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataCollection {
    private DataFile datafile;
    private String filename;

    public DataFile getDataFile() {
        return this.datafile;
    }

    public DataCollection(DataFile dataFile) {
        this.datafile = dataFile;
        String string = dataFile.getFilename();
        int n = string.lastIndexOf(46);
        this.filename = n > 0 ? string.substring(0, n) + ".xml" : string + ".xml";
    }

    public DataCollection(String string) throws Exception {
        this.filename = string;
        this.load();
    }

    public void write() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.filename));
        bufferedWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        bufferedWriter.newLine();
        bufferedWriter.write("<collection xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        bufferedWriter.newLine();
        bufferedWriter.write("            xsi:schemaLocation=\"http://www.pcm.org/xml/collection.xsd collection.xsd\"");
        bufferedWriter.newLine();
        bufferedWriter.write("            xmlns=\"http://www.pcm.org/xml/collection.xsd\">");
        if (this.datafile.getArtifactId() != null) {
            bufferedWriter.write("  <artifact id=\"" + this.datafile.getArtifactId() + "\"/>");
            bufferedWriter.newLine();
        }
        this.datafile.write(bufferedWriter, 2);
        bufferedWriter.write("</collection>");
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    private void parseList(String string, int[] nArray) {
        int n = 0;
        int n2 = string.indexOf(44);
        if (n2 > 0) {
            int n3 = 0;
            while (true) {
                nArray[n3] = Integer.parseInt(string.substring(n, n2));
                if (n3 != this.datafile.getChannels() - 1) {
                    n = n2 + 1;
                    n2 = n3 < this.datafile.getChannels() - 2 ? string.indexOf(44, n) : string.length();
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            int n4 = Integer.parseInt(string);
            for (int i = 0; i < this.datafile.getChannels(); ++i) {
                nArray[i] = n4;
            }
        }
    }

    private void load() throws Exception {
        Object object;
        XMLHandler xMLHandler = XMLHandler.Factory.getInstance();
        Document document = xMLHandler.parse(new File(this.filename), null);
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("datafile");
        if (nodeList.getLength() != 1) {
            throw new Exception("Only support one file in datafile collection");
        }
        Element element = (Element)nodeList.item(0);
        if (!"tape".equals(element.getAttribute("form"))) {
            throw new Exception("Data file must be tape form");
        }
        this.datafile = new DataFile(element.getAttribute("filename"), Integer.parseInt(element.getAttribute("channels")), -1, -1);
        boolean bl = !"reverse".equals(element.getAttribute("direction"));
        NodeList nodeList2 = element.getElementsByTagName("tapeparameters");
        int[] nArray = new int[this.datafile.getChannels()];
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            int n;
            Element element2 = (Element)nodeList2.item(i);
            object = this.datafile.getTapeParameters().add(Long.parseLong(element2.getAttribute("start")), Long.parseLong(element2.getAttribute("end")));
            String string = element2.getAttribute("gain");
            if (string != null && string.length() > 0) {
                ((TapeParameters)object).setGain(Double.parseDouble(string));
            }
            if ((string = element2.getAttribute("skew")) != null && string.length() > 0) {
                this.parseList(string, ((TapeParameters)object).getSkew());
            }
            if ((string = element2.getAttribute("width")) != null && string.length() > 0) {
                ((TapeParameters)object).setWidth(Integer.parseInt(string));
            }
            boolean bl2 = false;
            string = element2.getAttribute("lowclip");
            if (string != null && string.length() > 0) {
                bl2 = Boolean.parseBoolean(string);
            }
            if ((string = element2.getAttribute("clip")) != null && string.length() > 0) {
                this.parseList(string, nArray);
                for (n = 0; n < this.datafile.getChannels(); ++n) {
                    ((TapeParameters)object).setClip(nArray[n], bl2, n);
                }
            }
            if ((string = element2.getAttribute("baselimit")) != null && string.length() > 0) {
                this.parseList(string, ((TapeParameters)object).getBaseLimit());
            } else if (bl2 && !((TapeParameters)object).getParent().getLowClip()) {
                for (n = 0; n < this.datafile.getChannels(); ++n) {
                    ((TapeParameters)object).getBaseLimit()[n] = 3 * ((TapeParameters)object).getClip(true, n) / 2;
                }
            }
            string = element2.getAttribute("crowd");
            if (string != null && string.length() > 0) {
                ((TapeParameters)object).setCrowd(Integer.parseInt(string));
            }
            if ((string = element2.getAttribute("lowspace")) != null && string.length() > 0) {
                ((TapeParameters)object).setLowSpace(Integer.parseInt(string));
            }
            if ((string = element2.getAttribute("highspace")) != null && string.length() > 0) {
                ((TapeParameters)object).setHighSpace(Integer.parseInt(string));
            }
            if ((string = element2.getAttribute("gather")) != null && string.length() > 0) {
                ((TapeParameters)object).setGather(Integer.parseInt(string));
            }
            if ((string = element2.getAttribute("maxspace")) != null && string.length() > 0) {
                ((TapeParameters)object).setMaxSpace(Integer.parseInt(string));
            }
            if ((string = element2.getAttribute("mingap")) != null && string.length() > 0) {
                ((TapeParameters)object).setMinGap(Integer.parseInt(string));
            }
            if ((string = element2.getAttribute("maxjunk")) == null || string.length() <= 0) continue;
            ((TapeParameters)object).setMaxJunk(Integer.parseInt(string));
        }
        NodeList nodeList3 = element.getElementsByTagName("record");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            object = (Element)nodeList3.item(i);
            long l = Long.parseLong(object.getAttribute("start"));
            Record record = new Record(i + 1, l, Long.parseLong(object.getAttribute("end")), bl);
            String string = object.getAttribute("errors");
            if (string != null && string.length() > 0) {
                record.setErrors(Integer.parseInt(string));
            }
            if (this.datafile.getTapeParameters().getCount() > 0) {
                TapeParameters tapeParameters = this.datafile.getTapeParameters().getTapeParameters(l);
            }
            this.datafile.getRecords().add(record);
        }
        String string = element.getAttribute("artifact");
        if (string != null && string.length() > 0) {
            this.datafile.setArtifactId(string);
        }
        this.datafile.setStart(Long.parseLong(element.getAttribute("start")));
        this.datafile.setEnd(Long.parseLong(element.getAttribute("end")));
    }
}

