/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.BaselineSource;
import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeParameters;

public class DirSource
implements Source {
    private final String Name = "Dir";
    private Source source;
    private long lastPosition = 0L;
    private long limit = 0L;
    private int nchannel = 0;
    private int nlevel = 0;
    private int[][] history;
    private int[] max;
    private int[] min;

    public DirSource(Source source) {
        this.source = source;
        if (this.source == null) {
            throw new Error("DirSource has no source");
        }
        if (!(this.source instanceof BaselineSource)) {
            throw new Error("DirSource must be based on BaselineSource");
        }
        this.limit = source.getEnd();
        this.nchannel = source.getNumChannels();
        this.max = new int[this.nchannel];
        this.min = new int[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.max[i] = 0;
            this.min[i] = 0;
        }
        this.nlevel = 1;
        for (Source source2 = this.source; source2 != null; source2 = source2.getSource()) {
            ++this.nlevel;
        }
        this.history = new int[this.nlevel][];
        for (int i = 0; i < this.nlevel; ++i) {
            this.history[i] = new int[this.nchannel];
            for (int j = 0; j < this.nchannel; ++j) {
                this.history[i][j] = 0;
            }
        }
    }

    @Override
    public TapeParameters getTapeParameters() {
        return this.getTapeParameters(this.getPosition());
    }

    @Override
    public TapeParameters getTapeParameters(long l) {
        return this.source.getTapeParameters(l);
    }

    @Override
    public String getName() {
        return "Dir";
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int getNumChannels() {
        return this.source.getNumChannels();
    }

    @Override
    public String getChannelName(int n) {
        return this.source.getChannelName(n);
    }

    @Override
    public long getStart() {
        return this.source.getStart();
    }

    @Override
    public long getEnd() {
        return this.source.getEnd();
    }

    @Override
    public void setStart(long l) {
        this.source.setStart(l);
    }

    @Override
    public void setEnd(long l) {
        this.source.setEnd(l);
    }

    @Override
    public long getLength() {
        return this.source.getLength();
    }

    @Override
    public long getPosition() {
        return this.source.getPosition() - 1L;
    }

    @Override
    public void setPosition(long l) {
        this.lastPosition = l;
        this.source.setPosition(l);
        for (int i = 0; i < this.nchannel; ++i) {
            this.max[i] = 0;
            this.min[i] = 0;
            for (int j = 0; j < this.history.length; ++j) {
                this.history[j][i] = 0;
            }
        }
        this.advance();
    }

    @Override
    public void resetPosition() {
        this.setPosition(this.lastPosition);
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long l) {
        this.limit = l;
    }

    @Override
    public void resetLimit() {
        this.limit = this.source.getEnd();
    }

    @Override
    public boolean atLimit() {
        return this.source.getPosition() - 1L >= this.limit;
    }

    @Override
    public void advance() {
        int n;
        int n2;
        boolean bl = ((BaselineSource)this.source).inBaseline(this.getPosition());
        for (n2 = 1; n2 < this.nlevel; ++n2) {
            int[] nArray = this.source.getSamples(n2 - 1);
            for (n = 0; n < this.nchannel; ++n) {
                this.history[n2][n] = nArray[n];
            }
        }
        for (n2 = 0; n2 < this.nchannel; ++n2) {
            int n3 = this.history[0][n2];
            n = this.history[1][n2];
            if (n < 0) {
                this.max[n2] = 0;
                if (n3 > 0) {
                    n3 = 0;
                }
            } else if (n >= this.max[n2]) {
                this.max[n2] = n;
            } else if (this.max[n2] > this.getTapeParameters().getClip(bl, n2)) {
                n3 = this.max[n2];
            }
            if (n > 0) {
                this.min[n2] = 0;
                if (n3 < 0) {
                    n3 = 0;
                }
            } else if (n < this.min[n2]) {
                this.min[n2] = n;
            } else if (this.min[n2] < -this.getTapeParameters().getClip(bl, n2)) {
                n3 = this.min[n2];
            }
            this.history[0][n2] = n3;
        }
        this.source.advance();
    }

    @Override
    public int[] getSamples() {
        return this.getSamples(0);
    }

    @Override
    public int[] getSamples(int n) {
        return this.history[n];
    }

    @Override
    public int getFlags() {
        return this.source.getFlags();
    }

    @Override
    public void close() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
    }
}

