/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;

public class HpfFile {
    private static final int[] DataSize = new int[]{2, 2, 4, 4, 8};
    private RandomAccessFile file = null;
    private final DataType dataType = DataType.Double;
    private final Index index;
    private final ChannelInformation channelInformation;
    private final DataChunk dataChunk;

    private byte[] readChunk(long l) throws Exception {
        return this.readChunk(l, new byte[16]);
    }

    private byte[] readChunk(long l, byte[] byArray) throws Exception {
        this.file.seek(l);
        this.file.read(byArray, 0, 16);
        long l2 = this.assembleInteger(byArray, 8, 8);
        if (l2 < 65536L || l2 > 0x40000000L) {
            throw new Exception("Invalid chunk of size " + l2);
        }
        if ((long)byArray.length < l2) {
            byArray = Arrays.copyOf(byArray, (int)l2);
        }
        this.file.read(byArray, 16, (int)l2 - 16);
        return byArray;
    }

    private Chunk getChunk(long l) throws Exception {
        Chunk chunk = new Chunk(l);
        long l2 = chunk.getChunkId();
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw new Exception("Invalid chunk Id");
        }
        switch ((int)l2) {
            case 4096: {
                return new Header(chunk.buffer);
            }
            case 8192: {
                return new ChannelInformation(chunk.buffer);
            }
            case 12288: {
                return new DataChunk(chunk.buffer, l);
            }
            case 24576: {
                return new Index(chunk.buffer);
            }
        }
        return chunk;
    }

    public HpfFile(String string) throws Exception {
        Chunk chunk;
        this.file = new RandomAccessFile(string, "r");
        Header header = (Header)this.getChunk(0L);
        do {
            if (!((chunk = this.getChunk(this.file.getFilePointer())) instanceof ChannelInformation)) continue;
            this.channelInformation = (ChannelInformation)chunk;
            this.index = new Index(header.getIndexChunkOffset());
            this.dataChunk = new DataChunk(this.index.getEntry(0L));
            return;
        } while (!(chunk instanceof DataChunk));
        throw new Exception("Channel Information not found");
    }

    public void getSamples(int[] nArray, long l, double d, double d2) throws Exception {
        if (!this.dataChunk.contains(l)) {
            this.dataChunk.setIndexEntry(this.index.getEntry(l));
        }
        this.dataChunk.getSamples(nArray, l, d, d2);
    }

    public int getChannels() {
        return this.channelInformation.getChannels();
    }

    public int getTotalSamples() {
        return (int)this.index.getTotalSamples();
    }

    private long assembleInteger(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        this.file = null;
    }

    private class DataChunk
    extends Chunk {
        private IndexEntry indexEntry;
        private int[] offsets;

        public DataChunk(IndexEntry indexEntry) throws Exception {
            super(indexEntry.getFileOffset());
            this.finishSetIndexEntry(indexEntry);
        }

        private DataChunk(byte[] byArray, long l) {
            super(byArray);
            this.indexEntry = new IndexEntry(HpfFile.this.assembleInteger(byArray, 20, 8), HpfFile.this.assembleInteger(byArray, 36, 4), this.getChunkId(), HpfFile.this.assembleInteger(byArray, 16, 4), l);
            this.setOffsets();
        }

        public IndexEntry getIndexEntry() {
            return this.indexEntry;
        }

        private void finishSetIndexEntry(IndexEntry indexEntry) throws Exception {
            this.indexEntry = indexEntry;
            if (this.getChunkId() != indexEntry.getChunkId()) {
                throw new Exception("Invalid data block id");
            }
            if ((long)this.getGroupId() != indexEntry.getGroupId()) {
                throw new Exception("Invalid data group id");
            }
            this.setOffsets();
        }

        private void setOffsets() {
            int n = this.getChannels();
            if (this.offsets == null || this.offsets.length != n) {
                if (this.offsets != null) {
                    System.err.println("Number of channels changed!");
                }
                this.offsets = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                this.offsets[i] = (int)HpfFile.this.assembleInteger(this.buffer, 8 * i + 32, 4);
            }
        }

        public int getGroupId() {
            return (int)HpfFile.this.assembleInteger(this.buffer, 16, 4);
        }

        public int getChannels() {
            return (int)HpfFile.this.assembleInteger(this.buffer, 28, 4);
        }

        public boolean contains(long l) {
            return this.indexEntry.getSampleOffset() <= l && l < this.indexEntry.getSampleOffset() + this.indexEntry.getSampleCount();
        }

        public void getSamples(int[] nArray, long l, double d, double d2) {
            int n = DataSize[HpfFile.this.dataType.ordinal()];
            block6: for (int i = 0; i < nArray.length && i < HpfFile.this.dataChunk.getChannels(); ++i) {
                long l2 = HpfFile.this.assembleInteger(this.buffer, this.offsets[i] + n * (int)(l - this.indexEntry.getSampleOffset()), n);
                switch (HpfFile.this.dataType) {
                    case Int16: {
                        if ((l2 & 0x8000L) != 0L) {
                            l2 = 65536L - l2;
                        }
                    }
                    case Uint16: 
                    case Int32: {
                        nArray[i] = (int)(d2 * ((double)l2 - d));
                        continue block6;
                    }
                    case Float: {
                        float f = Float.intBitsToFloat((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
                        nArray[i] = (int)(d2 * ((double)f - d));
                        continue block6;
                    }
                    case Double: {
                        double d3 = Double.longBitsToDouble(l2);
                        nArray[i] = (int)(d2 * (d3 - d));
                    }
                }
            }
        }

        public void setIndexEntry(IndexEntry indexEntry) throws Exception {
            this.buffer = HpfFile.this.readChunk(indexEntry.getFileOffset(), this.buffer);
            this.finishSetIndexEntry(indexEntry);
        }
    }

    private class ChannelInformation
    extends Chunk {
        public ChannelInformation(byte[] byArray) {
            super(byArray);
        }

        public ChannelInformation(long l) throws Exception {
            super(l);
        }

        public int getGroupId() {
            return (int)HpfFile.this.assembleInteger(this.buffer, 16, 4);
        }

        public int getChannels() {
            return (int)HpfFile.this.assembleInteger(this.buffer, 20, 4);
        }
    }

    private class Index
    extends Chunk {
        private final IndexEntry[] indexEntries;

        public Index(long l) throws Exception {
            super(l);
            if (this.getChunkId() != 24576L) {
                throw new Exception("Data index not found");
            }
            this.indexEntries = this.extractEntries();
            this.buffer = null;
        }

        public Index(byte[] byArray) throws Exception {
            super(byArray);
            this.indexEntries = this.extractEntries();
            this.buffer = null;
        }

        private IndexEntry[] extractEntries() throws Exception {
            long l = HpfFile.this.assembleInteger(this.buffer, 16, 8);
            if (l <= 0L || l > (long)((this.buffer.length - 24) / 5)) {
                throw new Exception("Invalid data index");
            }
            IndexEntry[] indexEntryArray = new IndexEntry[(int)l];
            long[] lArray = new long[5];
            int n = 0;
            while ((long)n < l) {
                for (int i = 0; i < 5; ++i) {
                    lArray[i] = HpfFile.this.assembleInteger(this.buffer, 8 * (5 * n + i) + 24, 8);
                }
                indexEntryArray[n] = new IndexEntry(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
                ++n;
            }
            return indexEntryArray;
        }

        public long getTotalSamples() {
            return this.indexEntries[this.indexEntries.length - 1].getSampleOffset() + this.indexEntries[this.indexEntries.length - 1].getSampleCount();
        }

        public IndexEntry getEntry(long l) {
            int n = Arrays.binarySearch(this.indexEntries, new IndexEntry(l, 1L, 0L, 0L, 0L), new Comparator<IndexEntry>(){

                @Override
                public int compare(IndexEntry indexEntry, IndexEntry indexEntry2) {
                    return Long.compare(indexEntry.getSampleOffset(), indexEntry2.getSampleOffset());
                }
            });
            if (n < 0) {
                n = -n - 2;
            }
            return this.indexEntries[n];
        }
    }

    private class IndexEntry {
        private final long sampleOffset;
        private final long sampleCount;
        private final long chunkId;
        private final long groupId;
        private final long fileOffset;

        public IndexEntry(long l, long l2, long l3, long l4, long l5) {
            this.sampleOffset = l;
            this.sampleCount = l2;
            this.chunkId = l3;
            this.groupId = l4;
            this.fileOffset = l5;
        }

        public long getSampleOffset() {
            return this.sampleOffset;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getChunkId() {
            return this.chunkId;
        }

        public long getGroupId() {
            return this.groupId;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }
    }

    private class Header
    extends Chunk {
        public Header() throws Exception {
            super(0L);
            if (this.getChunkId() != 4096L) {
                throw new Exception("Invalid header chunk Id");
            }
        }

        private Header(byte[] byArray) {
            super(byArray);
        }

        public int getCreatorId() {
            return (int)HpfFile.this.assembleInteger(this.buffer, 16, 4);
        }

        public long getFileVersion() {
            return HpfFile.this.assembleInteger(this.buffer, 20, 8);
        }

        public long getIndexChunkOffset() {
            return HpfFile.this.assembleInteger(this.buffer, 28, 8);
        }
    }

    private class Chunk {
        byte[] buffer;

        Chunk(long l) throws Exception {
            this(hpfFile.readChunk(l));
        }

        Chunk(byte[] byArray) {
            this.buffer = byArray;
        }

        public long getChunkId() {
            return HpfFile.this.assembleInteger(this.buffer, 0, 8);
        }
    }

    private static enum DataType {
        Int16,
        Uint16,
        Int32,
        Float,
        Double;

    }
}

