/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.DataFile;
import com.piercefuller.a7trk.decode.HpfFile;
import com.piercefuller.a7trk.decode.RawSource;
import java.io.IOException;

public class HpfRawSource
extends RawSource {
    private static final String ChannelNames = "0123456789";
    private HpfFile hpfFile;
    private final long length;
    private final int channels;
    private final int[] altSamples;
    private long samplePosition = 0L;

    public HpfRawSource(DataFile dataFile) throws Exception {
        super(dataFile);
        this.hpfFile = new HpfFile(dataFile.getFilename());
        this.length = 2 * this.hpfFile.getTotalSamples();
        this.channels = this.hpfFile.getChannels();
        this.altSamples = new int[this.channels];
        this.initialize();
    }

    @Override
    public int getNumChannels() {
        return this.channels;
    }

    @Override
    public String getChannelName(int n) {
        return ChannelNames.substring(n, n + 1);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public int getFlags() {
        return 0;
    }

    @Override
    public void close() {
        if (this.hpfFile != null) {
            try {
                this.hpfFile.close();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        this.hpfFile = null;
    }

    @Override
    public Object clone() {
        try {
            return new HpfRawSource(this.getDatafile());
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    @Override
    public void sampleSeek(long l) throws IOException {
        if (this.hpfFile == null) {
            throw new Error("Source closed");
        }
        this.samplePosition = l;
    }

    @Override
    public void readFlat(int[] nArray) throws Exception {
        if (this.hpfFile == null) {
            throw new Error("Source closed");
        }
        this.hpfFile.getSamples(nArray, this.samplePosition, 0.0, this.getTapeParameters().getGain());
        if ((this.getPosition() & 1L) != 0L) {
            ++this.samplePosition;
            this.hpfFile.getSamples(this.altSamples, this.samplePosition, 0.0, this.getTapeParameters().getGain());
            for (int i = 0; i < this.channels; ++i) {
                nArray[i] = (nArray[i] + this.altSamples[i]) / 2;
            }
        }
    }
}

