/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeParameters;

public class LumpSource
implements Source {
    private final String Name = "Lump";
    private Source source;
    private long lastPosition = 0L;
    private long limit = 0L;
    private int nchannel;
    private int[][] history;
    private int historyIndex = 0;
    private int[] sum;

    public LumpSource(Source source) {
        this.source = source;
        if (source == null) {
            throw new Error("No source");
        }
        this.limit = source.getEnd();
        this.nchannel = source.getNumChannels();
        this.sum = new int[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.sum[i] = 0;
        }
        this.setPosition(0L);
    }

    @Override
    public TapeParameters getTapeParameters() {
        return this.source.getTapeParameters();
    }

    @Override
    public TapeParameters getTapeParameters(long l) {
        return this.source.getTapeParameters(l);
    }

    private void checkParameter(long l) {
        if (l < 0L) {
            l = 0L;
        }
        TapeParameters tapeParameters = this.source.getTapeParameters(l);
        if (this.history == null || this.history.length != tapeParameters.getWidth()) {
            this.history = new int[tapeParameters.getWidth()][];
            for (int i = 0; i < this.history.length; ++i) {
                this.history[i] = new int[this.nchannel];
            }
        }
    }

    @Override
    public String getName() {
        return "Lump";
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int getNumChannels() {
        return this.source.getNumChannels();
    }

    @Override
    public String getChannelName(int n) {
        return this.source.getChannelName(n);
    }

    @Override
    public long getStart() {
        return this.source.getStart();
    }

    @Override
    public long getEnd() {
        return this.source.getEnd();
    }

    @Override
    public void setStart(long l) {
        this.source.setStart(l);
    }

    @Override
    public void setEnd(long l) {
        this.source.setEnd(l);
    }

    @Override
    public long getLength() {
        return this.source.getLength();
    }

    @Override
    public long getPosition() {
        return this.source.getPosition() - (long)(this.history.length / 2);
    }

    @Override
    public void setPosition(long l) {
        int n;
        if (this.source == null) {
            throw new Error("Source is closed");
        }
        this.checkParameter(l);
        this.source.setPosition(l - (long)(this.history.length / 2) - 1L);
        for (n = 0; n < this.nchannel; ++n) {
            this.sum[n] = 0;
        }
        this.historyIndex = 0;
        while (this.historyIndex < this.history.length) {
            for (n = 0; n < this.nchannel; ++n) {
                this.history[this.historyIndex][n] = 0;
            }
            ++this.historyIndex;
        }
        this.historyIndex = 0;
        while (this.getPosition() < l) {
            this.advance();
        }
        this.lastPosition = this.getPosition();
    }

    @Override
    public void resetPosition() {
        this.setPosition(this.lastPosition);
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long l) {
        this.limit = l;
    }

    @Override
    public void resetLimit() {
        this.limit = this.source.getEnd();
    }

    @Override
    public boolean atLimit() {
        return this.getPosition() >= this.limit;
    }

    @Override
    public void advance() {
        ++this.historyIndex;
        if (this.historyIndex == this.history.length) {
            this.historyIndex = 0;
        }
        int[] nArray = this.source.getSamples();
        for (int i = 0; i < this.nchannel; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] - this.history[this.historyIndex][i];
            this.history[this.historyIndex][i] = nArray[i];
            int n2 = i;
            this.sum[n2] = this.sum[n2] + this.history[this.historyIndex][i];
        }
        this.source.advance();
    }

    @Override
    public int[] getSamples() {
        return this.sum;
    }

    @Override
    public int[] getSamples(int n) {
        if (n > 1) {
            throw new Error("GetSamples level > 1 in LumpSource");
        }
        if (n == 0) {
            return this.getSamples();
        }
        int n2 = this.historyIndex - this.history.length / 2;
        if (n2 < 0) {
            n2 += this.history.length;
        }
        if (this.history[n2] != null) {
            return this.history[n2];
        }
        int[] nArray = new int[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            nArray[i] = 0;
        }
        return nArray;
    }

    @Override
    public int getFlags() {
        return this.source.getFlags();
    }

    @Override
    public void close() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
    }
}

