/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.DatRawSource;
import com.piercefuller.a7trk.decode.DataFile;
import com.piercefuller.a7trk.decode.HpfRawSource;
import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.TapeParameters;
import java.io.IOException;
import java.util.Arrays;

public abstract class RawSource
implements Source {
    public static final int FlagBOT = 256;
    public static final int FlagEOT = 512;
    public static final int FlagForward = 1;
    public static final int FlagReverse = 2;
    private static final String Name = "Raw";
    private static final int MaxSkew = 10;
    private DataFile datafile;
    private long startPos = 0L;
    private long endPos = 0L;
    private long position = 0L;
    private long lastPosition = 0L;
    private long limit = 0L;
    private int[][] history = new int[10][];
    private int historyIndex = 0;

    public RawSource(DataFile dataFile) {
        this.datafile = dataFile;
    }

    public void initialize() throws Exception {
        this.limit = this.getLength();
        if (this.datafile.getEnd() > 0L) {
            this.startPos = this.datafile.getStart();
            this.endPos = this.datafile.getEnd();
        } else {
            this.startPos = 0L;
            this.endPos = this.getLength();
            this.datafile.setStart(this.startPos);
            this.datafile.setEnd(this.endPos);
        }
        for (int i = 0; i < 10; ++i) {
            this.history[i] = new int[this.getNumChannels()];
            for (int j = 0; j < this.getNumChannels(); ++j) {
                this.history[i][j] = 0;
            }
        }
        this.internalSetPosition(0L);
    }

    public abstract Object clone();

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public Source getSource() {
        return null;
    }

    @Override
    public TapeParameters getTapeParameters() {
        return this.getTapeParameters(this.getPosition());
    }

    @Override
    public TapeParameters getTapeParameters(long l) {
        return this.datafile.getTapeParameters().getTapeParameters(l);
    }

    @Override
    public long getStart() {
        return this.startPos;
    }

    @Override
    public long getEnd() {
        return this.endPos;
    }

    @Override
    public synchronized void setStart(long l) {
        try {
            this.datafile.setStart(l);
            this.startPos = l;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public synchronized void setEnd(long l) {
        try {
            this.datafile.setEnd(l);
            this.endPos = l;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public synchronized void setPosition(long l) {
        try {
            this.lastPosition = l;
            this.internalSetPosition(l);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public synchronized void resetPosition() {
        try {
            this.internalSetPosition(this.lastPosition);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long l) {
        this.limit = l;
    }

    @Override
    public void resetLimit() {
        this.limit = this.getLength();
    }

    @Override
    public boolean atLimit() {
        return this.position >= this.limit;
    }

    protected void internalSetPosition(long l) throws Exception {
        for (int i = 0; i < this.history.length; ++i) {
            for (int j = 0; j < this.getNumChannels(); ++j) {
                this.history[i][j] = 0;
            }
        }
        this.position = l - 10L;
        long l2 = this.position / 2L;
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.sampleSeek(l2);
        this.historyIndex = 0;
        while (this.position < l) {
            if (this.position >= 0L && this.position >= this.lastPosition && this.position < this.limit) {
                this.readFlat(this.history[this.historyIndex]);
            } else {
                Arrays.fill(this.history[this.historyIndex], 0);
            }
            ++this.position;
            ++this.historyIndex;
        }
        --this.historyIndex;
    }

    public abstract void sampleSeek(long var1) throws IOException;

    public abstract void readFlat(int[] var1) throws Exception;

    public DataFile getDatafile() {
        return this.datafile;
    }

    public void setDatafile(DataFile dataFile) {
        this.datafile = dataFile;
    }

    @Override
    public synchronized void advance() {
        ++this.historyIndex;
        if (this.historyIndex == 10) {
            this.historyIndex = 0;
        }
        try {
            if (this.position >= 0L && this.position >= this.lastPosition && this.position < this.limit) {
                this.readFlat(this.history[this.historyIndex]);
            } else {
                Arrays.fill(this.history[this.historyIndex], 0);
            }
            ++this.position;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public synchronized int[] getSamples() {
        int[] nArray = new int[this.getNumChannels()];
        for (int i = 0; i < this.getNumChannels(); ++i) {
            int n = this.historyIndex;
            TapeParameters tapeParameters = this.getTapeParameters();
            if (tapeParameters != null) {
                n -= tapeParameters.getSkew()[i];
            }
            if (n < 0) {
                n += 10;
            }
            nArray[i] = this.history[n][i];
        }
        return nArray;
    }

    @Override
    public synchronized int[] getSamples(int n) {
        if (n > 0) {
            throw new Error("GetSamples level > 0 in RawSource");
        }
        return this.getSamples();
    }

    public static RawSource getInstance(DataFile dataFile) throws Exception {
        String string = dataFile.getFilename();
        if (string.toLowerCase().endsWith(".dat")) {
            return new DatRawSource(dataFile);
        }
        if (string.toLowerCase().endsWith(".hpf")) {
            return new HpfRawSource(dataFile);
        }
        throw new Exception("Unsupported file extension on file \"" + string + "\"");
    }
}

