/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.TapeParameters;
import java.io.BufferedWriter;
import java.io.IOException;

public class RecordInfo {
    private final int Scale = 1000;
    private final int MinDensity = 500;
    private long position;
    private int[] transitions = null;
    private boolean[] transitionError = null;
    private int[] profile = null;
    private int[] lumped = null;
    private int[] density = null;
    private int[] status = null;
    private int[] data = null;
    private int index;
    private int dataCount;
    private boolean hasLRC;
    private int nchannel;
    private int datamark;
    private int datamask;
    private int[] parity;
    private int bits;
    private int transitionErrorCount;
    private int errors;
    private int fixups;
    private int goodParity = 0;
    private int start = 0;
    private int finish = 0;
    private int spacing = 0;
    private int[] autocorr = null;
    private BufferedWriter log = null;
    private int logsn = 0;

    public RecordInfo(long l, int n, int n2) {
        this.nchannel = n2;
        this.datamark = 1 << n2;
        this.datamask = (1 << n2) - 1;
        this.reset(l, n);
    }

    public int getStatus(int n) {
        if (n < 0 || n >= this.index) {
            return 0;
        }
        return this.status[n];
    }

    public void setTransition(int n) {
        ++this.bits;
        if (this.index < this.transitions.length) {
            int n2 = this.index;
            this.transitions[n2] = this.transitions[n2] | 1 << n;
        }
    }

    public void missing() {
        this.transitionError[this.index] = true;
        ++this.transitionErrorCount;
    }

    public int getBits() {
        return this.bits;
    }

    public int getMissing() {
        return this.transitionErrorCount;
    }

    public int getCount(int n) {
        if (n < 0 || n >= this.index) {
            return 0;
        }
        int n2 = 0;
        if (this.transitions[n] != 0) {
            int n3 = 0;
            while (1 << n3 <= this.transitions[n]) {
                if ((this.transitions[n] & 1 << n3) != 0) {
                    ++n2;
                }
                ++n3;
            }
        }
        return n2;
    }

    public int getLumped(int n) {
        if (n < 0 || n >= this.index) {
            return 0;
        }
        return this.lumped[n];
    }

    public int getSpacing() {
        return this.spacing;
    }

    public boolean isDataValid(int n) {
        if (n <= 0 || this.data == null || n >= this.index) {
            return false;
        }
        return (this.data[n] & this.datamark) != 0;
    }

    public int getData(int n) {
        return this.getDataPoint(n) & this.datamask;
    }

    public int getDataPoint(int n) {
        if (n <= 0 || this.data == null || n >= this.index) {
            return 0;
        }
        return this.data[n];
    }

    public byte[] getData(boolean bl) {
        if (this.dataCount == 0) {
            return null;
        }
        int n = this.hasLRC ? this.dataCount - 1 : this.dataCount;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = n - 1;
        if (bl) {
            n3 = -1;
            n4 = n - 1;
            n5 = 0;
        }
        int n6 = n4;
        while (true) {
            if (n2 < this.data.length && (this.data[n2] == 0 || this.status[n2] > 4)) {
                ++n2;
                continue;
            }
            if (n2 >= this.data.length) {
                throw new Error("RecordInfo internal error, data count too large");
            }
            byArray[n6] = (byte)(this.data[n2] & this.datamask);
            ++n2;
            if (n6 == n5) break;
            n6 += n3;
        }
        return byArray;
    }

    public long getStart() {
        return this.position;
    }

    public int getLength() {
        return this.index;
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public void reset(long l, int n) {
        this.position = l;
        if (this.transitions == null || this.transitions.length < n) {
            this.transitions = new int[n];
        }
        if (this.transitionError == null || this.transitionError.length < n) {
            this.transitionError = new boolean[n];
        }
        this.index = 0;
        this.errors = 0;
        this.fixups = 0;
        this.dataCount = 0;
        this.hasLRC = false;
        this.bits = 0;
        this.transitionErrorCount = 0;
        this.transitions[0] = 0;
        this.transitionError[0] = false;
    }

    public void increment() {
        ++this.index;
        if (this.status != null && this.index < this.status.length) {
            this.status[this.index] = 0;
        }
        if (this.index < this.transitions.length) {
            this.transitions[this.index] = 0;
            this.transitionError[this.index] = false;
        }
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFixups() {
        return this.fixups;
    }

    private void setupProfile(int n) {
        int n2;
        if (this.profile != null && this.profile.length == 2 * n) {
            return;
        }
        this.profile = new int[2 * n];
        this.profile[0] = n * n;
        for (n2 = 1; n2 < n; ++n2) {
            this.profile[n2] = this.profile[n2 - 1] - n2;
        }
        for (n2 = n; n2 < 2 * n; ++n2) {
            this.profile[n2] = this.profile[n2 - 1] - (2 * n - n2);
        }
    }

    private void addProfile(int n, int n2) {
        n2 /= this.profile[0];
        for (int i = 0; i < this.profile.length; ++i) {
            if (n - i >= 0 && n - i < this.lumped.length) {
                int n3 = n - i;
                this.lumped[n3] = this.lumped[n3] + n2 * this.profile[i];
            }
            if (i <= 0 || n + i >= this.lumped.length) continue;
            int n4 = n + i;
            this.lumped[n4] = this.lumped[n4] + n2 * this.profile[i];
        }
    }

    private void lumpTransitions(TapeParameters tapeParameters) {
        int n;
        int n2 = 4 * tapeParameters.getGather();
        int[] nArray = new int[n2];
        this.setupProfile(tapeParameters.getGather());
        for (n = 0; n < n2; ++n) {
            nArray[n] = 0;
        }
        if (this.lumped == null || this.lumped.length < this.index) {
            this.lumped = new int[this.index];
        }
        for (n = 0; n < this.index; ++n) {
            this.lumped[n] = 0;
        }
        n = 0;
        int n3 = 0;
        for (int i = -n2 / 2; i < this.index; ++i) {
            int n4;
            int n5 = 0;
            if (i + n2 / 2 < this.index && this.transitions[i + n2 / 2] != 0) {
                n4 = 0;
                while (1 << n4 <= this.transitions[i + n2 / 2]) {
                    if ((this.transitions[i + n2 / 2] & 1 << n4) != 0) {
                        ++n5;
                    }
                    ++n4;
                }
            }
            n3 -= nArray[n];
            n3 += n5;
            nArray[n] = n5;
            if (++n == n2) {
                n = 0;
            }
            if (i < 0) continue;
            n4 = n - n2 / 2;
            if (n4 < 0) {
                n4 += n2;
            }
            if ((n5 = nArray[n4]) <= 0) continue;
            this.addProfile(i, 1000 * n5 / n3);
        }
    }

    private void evaluateSpacing(TapeParameters tapeParameters) {
        int n;
        if (this.status == null || this.status.length < this.index) {
            this.status = new int[this.index];
        }
        if (this.data == null || this.data.length < this.index) {
            this.data = new int[this.index];
        }
        for (n = 0; n < this.index; ++n) {
            this.data[n] = 0;
        }
        this.start = 0;
        while (this.start < this.index && this.transitions[this.start] == 0) {
            ++this.start;
        }
        this.finish = this.index - 1;
        while (this.finish > this.start && this.transitions[this.finish] == 0) {
            --this.finish;
        }
        this.start -= tapeParameters.getGather();
        if (this.start < 0) {
            this.start = 0;
        }
        this.finish += tapeParameters.getGather();
        if (this.finish > this.index) {
            this.finish = this.index;
        }
        if (this.autocorr == null || this.autocorr.length < tapeParameters.getMaxSpace()) {
            this.autocorr = new int[tapeParameters.getMaxSpace()];
        }
        for (n = 0; n < this.autocorr.length; ++n) {
            int n2 = 0;
            for (int i = this.start; i < this.start + 5 * tapeParameters.getMaxSpace() && i + n < this.index; ++i) {
                n2 += this.lumped[i] * this.lumped[i + n];
            }
            this.autocorr[n] = n2;
        }
        for (n = 0; n < this.autocorr.length - 2; ++n) {
            int n3 = n;
            this.autocorr[n3] = this.autocorr[n3] + (2 * this.autocorr[n + 1] + this.autocorr[n + 2]);
        }
        for (n = tapeParameters.getGather(); n < this.autocorr.length - 2 && this.autocorr[n - 1] > this.autocorr[n]; ++n) {
        }
        while (n < this.autocorr.length - 2 && this.autocorr[n - 1] <= this.autocorr[n]) {
            ++n;
        }
        this.spacing = n;
        this.start = this.start + tapeParameters.getGather() - this.spacing / 2;
        if (this.start < 0) {
            this.start = 0;
        }
        this.finish = this.finish - tapeParameters.getGather() + this.spacing / 2;
        if (this.finish >= this.index) {
            this.finish = this.index - 1;
        }
    }

    private void evaluateTransitions(TapeParameters tapeParameters) {
        int n = this.start;
        while (n < this.finish) {
            int n2 = n;
            while (n < this.finish && this.lumped[n] == 0) {
                ++n;
            }
            while (n + 1 < this.finish && this.lumped[n] <= this.lumped[n + 1]) {
                ++n;
            }
            if (this.lumped[n] == 0) break;
            this.data[n] = this.datamark;
            while (n + 1 < this.finish && this.lumped[n] > 0 && this.lumped[n] >= this.lumped[n + 1]) {
                ++n;
            }
            if (n2 != n) continue;
            break;
        }
    }

    private void evaluateDoubles(TapeParameters tapeParameters) {
        int n = this.spacing;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = this.start;
        while (n7 < this.finish) {
            if ((this.data[n7] & this.datamark) != 0) {
                if (n2 != -1) {
                    SimpleSortedList simpleSortedList = new SimpleSortedList(5);
                    simpleSortedList.add(n3 - n2);
                    simpleSortedList.add(n4 - n3);
                    simpleSortedList.add(n5 - n4);
                    simpleSortedList.add(n6 - n5);
                    simpleSortedList.add(n7 - n6);
                    n = simpleSortedList.getKey(2);
                }
                int n8 = 2 * n + tapeParameters.getLowSpace() * n / 100;
                if (n3 > -1 && n6 - n3 < n8 && n5 - n4 < n4 - n3 && n5 - n4 < n6 - n5) {
                    this.data[n4] = 0;
                    this.data[n5] = 0;
                    n5 = (n4 + n5) / 2;
                    this.data[n5] = this.datamark;
                    ++this.fixups;
                    n4 = n3;
                    n3 = n2;
                    n2 = -1;
                    if (n3 >= this.start) continue;
                }
                n2 = n3;
                n3 = n4;
                n4 = n5;
                n5 = n6;
                n6 = n7;
            }
            ++n7;
        }
    }

    private boolean attemptSplit(int n, int n2, int n3) {
        int n4;
        int n5 = n2 + 1;
        for (n4 = n2 - 1; n4 > n && this.lumped[n4] > 0; --n4) {
        }
        if (n4 == n) {
            return false;
        }
        while (n5 < n3 && this.lumped[n5] > 0) {
            ++n5;
        }
        if (n5 == n3) {
            return false;
        }
        int n6 = -1;
        int n7 = -1;
        for (int i = n4 + 1; i < n5; ++i) {
            if (this.transitions[i] == 0) continue;
            if (n6 == -1) {
                n6 = i;
                continue;
            }
            n7 = i;
        }
        if (n7 == -1) {
            return false;
        }
        this.data[n2] = 0;
        this.data[n6] = this.datamark;
        this.data[n7] = this.datamark;
        ++this.fixups;
        return true;
    }

    private void evaluateSplits(TapeParameters tapeParameters) {
        int n = this.spacing + tapeParameters.getHighSpace() * this.spacing / 100;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = this.start; i < this.finish; ++i) {
            if ((this.data[i] & this.datamark) == 0) continue;
            if (n2 != -1) {
                boolean bl;
                boolean bl2 = n4 - n2 > n;
                boolean bl3 = bl = i - n3 > n;
                if (bl2 && bl) {
                    bl2 = n4 - n2 > i - n3;
                    boolean bl4 = bl = i - n3 > n4 - n2;
                }
                if (bl2 && this.attemptSplit(n2, n3, n4)) {
                    n3 = -1;
                }
                if (bl && this.attemptSplit(n3, n4, i)) {
                    n3 = -1;
                    n4 = -1;
                }
            }
            n2 = n3;
            n3 = n4;
            n4 = i;
        }
    }

    private void evaluateGaps(TapeParameters tapeParameters) {
        int n;
        int n2 = tapeParameters.getHighSpace() * this.spacing / 100;
        for (n = this.start; (this.data[n] & this.datamark) == 0 && n < this.finish; ++n) {
        }
        for (int i = n + 1; i < this.finish; ++i) {
            if ((this.data[i] & this.datamark) != 0) {
                n = i;
                continue;
            }
            if (i - n <= n2) continue;
            this.data[n += this.spacing] = this.datamark;
            if (this.lumped[n] <= 0) continue;
            ++this.fixups;
        }
    }

    private void evaluateStatus(TapeParameters tapeParameters) {
        int n;
        for (n = 0; n < this.index; ++n) {
            this.status[n] = 0;
        }
        int n2 = 0;
        int n3 = this.lumped[this.start];
        int n4 = this.start;
        for (n = this.start; n < this.finish; ++n) {
            if (this.lumped[n] <= n3) {
                n3 = this.lumped[n];
                n4 = n;
            }
            if ((this.data[n] & this.datamark) == 0) continue;
            this.status[n] = n2 + 1;
            if (n + 1 < this.index) {
                this.status[n + 1] = n2 + 1;
            }
            if (n - 1 >= n4) {
                this.status[n - 1] = n2 + 1;
            }
            int n5 = 1;
            while (n + n5 < this.index && this.lumped[n + n5] > 0) {
                this.status[n + n5] = n2 + 1;
                ++n5;
            }
            n5 = 1;
            while (n - n5 >= n4 && this.lumped[n - n5] > 0) {
                this.status[n - n5] = n2 + 1;
                ++n5;
            }
            n2 = 2 - n2;
            n3 = this.lumped[n + 1];
            n4 = n + 1;
        }
        for (n = 0; n < this.index; ++n) {
            if (this.status[n] != 0 || this.lumped[n] == 0) continue;
            while (this.status[n] == 0 && this.lumped[n] != 0) {
                this.status[n] = 6;
                ++n;
            }
            ++this.errors;
        }
    }

    public void evaluateLRC(boolean bl, boolean bl2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        this.hasLRC = false;
        for (n = 0; n < this.index; ++n) {
            if ((this.data[n] & this.datamark) == 0) continue;
            ++n2;
            if (n3 == -1) {
                n3 = n;
            }
            n5 = n4;
            n4 = n;
        }
        if (n4 != -1 && this.data[n4] == this.datamark) {
            this.data[n4] = 0;
            --n2;
            --this.dataCount;
            n4 = n5;
        }
        if (n2 > 2) {
            int n7;
            int n8;
            if (bl) {
                n = 0;
                if (n2 > 4) {
                    n8 = 0;
                    for (n7 = n4 - 1; n8 < 2 && n7 > 0; --n7) {
                        if ((this.data[n7] & this.datamark) == 0) continue;
                        ++n8;
                        if (this.data[n7] != this.datamark) continue;
                        ++n;
                    }
                }
                if (n == 2) {
                    --n2;
                    n6 = n4;
                    this.hasLRC = true;
                    while (this.status[n4 - 1] == this.status[n4]) {
                        --n4;
                    }
                    n8 = 4;
                    while (n8 > 0) {
                        if ((this.data[n4] & this.datamark) != 0) {
                            if (this.data[n4] != this.datamark) break;
                            this.data[n4] = 0;
                            --n2;
                            --this.dataCount;
                            --n8;
                        }
                        --n4;
                    }
                } else {
                    n6 = this.index - 1;
                }
            } else {
                n = 0;
                if (n2 > 4) {
                    n8 = 0;
                    for (n7 = n3 + 1; n8 < 2 && n7 < this.index; ++n7) {
                        if ((this.data[n7] & this.datamark) == 0) continue;
                        ++n8;
                        if (this.data[n7] != this.datamark) continue;
                        ++n;
                    }
                }
                if (n == 2) {
                    --n2;
                    n6 = n3;
                    this.hasLRC = true;
                    while (this.status[n3 + 1] == this.status[n3]) {
                        ++n3;
                    }
                    n8 = 4;
                    while (n8 > 0) {
                        if ((this.data[n3] & this.datamark) != 0) {
                            if (this.data[n3] != this.datamark) break;
                            this.data[n3] = 0;
                            --this.dataCount;
                            --n2;
                            --n8;
                        }
                        ++n3;
                    }
                } else {
                    n6 = 0;
                }
            }
        } else if (n2 == 2) {
            this.hasLRC = true;
            this.spacing /= 4;
            n6 = bl ? n4 : n3;
        } else {
            if (n3 >= 0) {
                this.errors = 1;
                for (n = n3; n < this.status.length && this.status[n] != 0; ++n) {
                    this.status[n] = 6;
                }
                this.data[n3] = 0;
            }
            this.dataCount = 0;
            return;
        }
        if (this.hasLRC) {
            n = this.status[n6];
            while (n6 > 0 && this.status[n6] == n) {
                --n6;
            }
            ++n6;
            while (n6 < this.status.length && this.status[n6] == n) {
                this.status[n6] = bl2 ? 5 : 6;
                ++n6;
            }
        } else if (!bl2) {
            ++this.errors;
        }
    }

    public void evaluateMissing() {
        for (int i = 0; i < this.index; ++i) {
            int n;
            if (!this.transitionError[i] || this.status[i] != 1 && this.status[i] != 3) continue;
            int n2 = this.status[i];
            for (n = i; n > 0 && this.status[n - 1] == n2; --n) {
            }
            while (n < this.status.length && this.status[n] == n2) {
                int n3 = n++;
                this.status[n3] = this.status[n3] + 1;
            }
            ++this.errors;
        }
    }

    public void setupParity() {
        int n = 1 << this.nchannel;
        if (this.parity == null || this.parity.length < n) {
            this.parity = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                for (int j = 1; j < n; j <<= 1) {
                    if ((i & j) == 0) continue;
                    ++n2;
                }
                this.parity[i] = n2 & 1;
            }
        }
    }

    public void evaluateParity() {
        int n;
        this.setupParity();
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < this.index - 1; ++n) {
            if ((this.data[n] & this.datamark) == 0) continue;
            if (this.parity[this.data[n] & this.datamask] > 0) {
                ++n2;
                continue;
            }
            ++n3;
        }
        this.goodParity = n3 > n2 ? 0 : 1;
        for (n = 1; n < this.index - 1; ++n) {
            int n4;
            int n5;
            if ((this.data[n] & this.datamark) == 0 || this.status[n] != 1 && this.status[n] != 3 || (n5 = this.data[n] & this.datamask) != 0 && this.parity[n5] == this.goodParity) continue;
            int n6 = this.status[n];
            for (n4 = n; n4 > 0 && this.status[n4 - 1] == n6; --n4) {
            }
            while (n4 < this.status.length && this.status[n4] == n6) {
                int n7 = n4++;
                this.status[n7] = this.status[n7] + 1;
            }
            ++this.errors;
        }
    }

    public void evaluateData() {
        int n = -1;
        int n2 = 0;
        for (int i = 1; i < this.index; ++i) {
            if (this.status[i - 1] != this.status[i] || i == this.index - 1) {
                if (n != -1) {
                    this.data[n] = n2 | this.datamark;
                    ++this.dataCount;
                }
                n = -1;
                n2 = this.transitions[i];
            } else {
                if ((n2 & this.transitions[i]) != 0 && !this.transitionError[i]) {
                    this.transitionError[i] = true;
                    ++this.transitionErrorCount;
                }
                n2 |= this.transitions[i];
            }
            if ((this.data[i] & this.datamark) == 0) continue;
            n = i;
        }
    }

    private boolean adjustBoundaries() {
        int n;
        boolean bl = false;
        int n2 = -1;
        for (n = 0; n < this.index; ++n) {
            int n3;
            if ((this.data[n] & this.datamark) == 0) continue;
            if (n2 >= 0 && this.parity[this.data[n2] & 0x7F] != this.goodParity && this.parity[this.data[n] & 0x7F] != this.goodParity && this.status[n3 = (n2 + n) / 2] != 0) {
                int n4 = 1;
                int n5 = n;
                if (this.status[n3] == this.status[n]) {
                    n4 = -1;
                    n5 = n2;
                    n3 = (n2 + n + 1) / 2;
                }
                int n6 = n3;
                n6 += n4;
                while (this.status[n6] == this.status[n3]) {
                    n6 += n4;
                }
                n6 -= n4;
                while (n6 != n3 - n4 && this.transitions[n6] == 0) {
                    n6 -= n4;
                }
                if (this.transitions[n6] != 0 && (this.data[n2] & this.data[n] & this.transitions[n6]) == 0 && this.parity[this.transitions[n6]] == 1) {
                    int n7 = n2;
                    this.data[n7] = this.data[n7] ^ this.transitions[n6];
                    int n8 = n;
                    this.data[n8] = this.data[n8] ^ this.transitions[n6];
                    while (n6 != n5) {
                        this.status[n6] = this.status[n5];
                        n6 += n4;
                    }
                    ++this.fixups;
                    bl = true;
                }
            }
            n2 = n;
        }
        if (bl) {
            for (n = 0; n < this.index; ++n) {
                if (this.status[n] == 2) {
                    this.status[n] = 1;
                }
                if (this.status[n] != 4) continue;
                this.status[n] = 3;
            }
        }
        return bl;
    }

    public int[] skewOffset() {
        int n;
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[this.nchannel];
        int[] nArray2 = new int[this.nchannel];
        int[] nArray3 = new int[this.nchannel];
        for (n = 0; n < this.nchannel; ++n) {
            nArray2[n] = 0;
            nArray3[n] = 0;
        }
        for (n = 0; n < this.index; ++n) {
            int n4;
            if (this.status[n] != 0 && this.status[n] != n2) {
                n2 = this.status[n];
                for (n4 = 0; n4 < this.nchannel; ++n4) {
                    nArray[n4] = 0;
                }
                n3 = 0;
            }
            if ((this.data[n] & this.datamark) != 0) {
                n3 = n;
            }
            if (this.transitions[n] != 0) {
                for (n4 = 0; n4 < this.nchannel; ++n4) {
                    if ((this.transitions[n] & 1 << n4) == 0) continue;
                    nArray[n4] = n;
                }
            }
            if (n2 == 0 || n + 1 != this.index && this.status[n + 1] == n2) continue;
            if (n3 != 0 && (n2 & 1) != 0) {
                for (n4 = 0; n4 < this.nchannel; ++n4) {
                    if (nArray[n4] == 0) continue;
                    int n5 = n4;
                    nArray2[n5] = nArray2[n5] + (nArray[n4] - n3);
                    int n6 = n4;
                    nArray3[n6] = nArray3[n6] + 1;
                }
            }
            n2 = 0;
        }
        for (n = 0; n < this.nchannel; ++n) {
            if (nArray3[n] > 0) {
                if (nArray2[n] >= 0) {
                    nArray[n] = -(nArray2[n] + nArray3[n] / 2) / nArray3[n];
                    continue;
                }
                nArray[n] = -(nArray2[n] - nArray3[n] / 2) / nArray3[n];
                continue;
            }
            nArray[n] = 0;
        }
        return nArray;
    }

    private void logResults() throws IOException {
        ++this.logsn;
        int n = -1;
        int n2 = 0;
        int[] nArray = new int[this.nchannel];
        for (int i = 0; i < this.index; ++i) {
            int n3;
            if (this.status[i] != 0 && this.status[i] != n) {
                n = this.status[i];
                for (n3 = 0; n3 < this.nchannel; ++n3) {
                    nArray[n3] = 0;
                }
                n2 = 0;
            }
            if ((this.data[i] & this.datamark) != 0) {
                n2 = i;
            }
            if (this.transitions[i] != 0) {
                for (n3 = 0; n3 < this.nchannel; ++n3) {
                    if ((this.transitions[i] & 1 << n3) == 0) continue;
                    nArray[n3] = i;
                }
            }
            if (n == 0 || i + 1 != this.index && this.status[i + 1] == n) continue;
            if (n2 == 0) {
                this.log.write(i + "." + this.logsn + ": No data");
                this.log.newLine();
            } else {
                String string = n2 + "." + this.logsn;
                string = (n & 1) != 0 ? string + ": " : string + "* ";
                for (int j = 0; j < this.nchannel; ++j) {
                    if (nArray[j] != 0) {
                        int n4 = nArray[j] - n2;
                        if (n4 > 0) {
                            string = string + " +" + n4;
                            continue;
                        }
                        if (n4 == 0) {
                            string = string + "  0";
                            continue;
                        }
                        string = string + " " + n4;
                        continue;
                    }
                    string = string + "  =";
                }
                this.log.write(string);
                this.log.newLine();
            }
            n = 0;
        }
        this.log.flush();
        int[] nArray2 = this.skewOffset();
        this.log.write("skew offset " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2] + " " + nArray2[3] + " " + nArray2[4] + " " + nArray2[5] + " " + nArray2[6]);
        this.log.newLine();
        this.log.flush();
    }

    public void evaluate(TapeParameters tapeParameters, boolean bl, boolean bl2) {
        if (this.index > this.transitions.length) {
            this.index = this.transitions.length;
        }
        this.errors = 0;
        this.fixups = 0;
        this.dataCount = 0;
        this.lumpTransitions(tapeParameters);
        this.evaluateSpacing(tapeParameters);
        if (this.spacing > tapeParameters.getGather()) {
            this.evaluateTransitions(tapeParameters);
            this.evaluateDoubles(tapeParameters);
            this.evaluateGaps(tapeParameters);
            this.evaluateStatus(tapeParameters);
            this.evaluateData();
            this.evaluateMissing();
            int n = this.errors;
            this.evaluateLRC(bl, bl2);
            n = this.errors - n;
            this.evaluateParity();
            if (this.errors > 1 && this.dataCount > 2 && this.adjustBoundaries()) {
                this.errors = n;
                this.evaluateMissing();
                this.evaluateParity();
            }
        }
        if (this.log != null) {
            try {
                this.logResults();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    private class SimpleSortedList {
        int[] list;
        int count;

        public SimpleSortedList(int n) {
            this.list = new int[n];
            this.count = 0;
        }

        public void add(int n) {
            this.list[this.count] = n;
            for (int i = this.count - 1; i >= 0; --i) {
                if (n >= this.list[i]) continue;
                this.list[i + 1] = this.list[i];
                this.list[i] = n;
            }
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public int getKey(int n) {
            return this.list[n];
        }
    }
}

