/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.Plottable;
import com.piercefuller.a7trk.decode.ProgressWatcher;
import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.StopException;
import com.piercefuller.a7trk.decode.TapeParameters;

public class SkewEval
implements Plottable {
    private final int MinCount = 10000;
    Source source;
    TapeParameters tp;
    ProgressWatcher progressWatcher;
    int progressClump;
    int nchannel;
    int hwidth;
    Hist hist;

    public SkewEval(Source source, ProgressWatcher progressWatcher, int n, int n2) {
        this.source = source;
        this.tp = this.source.getTapeParameters();
        this.progressWatcher = progressWatcher;
        this.progressClump = n;
        this.hwidth = n2;
        this.nchannel = this.source.getNumChannels();
        this.hist = new Hist(this.nchannel, n2);
        for (int i = 0; i < this.nchannel; ++i) {
            this.tp.getSkew()[i] = 0;
        }
        this.process();
        this.evaluate();
    }

    public void process() {
        int n;
        int[] nArray = new int[this.nchannel];
        int[] nArray2 = new int[this.nchannel];
        int n2 = 0;
        for (n = 0; n < this.nchannel; ++n) {
            nArray[n] = 0;
            nArray2[n] = 0;
        }
        try {
            n = 0;
            while (!this.source.atLimit()) {
                int n3;
                int[] nArray3 = this.source.getSamples();
                for (n3 = 0; n3 < this.nchannel; ++n3) {
                    if (nArray3[n3] == 0 || nArray3[n3] == nArray[n3]) continue;
                    nArray2[n3] = n;
                }
                for (n3 = 0; n3 < this.nchannel; ++n3) {
                    if (nArray3[n3] == 0 || nArray3[n3] == nArray[n3]) continue;
                    for (int i = 0; i < this.nchannel; ++i) {
                        int n4 = n - nArray2[i];
                        if (n4 >= this.hwidth) continue;
                        if (i < n3) {
                            this.hist.hit(i, n3, n4);
                        }
                        if (i <= n3) continue;
                        this.hist.hit(n3, i, -n4);
                    }
                    nArray[n3] = nArray3[n3];
                }
                this.source.advance();
                if (++n2 == this.progressClump) {
                    n3 = this.doneYet();
                    if (this.progressWatcher != null) {
                        this.progressWatcher.reportProgress("skew...", n3, 10000);
                    }
                    n2 = 0;
                    if (n3 >= 10000) break;
                }
                ++n;
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
        if (this.progressWatcher != null) {
            this.progressWatcher.finished();
            n2 = 0;
        }
    }

    private int doneYet() {
        int n = 10000;
        for (int i = 0; i < this.nchannel; ++i) {
            for (int j = i + 1; j < this.nchannel; ++j) {
                int n2 = 0;
                for (int k = -this.hwidth; k <= this.hwidth && (n2 += this.hist.getBin(i, j, k)) <= 10000; ++k) {
                }
                if (n2 >= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public void evaluate() {
        int n;
        double d;
        int n2;
        int n3;
        int n4;
        double[][] dArrayArray = new double[this.nchannel][];
        for (n4 = 0; n4 < this.nchannel; ++n4) {
            dArrayArray[n4] = new double[this.nchannel];
            for (n3 = 0; n3 < this.nchannel; ++n3) {
                dArrayArray[n4][n3] = 0.0;
            }
        }
        for (n4 = 0; n4 < this.nchannel - 1; ++n4) {
            for (n3 = n4 + 1; n3 < this.nchannel; ++n3) {
                n2 = 0;
                d = 0.0;
                for (n = -this.hwidth; n <= this.hwidth; ++n) {
                    int n5 = this.hist.getBin(n4, n3, n);
                    n2 += n5;
                    d += (double)(n * n5);
                }
                dArrayArray[n4][n3] = d / (double)n2;
                dArrayArray[n3][n4] = -dArrayArray[n4][n3];
            }
        }
        double d2 = 0.0;
        for (n2 = 0; n2 < this.nchannel; ++n2) {
            d = 0.0;
            for (n = 0; n < this.nchannel; ++n) {
                d += dArrayArray[n2][n];
            }
            if (!(d < d2)) continue;
            d2 = d;
        }
        for (n2 = 0; n2 < this.nchannel; ++n2) {
            d = 0.0;
            for (n = 0; n < this.nchannel; ++n) {
                d += dArrayArray[n2][n];
            }
            this.tp.getSkew()[n2] = (int)((d - d2 + (double)this.nchannel / 2.0) / (double)this.nchannel);
        }
    }

    private int[] getTotals() {
        int[] nArray = new int[this.hwidth + 1];
        for (int i = 0; i <= this.hwidth; ++i) {
            int n = 0;
            for (int j = 0; j < this.nchannel; ++j) {
                for (int k = j + 1; k < this.nchannel; ++k) {
                    if (i == 0) {
                        n += this.hist.getBin(j, k, this.tp.getSkew()[j] - this.tp.getSkew()[k]);
                        continue;
                    }
                    n += this.hist.getBin(j, k, i + this.tp.getSkew()[j] - this.tp.getSkew()[k]);
                    n += this.hist.getBin(j, k, -i + this.tp.getSkew()[j] - this.tp.getSkew()[k]);
                }
            }
            nArray[i] = n;
        }
        return nArray;
    }

    @Override
    public int getNumDatasets() {
        return 1;
    }

    @Override
    public String getDatasetName(int n) {
        return "Bin";
    }

    @Override
    public int[] getDataset(int n) {
        if (n == 0) {
            int[] nArray = new int[this.hwidth + 1];
            for (int i = 0; i <= this.hwidth; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        return this.getTotals();
    }

    @Override
    public String getName() {
        return "Skew";
    }

    @Override
    public String getXLabel() {
        return "Count";
    }

    @Override
    public String getYLabel() {
        return "Deviation from Calculated";
    }

    @Override
    public boolean isXLog() {
        return false;
    }

    @Override
    public boolean isYLog() {
        return false;
    }

    private class Hist {
        private int hwidth;
        private int[] bin;

        public Hist(int n, int n2) {
            this.hwidth = n2;
            this.bin = new int[(2 * n2 + 1) * (n * (n - 1) / 2)];
            for (int i = 0; i < this.bin.length; ++i) {
                this.bin[i] = 0;
            }
        }

        public int getBin(int n, int n2, int n3) {
            if (n3 >= -this.hwidth && n3 <= this.hwidth) {
                return this.bin[(2 * this.hwidth + 1) * (n + n2 * (n2 - 1) / 2) + n3 + this.hwidth];
            }
            return 0;
        }

        public void hit(int n, int n2, int n3) {
            int n4 = (2 * this.hwidth + 1) * (n + n2 * (n2 - 1) / 2) + n3 + this.hwidth;
            this.bin[n4] = this.bin[n4] + 1;
        }
    }
}

