/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.BaselineSource;
import com.piercefuller.a7trk.decode.CrowdSource;
import com.piercefuller.a7trk.decode.DataCollection;
import com.piercefuller.a7trk.decode.DataFile;
import com.piercefuller.a7trk.decode.DirSource;
import com.piercefuller.a7trk.decode.LumpSource;
import com.piercefuller.a7trk.decode.MultiSource;
import com.piercefuller.a7trk.decode.ProgressWatcher;
import com.piercefuller.a7trk.decode.RawSource;
import com.piercefuller.a7trk.decode.Record;
import com.piercefuller.a7trk.decode.RecordInfo;
import com.piercefuller.a7trk.decode.SkewEval;
import com.piercefuller.a7trk.decode.Source;
import com.piercefuller.a7trk.decode.StopException;
import com.piercefuller.a7trk.decode.TapeParameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TapeDecoder
implements MultiSource {
    private final int ClumpSize = 10000;
    private final int MaxRecord = 19660800;
    private final int NominalRecord = 1000000;
    private final int Pad = 50;
    private DataCollection datacollection;
    private DataFile datafile;
    private Source source;
    private int nchannel;
    private int evalErrors;
    private int evalFixups;
    private int gapJunk;
    private int[] spacingHist;
    private ProgressWatcher progressWatcher;
    private RecordInfo ri;
    private Record currentRecord;
    private RecordInfo currentRecordInfo;

    public TapeDecoder(String string) throws Exception {
        int n = string.lastIndexOf(46);
        if (n >= 0 && string.indexOf(File.pathSeparator, n) > n) {
            n = -1;
        }
        if (n < 0) {
            try {
                this.openXml(string + ".xml");
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                try {
                    this.openData(string + ".dat");
                }
                catch (IOException iOException2) {
                    System.err.println(iOException2);
                    this.openData(string);
                }
            }
        } else if (string.toLowerCase().endsWith(".xml")) {
            this.openXml(string);
        } else {
            this.openData(string);
        }
    }

    private void openXml(String string) throws Exception {
        this.datacollection = new DataCollection(string);
        this.datafile = this.datacollection.getDataFile();
        this.initialize(RawSource.getInstance(this.datafile));
        for (int i = 0; i < this.datafile.getRecords().getCount(); ++i) {
            this.evalErrors += this.datafile.getRecords().get(i).getErrors();
            this.evalFixups += this.datafile.getRecords().get(i).getFixups();
        }
    }

    private void openData(String string) throws Exception {
        this.datafile = new DataFile(string, 7, -1, -1);
        this.initialize(RawSource.getInstance(this.datafile));
        this.datacollection = new DataCollection(this.datafile);
    }

    private TapeDecoder(Source source, DataCollection dataCollection, DataFile dataFile) {
        this.datafile = dataFile;
        this.datacollection = dataCollection;
        while (!(source instanceof RawSource)) {
            if ((source = source.getSource()) != null) continue;
            throw new Error("TapeDecoder must be based on RawSource");
        }
        this.initialize((RawSource)((RawSource)source).clone());
    }

    private void clearStats(boolean bl) {
        this.evalErrors = 0;
        this.evalFixups = 0;
        if (bl) {
            this.gapJunk = 0;
        }
        if (this.spacingHist != null) {
            for (int i = 0; i < this.spacingHist.length; ++i) {
                this.spacingHist[i] = 0;
            }
        }
    }

    private void initialize(RawSource rawSource) {
        this.nchannel = rawSource.getNumChannels();
        this.ri = new RecordInfo(0L, 1000000, this.nchannel);
        this.clearStats(true);
        this.progressWatcher = null;
        this.currentRecord = null;
        this.currentRecordInfo = null;
        LumpSource lumpSource = new LumpSource(rawSource);
        BaselineSource baselineSource = new BaselineSource(lumpSource);
        DirSource dirSource = new DirSource(baselineSource);
        this.source = new CrowdSource(dirSource);
    }

    private void copyStats(TapeDecoder tapeDecoder) {
        tapeDecoder.evalErrors = this.evalErrors;
        tapeDecoder.evalFixups = this.evalFixups;
        tapeDecoder.gapJunk = this.gapJunk;
        if (this.spacingHist != null) {
            int n;
            if (tapeDecoder.spacingHist == null || tapeDecoder.spacingHist.length < this.spacingHist.length) {
                tapeDecoder.spacingHist = new int[this.spacingHist.length];
            }
            for (n = 0; n < this.spacingHist.length; ++n) {
                tapeDecoder.spacingHist[n] = this.spacingHist[n];
            }
            while (n < tapeDecoder.spacingHist.length) {
                tapeDecoder.spacingHist[n] = 0;
                ++n;
            }
        }
    }

    @Override
    public MultiSource clone() {
        TapeDecoder tapeDecoder = new TapeDecoder(this.source, this.datacollection, this.datafile);
        return tapeDecoder;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public DataFile getDataFile() {
        return this.datafile;
    }

    @Override
    public long getStart() {
        return this.source.getStart();
    }

    @Override
    public long getEnd() {
        return this.source.getEnd();
    }

    @Override
    public void setStart(long l) {
        this.source.setStart(l);
    }

    @Override
    public void setEnd(long l) {
        this.source.setEnd(l);
    }

    @Override
    public long getLength() {
        return this.source.getLength();
    }

    public TapeParameters getTapeParameters() {
        return this.datafile.getTapeParameters().getTapeParameters(this.getPosition());
    }

    @Override
    public void calibrate(ProgressWatcher progressWatcher) throws Exception {
        this.calibrate(progressWatcher, null);
    }

    @Override
    public void calibrate(ProgressWatcher progressWatcher, MultiSource multiSource) throws Exception {
        if (this.source == null) {
            throw new Exception("Source instanceof closed");
        }
        if (this.progressWatcher != null) {
            throw new Exception("Operation already in progress");
        }
        this.progressWatcher = progressWatcher;
        int n = (int)this.source.getEnd();
        try {
            if (this.progressWatcher != null) {
                this.progressWatcher.reportProgress("skew", 0, n);
            }
            this.source.setPosition(this.source.getStart());
            this.source.resetLimit();
            SkewEval skewEval = new SkewEval(this.source, this.progressWatcher, 10000, this.source.getTapeParameters().getWidth());
            if (this.progressWatcher != null) {
                this.progressWatcher.setPlot(skewEval);
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
        if (this.progressWatcher != null) {
            this.progressWatcher.finished();
            this.progressWatcher = null;
        }
    }

    @Override
    public void mark(ProgressWatcher progressWatcher) throws Exception {
        this.xmark(progressWatcher, null);
    }

    @Override
    public void mark(ProgressWatcher progressWatcher, MultiSource multiSource) throws Exception {
        this.xmark(progressWatcher, multiSource);
        if (progressWatcher != null) {
            progressWatcher.finished();
        }
    }

    private void xmark(ProgressWatcher progressWatcher, MultiSource multiSource) throws Exception {
        if (this.source == null) {
            throw new Error("Source instanceof closed");
        }
        if (this.progressWatcher != null) {
            throw new Exception("Operation already in progress");
        }
        this.progressWatcher = progressWatcher;
        this.clearStats(true);
        this.datafile.getRecords().clear();
        for (Source source = this.source; source != null; source = source.getSource()) {
            if (!(source instanceof BaselineSource)) continue;
            ((BaselineSource)source).setDataPoints(null, 0L);
            break;
        }
        int n = (int)this.source.getEnd();
        try {
            if (this.progressWatcher != null) {
                this.progressWatcher.reportProgress("mark", 0, n);
            }
            this.source.setPosition(this.source.getStart());
            long l = 0L;
            long l2 = -1L;
            long l3 = -1L;
            long l4 = 0L;
            int n2 = 0;
            int[] nArray = new int[this.nchannel];
            int n3 = 0;
            int n4 = 0;
            while (!this.source.atLimit()) {
                Object object;
                int n5;
                int[] nArray2 = this.source.getSamples();
                for (n5 = 0; n5 < this.nchannel; ++n5) {
                    nArray[n5] = nArray2[n5];
                }
                this.source.advance();
                if (n3 > 0) {
                    --n3;
                    n5 = this.nchannel;
                } else {
                    nArray2 = this.source.getSamples();
                    for (n5 = 0; n5 < this.nchannel && (nArray2[n5] == 0 || nArray2[n5] == nArray[n5]); ++n5) {
                    }
                }
                if (n5 < this.nchannel) {
                    l3 = this.source.getPosition();
                    if (l2 == -1L) {
                        l2 = l3;
                        l2 = l2 > 50L ? (l2 -= 50L) : 0L;
                        n4 = 0;
                    }
                    ++n4;
                    n3 = this.source.getTapeParameters().getWidth();
                    l = 0L;
                } else if (l2 != -1L && ++l == (long)((TapeParameters)(object = this.source.getTapeParameters())).getMaxSpace()) {
                    if (l2 - l4 > (long)((TapeParameters)object).getMinGap() || n4 > ((TapeParameters)object).getMaxJunk()) {
                        if ((l3 += 50L) >= this.source.getEnd()) {
                            l3 = this.source.getEnd() - 1L;
                        }
                        this.createRecord(this.source, l2, l3, n4);
                        l4 = l3;
                        l2 = -1L;
                        l = 0L;
                    } else {
                        ++this.gapJunk;
                    }
                    l2 = -1L;
                }
                if (this.progressWatcher == null || ++n2 != 10000) continue;
                object = this.datafile.getRecords().getCount() + " records marked";
                this.progressWatcher.reportProgress((String)object, (int)this.getPosition(), n);
                n2 = 0;
            }
            if (l2 != -1L) {
                if ((l3 += 50L) >= this.source.getEnd()) {
                    l3 = this.source.getEnd() - 1L;
                }
                this.createRecord(this.source, l2, l3, n4);
            }
            if (this.progressWatcher != null && n2 > 0) {
                String string = this.datafile.getRecords().getCount() + " records marked";
                this.progressWatcher.reportProgress(string, (int)this.getPosition(), n);
                n2 = 0;
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
        if (multiSource instanceof TapeDecoder) {
            TapeDecoder tapeDecoder = (TapeDecoder)multiSource;
            this.copyStats(tapeDecoder);
        }
        this.progressWatcher = null;
    }

    @Override
    public void evaluate(ProgressWatcher progressWatcher) throws Exception {
        this.evaluate(progressWatcher, null);
    }

    @Override
    public void evaluate(ProgressWatcher progressWatcher, MultiSource multiSource) throws Exception {
        if (this.source == null) {
            throw new Error("Source instanceof closed");
        }
        if (this.progressWatcher != null) {
            throw new Exception("Operation already in progress");
        }
        if (this.datafile.getRecords().getCount() == 0) {
            this.xmark(progressWatcher, multiSource);
        }
        this.write(progressWatcher, null, false);
        if (multiSource instanceof TapeDecoder) {
            TapeDecoder tapeDecoder = (TapeDecoder)multiSource;
            this.copyStats(tapeDecoder);
        }
    }

    private void createRecord(Source source, long l, long l2, int n) {
        Source source2 = source.getSource();
        while (!(source2 instanceof RawSource)) {
            source2 = source2.getSource();
        }
        if (n > 1 && n < 19660800) {
            Record record = new Record(this.datafile.getRecords().getCount() + 1, l, l2, (((RawSource)source2).getFlags() & 2) == 0);
            record.setCount(n);
            this.datafile.getRecords().add(record);
        }
    }

    public RecordInfo evaluateRecord(Record record) throws Exception {
        return this.evaluateRecord(record, false);
    }

    public RecordInfo evaluateRecord(Record record, boolean bl) throws Exception {
        Object object;
        boolean bl2 = true;
        boolean bl3 = false;
        TapeParameters tapeParameters = this.datafile.getTapeParameters().getTapeParameters(record.getStart());
        for (object = this.source; object != null; object = object.getSource()) {
            if (!(object instanceof BaselineSource)) continue;
            ((BaselineSource)object).setDataPoints(null, 0L);
            break;
        }
        object = this.evaluateRecord(record, this.source);
        if (bl && (((RecordInfo)object).getErrors() > 0 || ((RecordInfo)object).getMissing() > 0)) {
            bl2 = tapeParameters.getLowClip();
            bl3 = true;
        }
        if (tapeParameters.getLowClip() || bl3) {
            int[] nArray;
            int n;
            if (!bl2) {
                int n2;
                if (tapeParameters.getStart() != record.getStart() || tapeParameters.getEnd() != record.getEnd()) {
                    tapeParameters = this.datafile.getTapeParameters().add(record.getStart(), record.getEnd());
                }
                for (int i = 0; i < this.nchannel; ++i) {
                    n = tapeParameters.getClip(false, i);
                    tapeParameters.setClip(3 * n / 8, true, i);
                    tapeParameters.getBaseLimit()[i] = n / 2;
                }
                nArray = ((RecordInfo)object).skewOffset();
                n = 100;
                for (n2 = 0; n2 < this.nchannel; ++n2) {
                    int n3 = tapeParameters.getSkew()[n2] + nArray[n2];
                    if (n3 >= n) continue;
                    n = n3;
                }
                for (n2 = 0; n2 < this.nchannel; ++n2) {
                    int[] nArray2 = tapeParameters.getSkew();
                    int n4 = n2;
                    nArray2[n4] = nArray2[n4] + (nArray[n2] - n);
                }
                object = this.evaluateRecord(record, this.source);
            }
            nArray = new int[((RecordInfo)object).getLength()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = ((RecordInfo)object).getDataPoint(n);
            }
            for (Source source = this.source; source != null; source = source.getSource()) {
                if (!(source instanceof BaselineSource)) continue;
                ((BaselineSource)source).setDataPoints(nArray, record.getStart());
                break;
            }
            object = this.evaluateRecord(record, this.source);
        }
        record.setCount(((RecordInfo)object).getDataCount());
        record.setErrors(((RecordInfo)object).getErrors());
        record.setFixups(((RecordInfo)object).getFixups());
        if (((RecordInfo)object).getErrors() > this.evalErrors) {
            this.evalErrors = ((RecordInfo)object).getErrors();
        }
        return object;
    }

    private RecordInfo evaluateRecord(Record record, Source source) {
        int n;
        source.setPosition(record.getStart());
        source.setLimit(record.getEnd());
        this.ri.reset(record.getStart(), (int)(record.getEnd() - record.getStart()));
        int[] nArray = new int[this.nchannel];
        int[] nArray2 = source.getSamples();
        for (n = 0; n < this.nchannel; ++n) {
            nArray[n] = 0;
        }
        while (!source.atLimit()) {
            for (n = 0; n < this.nchannel; ++n) {
                if (nArray2[n] == 0) continue;
                nArray[n] = nArray2[n];
            }
            source.advance();
            this.ri.increment();
            nArray2 = source.getSamples();
            for (n = 0; n < this.nchannel; ++n) {
                if (nArray2[n] == 0 || nArray2[n] == nArray[n]) continue;
                this.ri.setTransition(n);
                if ((nArray2[n] <= 0 || nArray[n] <= 0) && (nArray2[n] >= 0 || nArray[n] >= 0)) continue;
                this.ri.missing();
            }
        }
        n = 1;
        for (int i = 0; i < this.nchannel; ++i) {
            if (nArray2[i] <= 0) continue;
            n = 0;
            break;
        }
        this.ri.evaluate(this.datafile.getTapeParameters().getTapeParameters(record.getStart()), record.getMotionForward(), n != 0);
        return this.ri;
    }

    @Override
    public void write(ProgressWatcher progressWatcher) throws Exception {
        this.write(progressWatcher, null, true);
    }

    @Override
    public void write(ProgressWatcher progressWatcher, MultiSource multiSource) throws Exception {
        this.write(progressWatcher, null, true);
        if (multiSource instanceof TapeDecoder) {
            this.copyStats((TapeDecoder)multiSource);
        }
    }

    public void write(ProgressWatcher progressWatcher, PrintStream printStream) throws Exception {
        this.write(progressWatcher, printStream, true);
    }

    private void write(ProgressWatcher progressWatcher, PrintStream printStream, boolean bl) throws Exception {
        boolean bl2;
        if (this.source == null) {
            throw new Exception("Source instanceof closed");
        }
        if (this.progressWatcher != null) {
            throw new Exception("Operation already in progress");
        }
        boolean bl3 = bl2 = !bl;
        if (this.datafile.getRecords().getCount() == 0) {
            this.xmark(progressWatcher, null);
            bl2 = true;
        }
        this.progressWatcher = progressWatcher;
        OutputStream outputStream = null;
        if (this.spacingHist == null) {
            this.spacingHist = new int[this.datafile.getTapeParameters().get(0).getMaxSpace()];
        }
        this.clearStats(false);
        String string = "";
        try {
            Record record;
            int n;
            int n2;
            if (bl) {
                String string2 = this.datafile.getFilename() + ".bcd";
                n2 = this.datafile.getFilename().lastIndexOf(46);
                if (n2 > 0) {
                    string2 = this.datafile.getFilename().substring(0, n2) + ".bcd";
                }
                if ((outputStream = new FileOutputStream(string2)) == null) {
                    throw new Exception("Can't open output file " + string2);
                }
                string = "Writing " + string2;
            } else {
                string = "Evaluating";
            }
            if (this.progressWatcher != null) {
                this.progressWatcher.reportProgress(string, 0, this.datafile.getRecords().getCount());
            }
            int n3 = 0;
            n2 = this.datafile.getRecords().getCount() - 1;
            int n4 = 1;
            for (n = 0; n < this.datafile.getRecords().getCount() && !this.datafile.getRecords().get(n).getMotionForward(); ++n) {
                n2 = 0;
                n4 = -1;
            }
            if (n > 0) {
                --n;
            }
            int n5 = n;
            while (!(record = this.datafile.getRecords().get(n5)).getMotionForward() || n4 != -1) {
                byte[] byArray;
                RecordInfo recordInfo = this.evaluateRecord(record, bl2);
                if (recordInfo.getErrors() > 0) {
                    this.evalErrors += recordInfo.getErrors();
                    if (printStream != null) {
                        printStream.println("Record " + record.getNumber() + " errors " + recordInfo.getErrors());
                    }
                }
                this.evalFixups += recordInfo.getFixups();
                if (recordInfo.getSpacing() < this.spacingHist.length) {
                    int n6 = recordInfo.getSpacing();
                    this.spacingHist[n6] = this.spacingHist[n6] + 1;
                }
                if (outputStream != null && (byArray = recordInfo.getData(n4 == -1)) != null) {
                    if (this.nchannel < 8) {
                        byArray[0] = (byte)(byArray[0] | 0x80);
                    }
                    outputStream.write(byArray, 0, byArray.length);
                }
                if (n5 != n2) {
                    if (this.progressWatcher != null && (n3 += (int)(record.getEnd() - record.getStart())) >= 10000) {
                        int n7 = n5 - n;
                        int n8 = n2 - n + 1;
                        if (n4 < 0) {
                            n7 = -n7;
                            n8 = -n8;
                        }
                        String string3 = string + ", " + n7 + " records";
                        this.progressWatcher.reportProgress(string3, n7, n8);
                        n3 = 0;
                    }
                    n5 += n4;
                    continue;
                }
                break;
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (bl) {
            this.datacollection.write();
        }
        if (this.progressWatcher != null) {
            this.progressWatcher.finished();
            this.progressWatcher = null;
        }
    }

    @Override
    public void writeInfo() throws IOException {
        this.datacollection.write();
    }

    @Override
    public void close() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
    }

    @Override
    public void setPosition(long l) {
        this.setPosition(l, 0L);
    }

    @Override
    public void setPosition(long l, long l2) {
        Record record = this.getRecord(l);
        if (record != null) {
            if (this.currentRecord != record) {
                this.currentRecord = record;
                this.currentRecordInfo = null;
            }
            if (this.currentRecordInfo == null) {
                try {
                    this.currentRecordInfo = this.evaluateRecord(record);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        } else {
            this.currentRecord = null;
            this.currentRecordInfo = null;
        }
        this.source.setPosition(l);
        if (l2 > 0L) {
            this.source.setLimit(l + l2);
        } else {
            this.source.resetLimit();
        }
    }

    @Override
    public void reEvaluate() {
        this.currentRecordInfo = null;
    }

    @Override
    public long getPosition() {
        return this.source.getPosition();
    }

    @Override
    public void advance() {
        this.source.advance();
    }

    @Override
    public int getErrorCount() {
        this.setCurrent();
        if (this.currentRecordInfo != null) {
            return this.currentRecordInfo.getErrors();
        }
        return 0;
    }

    @Override
    public int getErrorTotal() {
        return this.evalErrors;
    }

    public int getFixupTotal() {
        return this.evalFixups;
    }

    public int getGapJunk() {
        return this.gapJunk;
    }

    public int[] getSpacingHist() {
        return this.spacingHist;
    }

    public long getSpacing() {
        this.setCurrent();
        if (this.currentRecordInfo != null) {
            return this.currentRecordInfo.getSpacing();
        }
        return 0L;
    }

    @Override
    public long getNextError() {
        this.setCurrent();
        long l = this.getPosition();
        if (this.currentRecordInfo != null) {
            int n;
            int n2;
            for (n2 = (int)(l - this.currentRecord.getStart()); n2 < this.currentRecordInfo.getLength() && (n = this.currentRecordInfo.getStatus(n2)) != 0 && (n & 1) == 0; ++n2) {
            }
            while (n2 < this.currentRecordInfo.getLength() && ((n = this.currentRecordInfo.getStatus(n2)) == 0 || (n & 1) != 0)) {
                ++n2;
            }
            while (n2 < this.currentRecordInfo.getLength()) {
                n = this.currentRecordInfo.getDataPoint(n2);
                if (n != 0) {
                    return this.currentRecord.getStart() + (long)n2;
                }
                ++n2;
            }
        }
        Record record = this.currentRecord;
        while ((record = record == null ? this.getNextRecord() : this.getNextRecord(record)) != null) {
            if (record.getErrors() == 0) continue;
            try {
                RecordInfo recordInfo = this.evaluateRecord(record);
                for (int i = 0; i < recordInfo.getLength(); ++i) {
                    int n = recordInfo.getStatus(i);
                    if (n == 0 || (n & 1) != 0) continue;
                    return record.getStart() + (long)i;
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return this.getPosition();
    }

    @Override
    public boolean hasActivity() {
        return true;
    }

    private void setCurrent() {
        if (this.currentRecord == null) {
            this.currentRecord = this.getRecord();
            this.currentRecordInfo = null;
            return;
        }
        long l = this.getPosition();
        if (this.currentRecord.getStart() > l || this.currentRecord.getEnd() < l) {
            Record record = this.getRecord(l);
            if (record == this.currentRecord) {
                return;
            }
            this.currentRecord = record;
            this.currentRecordInfo = null;
        }
    }

    @Override
    public int getActivityCountHere() {
        this.setCurrent();
        if (this.currentRecordInfo == null) {
            return 0;
        }
        return this.currentRecordInfo.getCount((int)(this.getPosition() - this.currentRecord.getStart()));
    }

    @Override
    public int getActivityLumpedHere() {
        this.setCurrent();
        if (this.currentRecordInfo == null) {
            return 0;
        }
        return this.currentRecordInfo.getLumped((int)(this.getPosition() - this.currentRecord.getStart()));
    }

    @Override
    public int getActivityStatusHere() {
        this.setCurrent();
        if (this.currentRecordInfo == null) {
            return 0;
        }
        return this.currentRecordInfo.getStatus((int)(this.getPosition() - this.currentRecord.getStart()));
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public boolean isDataValidHere() {
        this.setCurrent();
        if (this.currentRecordInfo == null) {
            return false;
        }
        return this.currentRecordInfo.isDataValid((int)(this.getPosition() - this.currentRecord.getStart()));
    }

    @Override
    public int getDataHere() {
        this.setCurrent();
        if (this.currentRecordInfo == null) {
            return 0;
        }
        return this.currentRecordInfo.getData((int)(this.getPosition() - this.currentRecord.getStart()));
    }

    @Override
    public boolean recordOriented() {
        return true;
    }

    @Override
    public int getNumRecords() {
        if (this.datafile.getRecords() != null) {
            return this.datafile.getRecords().getCount();
        }
        return 0;
    }

    @Override
    public Record getRecord(int n) {
        if (this.datafile.getRecords().getCount() > 0 && n > 0 && n <= this.datafile.getRecords().getCount()) {
            return this.datafile.getRecords().get(n - 1);
        }
        return null;
    }

    @Override
    public Record getRecord() {
        return this.getRecord(this.getPosition());
    }

    @Override
    public Record getRecord(long l) {
        Record record = this.currentRecord;
        int n = this.source.getTapeParameters().getMaxSpace();
        while (true) {
            if (record != null && record.getStart() - (long)n <= l && record.getEnd() + (long)n >= l) {
                return record;
            }
            if (this.datafile.getRecords().getCount() <= 0) break;
            if (record != null) {
                Record record2;
                if (l > record.getEnd()) {
                    record2 = this.getRecord(record.getNumber() + 1);
                    if (record2 == null || l < record2.getStart() - (long)n) {
                        return record;
                    }
                    record = record2;
                    continue;
                }
                record2 = this.getRecord(record.getNumber() - 1);
                if (record2 == null || l > record2.getEnd() + (long)n) {
                    return record;
                }
                record = record2;
                continue;
            }
            record = this.datafile.getRecords().get(0);
        }
        return null;
    }

    @Override
    public Record getNextRecord() {
        return this.getNextRecord(this.getPosition());
    }

    @Override
    public Record getNextRecord(Record record) {
        return this.getNextRecord(record.getEnd());
    }

    @Override
    public Record getNextRecord(long l) {
        if (this.datafile.getRecords().getCount() > 0) {
            for (int i = 0; i < this.datafile.getRecords().getCount(); ++i) {
                Record record = this.datafile.getRecords().get(i);
                if (record.getStart() <= l) continue;
                return record;
            }
        }
        return null;
    }

    @Override
    public Record getPreviousRecord() {
        return this.getPreviousRecord(this.getPosition());
    }

    @Override
    public Record getPreviousRecord(Record record) {
        return this.getPreviousRecord(record.getStart());
    }

    @Override
    public Record getPreviousRecord(long l) {
        if (this.datafile.getRecords().getCount() > 0) {
            for (int i = this.datafile.getRecords().getCount() - 1; i >= 0; --i) {
                Record record = this.datafile.getRecords().get(i);
                if (record.getEnd() >= l) continue;
                return record;
            }
        }
        return null;
    }
}

