/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.TapeParametersList;
import java.io.BufferedWriter;
import java.io.IOException;

public class TapeParameters {
    private TapeParametersList tpl;
    private TapeParameters parent = null;
    private double gain = 1200.0;
    private long start = 0L;
    private long end = 0L;
    private int nchannel = 0;
    private int[] skew = null;
    private int width = 9;
    private boolean lowClip = false;
    private int[] clip = null;
    private int[] limit = null;
    private int lowspace = 35;
    private int highspace = 150;
    private int crowd = 13;
    private int gather = 3;
    private int maxspace = 300;
    private int mingap = 6000;
    private int maxjunk = 5;

    private int getDefaultClip() {
        return this.width * 2048 / 8;
    }

    public TapeParameters(int n, long l, long l2, TapeParameters tapeParameters, TapeParametersList tapeParametersList) {
        int n2;
        this.start = l;
        this.end = l2;
        this.parent = tapeParameters;
        this.nchannel = n;
        this.tpl = tapeParametersList;
        this.skew = new int[n];
        this.clip = new int[n];
        this.limit = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.skew[n2] = 0;
            this.clip[n2] = this.getDefaultClip();
            this.limit[n2] = this.clip[n2];
        }
        if (tapeParameters != null) {
            this.gain = tapeParameters.gain;
            this.width = tapeParameters.width;
            this.lowClip = tapeParameters.lowClip;
            for (n2 = 0; n2 < n; ++n2) {
                this.clip[n2] = tapeParameters.clip[n2];
                this.skew[n2] = tapeParameters.skew[n2];
                this.limit[n2] = tapeParameters.limit[n2];
            }
            this.lowspace = tapeParameters.lowspace;
            this.highspace = tapeParameters.highspace;
            this.crowd = tapeParameters.crowd;
            this.gather = tapeParameters.gather;
            this.maxspace = tapeParameters.maxspace;
            this.mingap = tapeParameters.mingap;
            this.maxjunk = tapeParameters.maxjunk;
        }
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) throws Exception {
        if (l > this.end || this.parent != null && (l < this.parent.start || l > this.parent.end)) {
            throw new Exception("Invalid start position");
        }
        this.start = l;
        this.tpl.invalidate();
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long l) throws Exception {
        if (l < this.start || this.parent != null && (l < this.parent.start || l > this.parent.end)) {
            throw new Exception("Invalid end position");
        }
        this.end = l;
        this.tpl.invalidate();
    }

    public boolean getLowClip() {
        return this.lowClip;
    }

    public void setLowClip(boolean bl) {
        if (this.canChangeLowClip()) {
            this.lowClip = bl;
        }
    }

    public boolean canChangeLowClip() {
        if (this.parent == null) {
            return false;
        }
        return !this.parent.lowClip;
    }

    public TapeParameters getParent() {
        return this.parent;
    }

    public void setParent(TapeParameters tapeParameters) {
        this.parent = tapeParameters;
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double d) {
        this.gain = d;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n + (n + 1) % 2;
    }

    public int getLowSpace() {
        return this.lowspace;
    }

    public void setLowSpace(int n) {
        this.lowspace = n;
    }

    public int getHighSpace() {
        return this.highspace;
    }

    public void setHighSpace(int n) {
        this.highspace = n;
    }

    public int getCrowd() {
        return this.crowd;
    }

    public void setCrowd(int n) {
        this.crowd = n;
    }

    public int getGather() {
        return this.gather;
    }

    public void setGather(int n) {
        this.gather = n;
    }

    public int getMaxSpace() {
        return this.maxspace;
    }

    public void setMaxSpace(int n) {
        this.maxspace = n;
    }

    public int getMinGap() {
        return this.mingap;
    }

    public void setMinGap(int n) {
        this.mingap = n;
    }

    public int getMaxJunk() {
        return this.maxjunk;
    }

    public void setMaxJunk(int n) {
        this.maxjunk = n;
    }

    public int[] getSkew() {
        return this.skew;
    }

    public int[] getBaseLimit() {
        return this.limit;
    }

    public int getClip(boolean bl, int n) {
        if (!this.lowClip || bl) {
            return this.clip[n];
        }
        TapeParameters tapeParameters = this.parent;
        while (tapeParameters != null) {
            if (!tapeParameters.lowClip) {
                return tapeParameters.clip[n];
            }
            tapeParameters = tapeParameters.parent;
        }
        return this.getDefaultClip();
    }

    public void setClip(int n, int n2) {
        this.clip[n2] = n;
    }

    public void setClip(int n, boolean bl, int n2) {
        this.clip[n2] = n;
        this.lowClip = bl;
    }

    public void write(BufferedWriter bufferedWriter, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        String string2 = string = "                    ".substring(0, n);
        bufferedWriter.write(string + "<tapeparameters start=\"" + this.start + "\" end=\"" + this.end + "\"");
        bufferedWriter.newLine();
        if (this.parent == null || this.parent.gain != this.gain) {
            String string3 = " gain=\"" + this.gain + "\"";
            if (string2.length() + string3.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string3;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (n5 = 1; n5 < this.nchannel; ++n5) {
            if (this.skew[n5] == this.skew[0]) continue;
            bl2 = false;
        }
        if (this.parent != null) {
            bl = false;
            for (n5 = 0; n5 < this.nchannel; ++n5) {
                if (this.skew[n5] == this.parent.skew[n5]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            String string4 = " skew=\"";
            for (n4 = 0; n4 < this.nchannel; ++n4) {
                string4 = string4 + this.skew[n4];
                if (bl2) break;
                if (n4 >= this.nchannel - 1) continue;
                string4 = string4 + ",";
            }
            string4 = string4 + "\"";
            if (string2.length() + string4.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string4;
        }
        if (this.parent == null || this.parent.width != this.width) {
            String string5 = " width=\"" + this.width + "\"";
            if (string2.length() + string5.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string5;
        }
        bl = true;
        bl2 = true;
        for (n3 = 1; n3 < this.nchannel; ++n3) {
            if (this.clip[n3] == this.clip[0]) continue;
            bl2 = false;
        }
        if (this.parent != null && this.parent.lowClip == this.lowClip) {
            bl = false;
            for (n3 = 0; n3 < this.nchannel; ++n3) {
                if (this.clip[n3] == this.parent.clip[n3]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            String string6 = " lowclip=\"" + this.lowClip + "\" clip=\"";
            for (n4 = 0; n4 < this.nchannel; ++n4) {
                string6 = string6 + this.clip[n4];
                if (bl2) break;
                if (n4 >= this.nchannel - 1) continue;
                string6 = string6 + ",";
            }
            string6 = string6 + "\"";
            if (string2.length() + string6.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string6;
        }
        bl = true;
        bl2 = true;
        for (n2 = 1; n2 < this.nchannel; ++n2) {
            if (this.limit[n2] == this.limit[0]) continue;
            bl2 = false;
        }
        if (this.parent != null) {
            bl = false;
            for (n2 = 0; n2 < this.nchannel; ++n2) {
                if (this.limit[n2] == this.parent.limit[n2]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            String string7 = " baselimit=\"";
            for (n4 = 0; n4 < this.nchannel; ++n4) {
                string7 = string7 + this.limit[n4];
                if (bl2) break;
                if (n4 >= this.nchannel - 1) continue;
                string7 = string7 + ",";
            }
            string7 = string7 + "\"";
            if (string2.length() + string7.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string7;
        }
        if (this.parent == null || this.parent.crowd != this.crowd) {
            String string8 = " crowd=\"" + this.crowd + "\"";
            if (string2.length() + string8.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string8;
        }
        if (this.parent == null || this.parent.lowspace != this.lowspace) {
            String string9 = " lowspace=\"" + this.lowspace + "\"";
            if (string2.length() + string9.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string9;
        }
        if (this.parent == null || this.parent.highspace != this.highspace) {
            String string10 = " highspace=\"" + this.highspace + "\"";
            if (string2.length() + string10.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string10;
        }
        if (this.parent == null || this.parent.gather != this.gather) {
            String string11 = " gather=\"" + this.gather + "\"";
            if (string2.length() + string11.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string11;
        }
        if (this.parent == null || this.parent.maxspace != this.maxspace) {
            String string12 = " maxspace=\"" + this.maxspace + "\"";
            if (string2.length() + string12.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string12;
        }
        if (this.parent == null || this.parent.mingap != this.mingap) {
            String string13 = " mingap=\"" + this.mingap + "\"";
            if (string2.length() + string13.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string13;
        }
        if (this.parent == null || this.parent.maxjunk != this.maxjunk) {
            String string14 = " maxjunk=\"" + this.maxjunk + "\"";
            if (string2.length() + string14.length() > 72) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = string;
            }
            string2 = string2 + string14;
        }
        bufferedWriter.write(string2 + " />");
        bufferedWriter.newLine();
    }
}

