/*
 * Decompiled with CFR 0.152.
 */
package com.piercefuller.a7trk.decode;

import com.piercefuller.a7trk.decode.TapeParameters;
import java.util.ArrayList;

public class TapeParametersList {
    private int nchannel;
    private ArrayList<TapeParameters> tpl = new ArrayList();
    private int current1 = 0;
    private long lowEdge1 = 0L;
    private long highEdge1 = -1L;
    private int current2 = 0;
    private long lowEdge2 = 0L;
    private long highEdge2 = -1L;

    public int getCount() {
        return this.tpl.size();
    }

    public TapeParameters get(int n) {
        return this.tpl.get(n);
    }

    public TapeParametersList(int n) {
        this.nchannel = n;
    }

    public void invalidate() {
        this.lowEdge1 = 0L;
        this.highEdge1 = -1L;
        this.lowEdge2 = 0L;
        this.highEdge2 = -1L;
    }

    public TapeParameters add(long l, long l2) throws Exception {
        TapeParameters tapeParameters = null;
        for (int i = 0; i < this.tpl.size(); ++i) {
            TapeParameters tapeParameters2 = this.get(i);
            if (tapeParameters2.getStart() <= l && tapeParameters2.getEnd() >= l2) {
                if (tapeParameters != null && (tapeParameters.getStart() > tapeParameters2.getStart() || tapeParameters.getEnd() < tapeParameters2.getEnd())) continue;
                tapeParameters = tapeParameters2;
                continue;
            }
            if ((tapeParameters2.getStart() > l || tapeParameters2.getEnd() <= l) && (tapeParameters2.getStart() >= l2 || tapeParameters2.getEnd() < l2)) continue;
            throw new Exception("Overlapping start and end of TapeParameters");
        }
        TapeParameters tapeParameters3 = new TapeParameters(this.nchannel, l, l2, tapeParameters, this);
        this.tpl.add(tapeParameters3);
        this.invalidate();
        return tapeParameters3;
    }

    public void remove(TapeParameters tapeParameters) {
        TapeParameters tapeParameters2 = tapeParameters.getParent();
        if (tapeParameters2 != null) {
            for (int i = 1; i < this.getCount(); ++i) {
                if (this.get(i).getParent() != tapeParameters) continue;
                this.get(i).setParent(tapeParameters2);
            }
            this.tpl.remove(tapeParameters);
            this.invalidate();
        }
    }

    public void clear() {
        this.tpl.clear();
    }

    public TapeParameters getTapeParameters(long l) {
        if (l >= this.lowEdge1 && l < this.highEdge1) {
            return this.get(this.current1);
        }
        if (l >= this.lowEdge2 && l < this.highEdge2) {
            return this.get(this.current2);
        }
        TapeParameters tapeParameters = this.get(0);
        if (l < tapeParameters.getStart() || l > tapeParameters.getEnd()) {
            return tapeParameters;
        }
        long l2 = tapeParameters.getStart();
        long l3 = tapeParameters.getEnd();
        int n = 0;
        for (int i = 1; i < this.tpl.size(); ++i) {
            TapeParameters tapeParameters2 = this.get(i);
            if (tapeParameters2.getStart() <= l && tapeParameters2.getEnd() >= l) {
                if (tapeParameters.getStart() > tapeParameters2.getStart() || tapeParameters.getEnd() < tapeParameters2.getEnd()) continue;
                tapeParameters = tapeParameters2;
                n = i;
                if (tapeParameters.getStart() > l2) {
                    l2 = tapeParameters.getStart();
                }
                if (tapeParameters.getEnd() >= l3) continue;
                l3 = tapeParameters.getEnd();
                continue;
            }
            if (tapeParameters2.getEnd() < l && tapeParameters2.getEnd() > l2) {
                l2 = tapeParameters2.getEnd();
                continue;
            }
            if (tapeParameters2.getStart() <= l || tapeParameters2.getStart() >= l3) continue;
            l3 = tapeParameters2.getStart();
        }
        if (this.highEdge1 < this.lowEdge1) {
            this.lowEdge1 = l2;
            this.highEdge1 = l3;
            this.current1 = n;
        } else if (this.highEdge2 < this.lowEdge2) {
            this.lowEdge2 = l2;
            this.highEdge2 = l3;
            this.current2 = n;
        } else if (l2 == this.highEdge1) {
            this.lowEdge2 = l2;
            this.highEdge2 = l3;
            this.current2 = n;
        } else if (l2 == this.highEdge2) {
            this.lowEdge1 = l2;
            this.highEdge1 = l3;
            this.current1 = n;
        } else {
            this.lowEdge2 = l2;
            this.highEdge2 = l3;
            this.current2 = n;
        }
        return tapeParameters;
    }
}

