/*
 * Decompiled with CFR 0.152.
 */
package org.avparade.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.avparade.xml.XMLHandlerBase;
import org.w3c.dom.Document;

public class JaxpXMLHandler
extends XMLHandlerBase {
    private Transformer transformer = TransformerFactory.newInstance().newTransformer();

    @Override
    public Document parse(Object object, Document document) {
        StreamSource streamSource;
        if (object instanceof File) {
            streamSource = new StreamSource((File)object);
        } else if (object instanceof InputStream) {
            streamSource = new StreamSource((InputStream)object);
        } else if (object instanceof String) {
            streamSource = new StreamSource(new ByteArrayInputStream(((String)object).getBytes()));
        } else {
            throw new RuntimeException("Cannot parse object of type " + object.getClass().getName());
        }
        DOMResult dOMResult = new DOMResult();
        try {
            this.transformer.transform(streamSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException("Cannot parse", transformerException);
        }
        return (Document)dOMResult.getNode();
    }

    @Override
    public void write(Object object, Document document, Document document2) {
        StreamResult streamResult;
        DOMSource dOMSource = new DOMSource(document);
        if (object instanceof File) {
            streamResult = new StreamResult((File)object);
        } else if (object instanceof OutputStream) {
            streamResult = new StreamResult((OutputStream)object);
        } else if (object instanceof Writer) {
            streamResult = new StreamResult((Writer)object);
        } else {
            throw new RuntimeException("Cannot write to object of type " + object.getClass().getName());
        }
        try {
            this.transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException("Cannot write", transformerException);
        }
    }
}

