
#include <stdlib.h>
#include <stdio.h>

#include "nltab.h"
#include "a7tsep.h"

#define BLOCKSEG ((BLOCKSIZE)/(NCHAN))

typedef struct data {
	short ch[NCHAN];
	unsigned char control;
	unsigned char status;
} data_t;

unsigned char buf[NCHAN][2*BLOCKSEG];
long count;

unsigned char csbuf[BLOCKSEG];
int csi;
long cscount;

char *infile;
char *outfile;
FILE *fi;
FILE *fo;

int main(int argc, char **argv)
{
	data_t databuf;
	int i, j, n;

	if (argc != 3) {
		fprintf(stderr, "Usage: a7trejoin <in> <out>\n");
		exit(1);
	}
	infile = argv[1];
	outfile = argv[2];

	if (strcmp(infile, "-") == 0) {
		fi = stdin;
	} else {
		fi = fopen(infile, "rb");
		if (fi == NULL) {
			perror(infile);
			exit(1);
		}
	}
	if (strcmp(outfile, "-") == 0) {
		fo = stdout;
	} else {
		fo = fopen(outfile, "wb");
		if (fo == NULL) {
			perror(outfile);
			exit(1);
		}
	}

	count = 0;
	csi = 8;
	cscount = 0;
	for (;;) {
		if (fread(csbuf, 14, 1, fi) != 1) {
			break;
		}
		if (csbuf[0] != 'A' ||
		    csbuf[1] != '7' ||
		    csbuf[2] != 'T' ||
		    csbuf[3] != 0) {
			fprintf(stderr, "Invalid input\n");
			exit(1);
		}
		count =   ((long)csbuf[ 4] & 0xFF) << 24 |
		          ((long)csbuf[ 5] & 0xFF) << 16 |
		          ((long)csbuf[ 6] & 0xFF) <<  8 |
		          ((long)csbuf[ 7] & 0xFF);
		cscount = ((long)csbuf[ 8] & 0xFF) << 24 |
		          ((long)csbuf[ 9] & 0xFF) << 16 |
		          ((long)csbuf[10] & 0xFF) <<  8 |
		          ((long)csbuf[11] & 0xFF);
		databuf.control = csbuf[12];
		databuf.status = csbuf[13];
		csi = 14;
		for (n = cscount; n < count; ) {
			if (fread(&csbuf[csi], 6, 1, fi) != 1) {
				fprintf(stderr, "Short input\n");
				exit(1);
			}
			n += ((long)csbuf[csi+0] & 0xFF) << 24 |
			     ((long)csbuf[csi+1] & 0xFF) << 16 |
			     ((long)csbuf[csi+2] & 0xFF) <<  8 |
			     ((long)csbuf[csi+3] & 0xFF);
			csi += 6;
		}
		if (n != count) {
			fprintf(stderr, "Mismatch cs count\n");
			exit(1);
		}

		for (i = 0; i < NCHAN; i++) {
			if (fread(buf[i], count, 1, fi) != 1) {
				fprintf(stderr, "Short input\n");
				exit(1);
			}
		}
		n = BLOCKSIZE - (csi + NCHAN*count);
		csi = 14;

		for (i = 0; i < count; i++) {
			for (j = 0; j < NCHAN; j++) {
				databuf.ch[j] = nl_decode[buf[j][i]];
			}
			if (fwrite(&databuf, sizeof(databuf), 1, fo) != 1) {
				perror(outfile);
				exit(1);
			}
			if (i < count-1) {
				cscount--;
				if (cscount == 0) {
					cscount = ((long)csbuf[csi+0] & 0xFF) << 24 |
						  ((long)csbuf[csi+1] & 0xFF) << 16 |
						  ((long)csbuf[csi+2] & 0xFF) <<  8 |
						  ((long)csbuf[csi+3] & 0xFF);
					databuf.control = csbuf[csi+4];
					databuf.status = csbuf[csi+5];
					csi += 6;
				}
			}
		}
		if (fread(&csbuf[csi], n, 1, fi) != 1) {
			break;
		}
	}
	fclose(fi);
	fclose(fo);
	exit(0);
}

