
#include <stdlib.h>
#include <stdio.h>

#include "nltab.h"
#include "a7tsep.h"

#define BLOCKSEG ((BLOCKSIZE)/(NCHAN))

typedef struct data {
	short ch[NCHAN];
	unsigned char control;
	unsigned char status;
} data_t;

unsigned char buf[NCHAN][2*BLOCKSEG];
long count;

unsigned char csbuf[BLOCKSEG];
int csi;
long cscount;
int block_count;

char *infile;
char outfile[1000];
int outfileno;
FILE *fi;
FILE *fo;

void flushbufs(int target)
{
	char newfile[1000];
	int i;
	int n;

	if ((block_count % NBLOCK) == 0 && fo != stdout) {
		if (fo != 0) {
			fclose(fo);
		}
		sprintf(newfile, "%s%02d", outfile, outfileno);
		outfileno++;
		fo = fopen(newfile, "wb");
		if (fo == NULL) {
			perror(newfile);
			exit(1);
		}
	}
	block_count++;

	csbuf[csi+0] = (cscount >> 24) & 0xFF;
	csbuf[csi+1] = (cscount >> 16) & 0xFF;
	csbuf[csi+2] = (cscount >>  8) & 0xFF;
	csbuf[csi+3] = (cscount      ) & 0xFF;
	csi += 6;
	csbuf[0] = 'A';
	csbuf[1] = '7';
	csbuf[2] = 'T';
	csbuf[3] = 0;
	csbuf[4] = (count >> 24) & 0xFF;
	csbuf[5] = (count >> 16) & 0xFF;
	csbuf[6] = (count >>  8) & 0xFF;
	csbuf[7] = (count      ) & 0xFF;
	fwrite(csbuf, csi, 1, fo);
	n = csi;

	for (i = 0; i < NCHAN; i++) {
		fwrite(buf[i], count, 1, fo);
		n += count;
	}
	for (; n < target; n++) {
		fputc(0, fo);
	}

	csi = 8;
	count = 0;
	cscount = 0;
}

int main(int argc, char **argv)
{
	data_t databuf;
	int i;
	char *p;

	if (argc != 2 && argc != 3) {
		fprintf(stderr, "Usage: a7tsep <in> [<out>]\n");
		exit(1);
	}

	infile = argv[1];
	if (strcmp(infile, "-") == 0) {
		fi = stdin;
	} else {
		fi = fopen(infile, "rb");
		if (fi == NULL) {
			perror(infile);
			exit(1);
		}
	}

	if (argc > 2) {
		strncpy(outfile, argv[2], sizeof(outfile)-5);
	} else {
		strncpy(outfile, infile, sizeof(outfile)-5);
		p = &outfile[strlen(outfile)-4];
		if (p > outfile && strcmp(p, ".dat") == 0 || strcmp(p, ".DAT") == 0) {
			strcpy(p, ".sep");
		}
	}
	outfileno = 0;
	if (strcmp(outfile, "-") == 0) {
		fo = stdout;
	} else {
		fo = 0;
	}

	count = 0;
	csi = 8;
	cscount = 0;
	block_count = 0;
	for (;;) {
		if (fread(&databuf, sizeof(databuf), 1, fi) != 1) {
			break;
		}
		for (i = 0; i < NCHAN; i++) {
			buf[i][count] = nl_encode[databuf.ch[i] & 0x0FFF];
		}
		count++;

		if (cscount == 0) {
			csbuf[csi+4] = databuf.control;
			csbuf[csi+5] = databuf.status;
			cscount = 1;
		} else if (csbuf[csi+4] == databuf.control &&
		           csbuf[csi+5] == databuf.status) {
			cscount++;
		} else {
			csbuf[csi+0] = (cscount >> 24) & 0xFF;
			csbuf[csi+1] = (cscount >> 16) & 0xFF;
			csbuf[csi+2] = (cscount >>  8) & 0xFF;
			csbuf[csi+3] = (cscount      ) & 0xFF;
			csi += 6;
			csbuf[csi+4] = databuf.control;
			csbuf[csi+5] = databuf.status;
			cscount = 1;
		}

		if (csi + 6 + NCHAN*(count+1) + 6 > BLOCKSIZE) {
			flushbufs(BLOCKSIZE);
		}
	}
	if (cscount > 0) {
		flushbufs(0);
	}
	fclose(fi);
	if (fo != 0 && fo != stdout) {
		fclose(fo);
	}
	exit(0);
	return 0;
}

