/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using System.IO;
using System.Xml;

namespace a7tlib
{
	/// <summary>
	/// Represents an artifact. Limited representation for a7tview.
	/// </summary>
	public class Artifact
	{
		private string id;
		private string description;

		public string Id { get { return id; } }
		public string Description { get { return description; } }

		public Artifact(string filename)
		{
			string fid = filename.ToLower();
			int i = fid.LastIndexOf("/");
			if (i < 0) 
			{
				i = fid.LastIndexOf("\\");
			}
			if (i > 0) 
			{
				fid = fid.Substring(i);
			}

			XmlDocument doc = new XmlDocument();
			doc.Load(new FileStream(filename, FileMode.Open));

			XmlNodeList files = doc.DocumentElement.GetElementsByTagName("artifact");
			foreach (XmlElement a in files)
			{
				string tid = a.GetAttribute("id");
				if (tid != null && tid.EndsWith(fid)) 
				{
					id = tid;
					description = a.GetAttribute("description");
					if (description == null) 
					{
						description = "";
					}
					return;
				}
			}
			throw new Exception("Artifact not found");
		}
	}
}
