/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace a7tview
{
	/// <summary>
	/// Summary description for ColorDialog.
	/// </summary>
	public class ColorDialog : System.Windows.Forms.Form
	{
		private Colors colors;

		private System.Windows.Forms.ColorDialog colorDialog1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Button button5;
		private System.Windows.Forms.Button button6;
		private System.Windows.Forms.Button button7;
		private System.Windows.Forms.Button button8;
		private System.Windows.Forms.Button button9;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ColorDialog(Colors c)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			colors = c;

			button1.BackColor = colors.backgroundColor;
			button2.BackColor = colors.backgroundColor;
			button3.BackColor = colors.backgroundColor;
			button4.BackColor = colors.backgroundColor;
			button5.BackColor = colors.backgroundColor;
			button6.BackColor = colors.backgroundColor;
			button7.BackColor = colors.backgroundColor;
			button8.BackColor = colors.backgroundColor;
			button9.BackColor = colors.backgroundColor;

			button1.ForeColor = colors.rawColor;
			button2.ForeColor = colors.lumpColor;
			button3.ForeColor = colors.directionColor;
			button4.ForeColor = colors.sliderColor;
			button5.ForeColor = colors.centerColor;
			button6.ForeColor = colors.zeroColor;
			button7.ForeColor = colors.clipColor;
			button9.ForeColor = colors.baseColor;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.colorDialog1 = new System.Windows.Forms.ColorDialog();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.button4 = new System.Windows.Forms.Button();
			this.button5 = new System.Windows.Forms.Button();
			this.button6 = new System.Windows.Forms.Button();
			this.button7 = new System.Windows.Forms.Button();
			this.button8 = new System.Windows.Forms.Button();
			this.button9 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.BackColor = System.Drawing.Color.White;
			this.button1.Location = new System.Drawing.Point(24, 24);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(72, 23);
			this.button1.TabIndex = 1;
			this.button1.Text = "Raw";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.BackColor = System.Drawing.Color.White;
			this.button2.Location = new System.Drawing.Point(24, 56);
			this.button2.Name = "button2";
			this.button2.TabIndex = 2;
			this.button2.Text = "Lump";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button3
			// 
			this.button3.BackColor = System.Drawing.Color.White;
			this.button3.Location = new System.Drawing.Point(24, 120);
			this.button3.Name = "button3";
			this.button3.TabIndex = 3;
			this.button3.Text = "Dir";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button4
			// 
			this.button4.BackColor = System.Drawing.Color.White;
			this.button4.Location = new System.Drawing.Point(72, 152);
			this.button4.Name = "button4";
			this.button4.TabIndex = 4;
			this.button4.Text = "Slider";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// button5
			// 
			this.button5.BackColor = System.Drawing.Color.White;
			this.button5.Location = new System.Drawing.Point(128, 24);
			this.button5.Name = "button5";
			this.button5.TabIndex = 5;
			this.button5.Text = "Center Line";
			this.button5.Click += new System.EventHandler(this.button5_Click);
			// 
			// button6
			// 
			this.button6.BackColor = System.Drawing.Color.White;
			this.button6.Location = new System.Drawing.Point(128, 56);
			this.button6.Name = "button6";
			this.button6.TabIndex = 6;
			this.button6.Text = "Zero Line";
			this.button6.Click += new System.EventHandler(this.button6_Click);
			// 
			// button7
			// 
			this.button7.BackColor = System.Drawing.Color.White;
			this.button7.Location = new System.Drawing.Point(128, 88);
			this.button7.Name = "button7";
			this.button7.TabIndex = 7;
			this.button7.Text = "Clip Line";
			this.button7.Click += new System.EventHandler(this.button7_Click);
			// 
			// button8
			// 
			this.button8.BackColor = System.Drawing.Color.White;
			this.button8.Location = new System.Drawing.Point(24, 184);
			this.button8.Name = "button8";
			this.button8.Size = new System.Drawing.Size(176, 23);
			this.button8.TabIndex = 8;
			this.button8.Text = "Background";
			this.button8.Click += new System.EventHandler(this.button8_Click);
			// 
			// button9
			// 
			this.button9.BackColor = System.Drawing.Color.White;
			this.button9.Location = new System.Drawing.Point(24, 88);
			this.button9.Name = "button9";
			this.button9.TabIndex = 9;
			this.button9.Text = "Base";
			this.button9.Click += new System.EventHandler(this.button9_Click);
			// 
			// ColorDialog
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(216, 214);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button9,
																		  this.button8,
																		  this.button7,
																		  this.button6,
																		  this.button5,
																		  this.button4,
																		  this.button3,
																		  this.button2,
																		  this.button1});
			this.Name = "ColorDialog";
			this.Text = "Choose Colors";
			this.ResumeLayout(false);

		}
		#endregion

		private void button1_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.rawColor = colorDialog1.Color;
			button1.ForeColor = colorDialog1.Color;
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.lumpColor = colorDialog1.Color;
			button2.ForeColor = colorDialog1.Color;
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.directionColor = colorDialog1.Color;
			button3.ForeColor = colorDialog1.Color;
		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.sliderColor = colorDialog1.Color;
			button4.ForeColor = colorDialog1.Color;
		}

		private void button5_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.centerColor = colorDialog1.Color;
			button5.ForeColor = colorDialog1.Color;
		}

		private void button6_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.zeroColor = colorDialog1.Color;
			button6.ForeColor = colorDialog1.Color;
		}

		private void button7_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.clipColor = colorDialog1.Color;
			button7.ForeColor = colorDialog1.Color;
		}

		private void button8_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.backgroundColor = colorDialog1.Color;
			button1.BackColor = colors.backgroundColor;
			button2.BackColor = colors.backgroundColor;
			button3.BackColor = colors.backgroundColor;
			button4.BackColor = colors.backgroundColor;
			button5.BackColor = colors.backgroundColor;
			button6.BackColor = colors.backgroundColor;
			button7.BackColor = colors.backgroundColor;
			button8.BackColor = colors.backgroundColor;
			button9.BackColor = colors.backgroundColor;
		}

		private void button9_Click(object sender, System.EventArgs e)
		{
			colorDialog1.ShowDialog();
			colors.baseColor = colorDialog1.Color;
			button9.ForeColor = colorDialog1.Color;
		}

	}
}
