/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using a7tlib;

namespace a7tview
{
	/// <summary>
	/// Summary description for ConfigDialog.
	/// </summary>
	public class ConfigDialog : System.Windows.Forms.Form
	{
		private MainView parent;
		private int nchannel = 0;
		private TapeParameters tp = null;
		private Label[] channelLabels = null;
		private TextBox[] skewTextBoxes = null;
		private TextBox[] clipTextBoxes = null;
		private TextBox[] baseTextBoxes = null;

		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.TextBox textBox3;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox textBox4;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label17;
		private System.Windows.Forms.TextBox textBox5;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.TextBox textBox6;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.TextBox textBox7;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.TextBox textBox8;
		private System.Windows.Forms.TextBox textBox9;
		private System.Windows.Forms.TextBox textBox10;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.Label label18;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.CheckBox checkBox1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ConfigDialog(MainView p)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			button1.Enabled = true;
			button2.Enabled = false;
			button3.Enabled = false;
			button4.Enabled = false;

			parent = p;
			MultiSource mc = p.GetMultiSource();
			DataFile datafile = mc.GetDataFile();
			Source s = mc.GetSource();
			if (datafile != null) 
			{
				int boxVerticalSpacing = 24;
				nchannel = datafile.Channels;
				channelLabels = new Label[nchannel];
				skewTextBoxes = new TextBox[nchannel];
				clipTextBoxes = new TextBox[nchannel];
				baseTextBoxes = new TextBox[nchannel];
				int v = label8.Location.Y;
				SuspendLayout();
				for (int i = nchannel-1; i >= 0; i--)
				{
					v += boxVerticalSpacing;

					channelLabels[i] = new Label();
					channelLabels[i].Location = new System.Drawing.Point(176, v);
					channelLabels[i].Name = "channelLabel" + i;
					channelLabels[i].Size = new System.Drawing.Size(16, 16);
					channelLabels[i].TabIndex = label12.TabIndex + (nchannel - i);
					channelLabels[i].Text = s.GetChannelName(i);
					Controls.Add(channelLabels[i]);

					skewTextBoxes[i] = new TextBox();
					skewTextBoxes[i].Location = new System.Drawing.Point(208, v);
					skewTextBoxes[i].Name = "skewTextBox" + i;
					skewTextBoxes[i].Size = new System.Drawing.Size(72, 20);
					skewTextBoxes[i].TabIndex = label12.TabIndex + nchannel + (nchannel - i);
					skewTextBoxes[i].Text = "0";
					skewTextBoxes[i].TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
					Controls.Add(skewTextBoxes[i]);

					clipTextBoxes[i] = new TextBox();
					clipTextBoxes[i].Location = new System.Drawing.Point(296, v);
					clipTextBoxes[i].Name = "clipTextBox" + i;
					clipTextBoxes[i].Size = new System.Drawing.Size(72, 20);
					clipTextBoxes[i].TabIndex = label12.TabIndex + 2*nchannel + (nchannel - i);
					clipTextBoxes[i].Text = "0";
					clipTextBoxes[i].TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
					Controls.Add(clipTextBoxes[i]);

					baseTextBoxes[i] = new TextBox();
					baseTextBoxes[i].Location = new System.Drawing.Point(384, v);
					baseTextBoxes[i].Name = "baseTextBox" + i;
					baseTextBoxes[i].Size = new System.Drawing.Size(72, 20);
					baseTextBoxes[i].TabIndex = label12.TabIndex + 3*nchannel + (nchannel - i);
					baseTextBoxes[i].Text = "0";
					baseTextBoxes[i].TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
					Controls.Add(baseTextBoxes[i]);
				}
				ResumeLayout(false);
			}
			textBox1.Text = parent.getRawZoom().ToString();
			textBox3.Text = parent.getLumpZoom().ToString();

			if (nchannel > 0)
			{

				tp = datafile.TapeParameters.GetTapeParameters(parent.GetPosition());

				if (tp.Parent != null) 
				{
					button4.Enabled = true;
					if (tp.End == tp.Parent.End) 
					{
						button3.Enabled = true;
					} 
					else if (tp.Start < parent.GetPosition()) 
					{
						button2.Enabled = true;
					}
				} 
				else 
				{
					button2.Enabled = true;
				}

				label16.Text = tp.Start.ToString();
				label18.Text = tp.End.ToString();
				if (button2.Enabled) 
				{
					label20.Text = parent.GetPosition().ToString();
				}
				else if (button3.Enabled) 
				{
					label19.Text = parent.GetPosition().ToString();
				}

				textBox4.Text = tp.Width.ToString();

				for (int i = 0; i < nchannel; i++)
				{
					skewTextBoxes[i].Text = tp.Skew[i].ToString();
					clipTextBoxes[i].Text = tp.GetClip(true, i).ToString();
					baseTextBoxes[i].Text = tp.BaseLimit[i].ToString();
				}

				checkBox1.Checked = tp.LowClip;
				checkBox1.Enabled = tp.CanChangeLowClip;
				textBox2.Text = tp.LowSpace.ToString();
				textBox7.Text = tp.HighSpace.ToString();
				textBox6.Text = tp.Crowd.ToString();
				textBox5.Text = tp.Gather.ToString();
				textBox8.Text = tp.MaxSpace.ToString();
				textBox9.Text = tp.MinGap.ToString();
				textBox10.Text = tp.MaxJunk.ToString();
			}
			else
			{
				checkBox1.Checked = false;
				textBox4.Text = "";
				textBox2.Text = "";
				textBox7.Text = "";
				textBox6.Text = "";
				textBox5.Text = "";
				textBox8.Text = "";
				textBox9.Text = "";
				textBox10.Text = "";
			}
		}

		public void UpdateValues()
		{
			parent.setRawZoom(int.Parse(textBox1.Text));
			parent.setLumpZoom(int.Parse(textBox3.Text));

			if (tp != null)
			{
				tp.Width =int.Parse(textBox4.Text);

				if (checkBox1.Enabled) 
				{
					tp.LowClip = checkBox1.Checked;
				}

				for (int i = 0; i < nchannel; i++)
				{
					tp.Skew[i] = int.Parse(skewTextBoxes[i].Text);
					tp.SetClip(int.Parse(clipTextBoxes[i].Text), i);
					tp.BaseLimit[i] = int.Parse(baseTextBoxes[i].Text);
				}

				tp.LowSpace = int.Parse(textBox2.Text);
				tp.HighSpace = int.Parse(textBox7.Text);
				tp.Crowd = int.Parse(textBox6.Text);
				tp.Gather = int.Parse(textBox5.Text);
				tp.MaxSpace = int.Parse(textBox8.Text);
				tp.MinGap = int.Parse(textBox9.Text);
				tp.MaxJunk = int.Parse(textBox10.Text);

				parent.GetMultiSource().ReEvaluate();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.button1 = new System.Windows.Forms.Button();
			this.textBox3 = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.textBox4 = new System.Windows.Forms.TextBox();
			this.label7 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label17 = new System.Windows.Forms.Label();
			this.textBox5 = new System.Windows.Forms.TextBox();
			this.label9 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.textBox6 = new System.Windows.Forms.TextBox();
			this.label12 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.textBox7 = new System.Windows.Forms.TextBox();
			this.button2 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.button4 = new System.Windows.Forms.Button();
			this.label13 = new System.Windows.Forms.Label();
			this.label14 = new System.Windows.Forms.Label();
			this.label15 = new System.Windows.Forms.Label();
			this.textBox8 = new System.Windows.Forms.TextBox();
			this.textBox9 = new System.Windows.Forms.TextBox();
			this.textBox10 = new System.Windows.Forms.TextBox();
			this.label16 = new System.Windows.Forms.Label();
			this.label18 = new System.Windows.Forms.Label();
			this.label19 = new System.Windows.Forms.Label();
			this.label20 = new System.Windows.Forms.Label();
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(0, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(100, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Raw Data";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 32);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(40, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Scale";
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(72, 32);
			this.textBox1.Name = "textBox1";
			this.textBox1.TabIndex = 2;
			this.textBox1.Text = "0";
			this.textBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// textBox2
			// 
			this.textBox2.Location = new System.Drawing.Point(72, 200);
			this.textBox2.Name = "textBox2";
			this.textBox2.TabIndex = 15;
			this.textBox2.Text = "0";
			this.textBox2.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 200);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(56, 16);
			this.label3.TabIndex = 13;
			this.label3.Text = "Low Sp";
			// 
			// label4
			// 
			this.label4.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label4.Location = new System.Drawing.Point(0, 104);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(100, 16);
			this.label4.TabIndex = 6;
			this.label4.Text = "Parameters";
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(384, 8);
			this.button1.Name = "button1";
			this.button1.TabIndex = 29;
			this.button1.Text = "Update";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// textBox3
			// 
			this.textBox3.Location = new System.Drawing.Point(72, 80);
			this.textBox3.Name = "textBox3";
			this.textBox3.TabIndex = 5;
			this.textBox3.Text = "0";
			this.textBox3.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 80);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(40, 16);
			this.label5.TabIndex = 4;
			this.label5.Text = "Scale";
			// 
			// label6
			// 
			this.label6.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label6.Location = new System.Drawing.Point(0, 56);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(100, 16);
			this.label6.TabIndex = 3;
			this.label6.Text = "Lump / Baseline";
			// 
			// textBox4
			// 
			this.textBox4.Location = new System.Drawing.Point(72, 128);
			this.textBox4.Name = "textBox4";
			this.textBox4.TabIndex = 8;
			this.textBox4.Text = "0";
			this.textBox4.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(8, 128);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(48, 16);
			this.label7.TabIndex = 7;
			this.label7.Text = "Width";
			// 
			// label8
			// 
			this.label8.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label8.Location = new System.Drawing.Point(208, 104);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(72, 16);
			this.label8.TabIndex = 30;
			this.label8.Text = "Skew";
			this.label8.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// label17
			// 
			this.label17.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label17.Location = new System.Drawing.Point(296, 104);
			this.label17.Name = "label17";
			this.label17.Size = new System.Drawing.Size(72, 16);
			this.label17.TabIndex = 31;
			this.label17.Text = "Clip";
			this.label17.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// textBox5
			// 
			this.textBox5.Location = new System.Drawing.Point(72, 176);
			this.textBox5.Name = "textBox5";
			this.textBox5.TabIndex = 12;
			this.textBox5.Text = "0";
			this.textBox5.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 176);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(48, 16);
			this.label9.TabIndex = 11;
			this.label9.Text = "Gather";
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(8, 152);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(56, 16);
			this.label10.TabIndex = 9;
			this.label10.Text = "Crowd";
			// 
			// textBox6
			// 
			this.textBox6.Location = new System.Drawing.Point(72, 152);
			this.textBox6.Name = "textBox6";
			this.textBox6.TabIndex = 10;
			this.textBox6.Text = "0";
			this.textBox6.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label12
			// 
			this.label12.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label12.Location = new System.Drawing.Point(384, 104);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(72, 16);
			this.label12.TabIndex = 32;
			this.label12.Text = "BaseLimit";
			this.label12.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(8, 224);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(56, 16);
			this.label11.TabIndex = 16;
			this.label11.Text = "High Sp";
			// 
			// textBox7
			// 
			this.textBox7.Location = new System.Drawing.Point(72, 224);
			this.textBox7.Name = "textBox7";
			this.textBox7.TabIndex = 17;
			this.textBox7.Text = "0";
			this.textBox7.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// button2
			// 
			this.button2.Location = new System.Drawing.Point(200, 8);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(64, 23);
			this.button2.TabIndex = 26;
			this.button2.Text = "Start New";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button3
			// 
			this.button3.Location = new System.Drawing.Point(264, 8);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(56, 23);
			this.button3.TabIndex = 27;
			this.button3.Text = "Set End";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button4
			// 
			this.button4.Location = new System.Drawing.Point(320, 8);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(48, 23);
			this.button4.TabIndex = 28;
			this.button4.Text = "Delete";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// label13
			// 
			this.label13.Location = new System.Drawing.Point(8, 248);
			this.label13.Name = "label13";
			this.label13.Size = new System.Drawing.Size(64, 16);
			this.label13.TabIndex = 18;
			this.label13.Text = "MaxSpace";
			// 
			// label14
			// 
			this.label14.Location = new System.Drawing.Point(8, 272);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(56, 16);
			this.label14.TabIndex = 20;
			this.label14.Text = "MinGap";
			// 
			// label15
			// 
			this.label15.Location = new System.Drawing.Point(8, 296);
			this.label15.Name = "label15";
			this.label15.Size = new System.Drawing.Size(56, 16);
			this.label15.TabIndex = 22;
			this.label15.Text = "MaxJunk";
			// 
			// textBox8
			// 
			this.textBox8.Location = new System.Drawing.Point(72, 248);
			this.textBox8.Name = "textBox8";
			this.textBox8.TabIndex = 19;
			this.textBox8.Text = "0";
			this.textBox8.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// textBox9
			// 
			this.textBox9.Location = new System.Drawing.Point(72, 272);
			this.textBox9.Name = "textBox9";
			this.textBox9.TabIndex = 21;
			this.textBox9.Text = "0";
			this.textBox9.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// textBox10
			// 
			this.textBox10.Location = new System.Drawing.Point(72, 296);
			this.textBox10.Name = "textBox10";
			this.textBox10.TabIndex = 23;
			this.textBox10.Text = "0";
			this.textBox10.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label16
			// 
			this.label16.Location = new System.Drawing.Point(200, 40);
			this.label16.Name = "label16";
			this.label16.Size = new System.Drawing.Size(56, 16);
			this.label16.TabIndex = 33;
			// 
			// label18
			// 
			this.label18.Location = new System.Drawing.Point(264, 40);
			this.label18.Name = "label18";
			this.label18.Size = new System.Drawing.Size(56, 16);
			this.label18.TabIndex = 34;
			// 
			// label19
			// 
			this.label19.Location = new System.Drawing.Point(264, 64);
			this.label19.Name = "label19";
			this.label19.Size = new System.Drawing.Size(56, 16);
			this.label19.TabIndex = 36;
			// 
			// label20
			// 
			this.label20.Location = new System.Drawing.Point(200, 64);
			this.label20.Name = "label20";
			this.label20.Size = new System.Drawing.Size(56, 16);
			this.label20.TabIndex = 35;
			// 
			// checkBox1
			// 
			this.checkBox1.Location = new System.Drawing.Point(336, 80);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.TabIndex = 37;
			this.checkBox1.Text = "Compensate";
			// 
			// ConfigDialog
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(464, 326);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.checkBox1,
																		  this.label19,
																		  this.label20,
																		  this.label18,
																		  this.label16,
																		  this.textBox10,
																		  this.textBox9,
																		  this.textBox8,
																		  this.label15,
																		  this.label14,
																		  this.label13,
																		  this.button4,
																		  this.button3,
																		  this.button2,
																		  this.textBox7,
																		  this.label11,
																		  this.label12,
																		  this.textBox6,
																		  this.label10,
																		  this.textBox5,
																		  this.label9,
																		  this.label17,
																		  this.label8,
																		  this.textBox4,
																		  this.label7,
																		  this.textBox3,
																		  this.label5,
																		  this.label6,
																		  this.button1,
																		  this.textBox2,
																		  this.label3,
																		  this.label4,
																		  this.textBox1,
																		  this.label2,
																		  this.label1});
			this.Name = "ConfigDialog";
			this.Text = "ConfigDialog";
			this.ResumeLayout(false);

		}
		#endregion

		private void button1_Click(object sender, System.EventArgs e)
		{
			UpdateValues();
			Close();
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			TapeParametersList tpl = parent.GetMultiSource().GetDataFile().TapeParameters;
			long pos = parent.GetPosition();
			tp = tpl.Add(pos, tpl.GetTapeParameters(pos).End);
			UpdateValues();
			Close();
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			try 
			{
				tp.End = parent.GetPosition();
				UpdateValues();
				Close();
			} 
			catch (Exception)
			{
			}
		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			TapeParametersList tpl = parent.GetMultiSource().GetDataFile().TapeParameters;
			tpl.Remove(tp);
			Close();
		}
	}
}
