/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using a7tlib;

namespace a7tdecode
{
	public class Decode
	{
		public Decode()
		{
		}

		/// <summary>
		/// For console decoding.
		/// </summary>
		[STAThread]
		static void Main(string[] args) 
		{
			for (int i = 0; i < args.Length; i++) 
			{
				try
				{
					TapeDecoder td = new TapeDecoder(args[i]);
					string front = args[i] + ": ";
					Console.Out.WriteLine(front + "Start");

					Source src = td.GetSource();
					int nchannel = src.GetNumChannels();
					TapeParameters tp = td.GetTapeParameters();
					int all = 0;
					for (; all < nchannel; all++) 
					{
						if (tp.Skew[all] != 0) 
						{
							break;
						}
					}
					if (all == nchannel) 
					{
						td.Calibrate(null);
					}

					string s = front + "      ";
					for (int ch = 0; ch < nchannel; ch++) 
					{
						s += "  " + src.GetChannelName(ch);
					}
					Console.Out.WriteLine(s + "  Width " + tp.Width + "  Gather " + tp.Gather);

					s = front + " Skew ";
					for (int ch = 0; ch < nchannel; ch++) 
					{
						s += "  " + tp.Skew[ch];
					}
					Console.Out.WriteLine(s + "  Crowd " + tp.Crowd);

					s = front + " Clip ";
					for (int ch = 0; ch < nchannel; ch++) 
					{
						s += "  " + tp.GetClip(true, ch);
					}
					Console.Out.WriteLine(s);

					int wasrec = td.GetNumRecords();
					td.Write(null, Console.Out);
					if (wasrec == 0) 
					{
						s = td.GetGapJunk().ToString() + " Gap Junk";
					} 
					else 
					{
						s = "";
					}
					Console.Out.WriteLine(front + td.GetNumRecords() + " Records, " + s + td.GetFixupTotal() + " Fixups " + td.GetErrorTotal() + " Errors");

					int[] spacing = td.GetSpacingHist();
					for (int sp = 0; sp < spacing.Length; sp++) 
					{
						if (spacing[sp] != 0) 
						{
							Console.Out.WriteLine(front + " Spacing " + sp + ": " + spacing[sp] + " Records");
						}
					}
				}
				catch (Exception e)
				{
					Console.Error.WriteLine(e.Message);
					Console.Error.WriteLine(e.StackTrace);
				}
			}
		}
	}
}
