/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Drawing.Imaging;
using System.Threading;

using a7tlib;

namespace a7tview
{
	/// <summary>
	/// Summary description.
	/// </summary>
	public class MainView : System.Windows.Forms.Form
	{
		private MultiSource multiSource = null;
//		private Source source = null;
		private int zoom = 1;

		private ProgressView progress = null;
		private SourceControl[] sourceControl;
		private int screenWidth;
		private int screenHeight;
		private bool ignoreRecnum = false;

		private Colors colors = new Colors();

		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private ViewScreen panel1;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.CheckBox checkBox1;
		private System.Windows.Forms.CheckBox checkBox2;
		private System.Windows.Forms.Button button6;
		private System.Windows.Forms.CheckBox checkBox3;
		private System.Windows.Forms.NumericUpDown numericUpDown1;
		private System.Windows.Forms.CheckBox checkBox4;
		private System.Windows.Forms.CheckBox checkBox5;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.CheckBox checkBox6;
		private System.Windows.Forms.Button button7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Button button8;
		private System.Windows.Forms.Button button10;
		private System.Windows.Forms.Button button11;
		private System.Windows.Forms.Button button13;
		private System.Windows.Forms.Button button14;
		private System.Windows.Forms.NumericUpDown numericUpDown2;
		private System.Windows.Forms.Button button9;
		private System.Windows.Forms.CheckBox checkBox8;
		private System.Windows.Forms.Button button5;
		private System.Windows.Forms.CheckBox checkBox7;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Button button12;
		private System.Windows.Forms.Button button15;
		private System.Windows.Forms.Button button16;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainView()
		{
			Initialize();
		}

		public MainView(string filename)
		{
			Initialize();
			OpenData(filename);
		}

		private void Initialize()
		{
			sourceControl = new SourceControl[5];

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			sourceControl[0] = new SourceControl(checkBox1, colors.rawColor, 2048);
			sourceControl[1] = new SourceControl(checkBox2, colors.lumpColor, 9000);
			sourceControl[2] = new SourceControl(checkBox8, colors.baseColor, 9000);
			sourceControl[3] = new SourceControl(checkBox3, colors.directionColor, 9000);
			sourceControl[4] = new SourceControl(checkBox7, colors.crowdColor, 9000);

			// 
			// panel1
			// 
			this.panel1 = new ViewScreen(this, sourceControl, colors);
			this.panel1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.panel1.Location = new System.Drawing.Point(24, 24);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(768, 400);
			this.panel1.TabIndex = 8;
			this.panel1.Resize += new System.EventHandler(this.panel1_Resize);
			this.panel1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.panel1_MouseDown);
			Controls.Add(panel1);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.button2 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.button4 = new System.Windows.Forms.Button();
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.checkBox2 = new System.Windows.Forms.CheckBox();
			this.button6 = new System.Windows.Forms.Button();
			this.checkBox3 = new System.Windows.Forms.CheckBox();
			this.numericUpDown1 = new System.Windows.Forms.NumericUpDown();
			this.checkBox4 = new System.Windows.Forms.CheckBox();
			this.checkBox5 = new System.Windows.Forms.CheckBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.checkBox6 = new System.Windows.Forms.CheckBox();
			this.button7 = new System.Windows.Forms.Button();
			this.label8 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.button8 = new System.Windows.Forms.Button();
			this.button10 = new System.Windows.Forms.Button();
			this.button11 = new System.Windows.Forms.Button();
			this.button13 = new System.Windows.Forms.Button();
			this.button14 = new System.Windows.Forms.Button();
			this.numericUpDown2 = new System.Windows.Forms.NumericUpDown();
			this.button9 = new System.Windows.Forms.Button();
			this.checkBox8 = new System.Windows.Forms.CheckBox();
			this.button5 = new System.Windows.Forms.Button();
			this.checkBox7 = new System.Windows.Forms.CheckBox();
			this.label10 = new System.Windows.Forms.Label();
			this.button12 = new System.Windows.Forms.Button();
			this.button15 = new System.Windows.Forms.Button();
			this.button16 = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown2)).BeginInit();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(-8, 0);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(40, 24);
			this.button1.TabIndex = 0;
			this.button1.Text = "File";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "xml|*.xml|dat|*.dat";
			// 
			// button2
			// 
			this.button2.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.button2.Location = new System.Drawing.Point(712, 0);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(24, 23);
			this.button2.TabIndex = 4;
			this.button2.Text = "+";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button3
			// 
			this.button3.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.button3.Location = new System.Drawing.Point(736, 0);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(24, 23);
			this.button3.TabIndex = 5;
			this.button3.Text = "-";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button4
			// 
			this.button4.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.button4.Location = new System.Drawing.Point(600, 0);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(40, 23);
			this.button4.TabIndex = 9;
			this.button4.Text = "Conf";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// checkBox1
			// 
			this.checkBox1.Checked = true;
			this.checkBox1.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox1.Location = new System.Drawing.Point(40, 0);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.Size = new System.Drawing.Size(56, 24);
			this.checkBox1.TabIndex = 10;
			this.checkBox1.Text = "Raw";
			this.checkBox1.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// checkBox2
			// 
			this.checkBox2.Checked = true;
			this.checkBox2.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox2.Location = new System.Drawing.Point(88, 0);
			this.checkBox2.Name = "checkBox2";
			this.checkBox2.Size = new System.Drawing.Size(56, 24);
			this.checkBox2.TabIndex = 11;
			this.checkBox2.Text = "Lump";
			this.checkBox2.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// button6
			// 
			this.button6.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.button6.Location = new System.Drawing.Point(680, 0);
			this.button6.Name = "button6";
			this.button6.Size = new System.Drawing.Size(32, 23);
			this.button6.TabIndex = 0;
			this.button6.Text = "1";
			this.button6.Click += new System.EventHandler(this.button6_Click);
			// 
			// checkBox3
			// 
			this.checkBox3.Checked = true;
			this.checkBox3.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox3.Location = new System.Drawing.Point(184, 0);
			this.checkBox3.Name = "checkBox3";
			this.checkBox3.Size = new System.Drawing.Size(40, 24);
			this.checkBox3.TabIndex = 13;
			this.checkBox3.Text = "Dir";
			this.checkBox3.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// numericUpDown1
			// 
			this.numericUpDown1.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.numericUpDown1.Location = new System.Drawing.Point(208, 424);
			this.numericUpDown1.Name = "numericUpDown1";
			this.numericUpDown1.Size = new System.Drawing.Size(88, 20);
			this.numericUpDown1.TabIndex = 15;
			this.numericUpDown1.ValueChanged += new System.EventHandler(this.numericUpDown1_ValueChanged);
			// 
			// checkBox4
			// 
			this.checkBox4.Checked = true;
			this.checkBox4.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox4.Location = new System.Drawing.Point(264, 0);
			this.checkBox4.Name = "checkBox4";
			this.checkBox4.Size = new System.Drawing.Size(64, 24);
			this.checkBox4.TabIndex = 16;
			this.checkBox4.Text = "Center";
			this.checkBox4.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// checkBox5
			// 
			this.checkBox5.Checked = true;
			this.checkBox5.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox5.Location = new System.Drawing.Point(320, 0);
			this.checkBox5.Name = "checkBox5";
			this.checkBox5.Size = new System.Drawing.Size(48, 24);
			this.checkBox5.TabIndex = 17;
			this.checkBox5.Text = "Zero";
			this.checkBox5.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(16, 16);
			this.label1.TabIndex = 18;
			this.label1.Text = "P";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 104);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(16, 16);
			this.label2.TabIndex = 19;
			this.label2.Text = "5";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 152);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(16, 16);
			this.label3.TabIndex = 20;
			this.label3.Text = "4";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 200);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(16, 16);
			this.label4.TabIndex = 21;
			this.label4.Text = "3";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 256);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(16, 16);
			this.label5.TabIndex = 22;
			this.label5.Text = "2";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(8, 304);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(16, 16);
			this.label6.TabIndex = 23;
			this.label6.Text = "1";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(8, 352);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(16, 16);
			this.label7.TabIndex = 24;
			this.label7.Text = "0";
			// 
			// checkBox6
			// 
			this.checkBox6.Checked = true;
			this.checkBox6.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox6.Location = new System.Drawing.Point(368, 0);
			this.checkBox6.Name = "checkBox6";
			this.checkBox6.Size = new System.Drawing.Size(48, 24);
			this.checkBox6.TabIndex = 25;
			this.checkBox6.Text = "Clip";
			this.checkBox6.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// button7
			// 
			this.button7.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.button7.Location = new System.Drawing.Point(640, 0);
			this.button7.Name = "button7";
			this.button7.Size = new System.Drawing.Size(40, 23);
			this.button7.TabIndex = 26;
			this.button7.Text = "Color";
			this.button7.Click += new System.EventHandler(this.button7_Click);
			// 
			// label8
			// 
			this.label8.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.label8.Location = new System.Drawing.Point(768, 0);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(32, 24);
			this.label8.TabIndex = 27;
			this.label8.Text = "zoom";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label9
			// 
			this.label9.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.label9.Location = new System.Drawing.Point(512, 424);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(280, 16);
			this.label9.TabIndex = 29;
			this.label9.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// button8
			// 
			this.button8.Location = new System.Drawing.Point(480, 0);
			this.button8.Name = "button8";
			this.button8.Size = new System.Drawing.Size(40, 23);
			this.button8.TabIndex = 30;
			this.button8.Text = "Evaluate";
			this.button8.Click += new System.EventHandler(this.button8_Click);
			// 
			// button10
			// 
			this.button10.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.button10.Enabled = false;
			this.button10.Location = new System.Drawing.Point(384, 424);
			this.button10.Name = "button10";
			this.button10.Size = new System.Drawing.Size(56, 23);
			this.button10.TabIndex = 32;
			this.button10.Text = "Next Err";
			this.button10.Click += new System.EventHandler(this.button10_Click);
			// 
			// button11
			// 
			this.button11.Location = new System.Drawing.Point(408, 0);
			this.button11.Name = "button11";
			this.button11.Size = new System.Drawing.Size(32, 23);
			this.button11.TabIndex = 33;
			this.button11.Text = "Cal";
			this.button11.Click += new System.EventHandler(this.button11_Click);
			// 
			// button13
			// 
			this.button13.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.button13.Enabled = false;
			this.button13.Location = new System.Drawing.Point(344, 424);
			this.button13.Name = "button13";
			this.button13.Size = new System.Drawing.Size(40, 23);
			this.button13.TabIndex = 35;
			this.button13.Text = "End";
			this.button13.Click += new System.EventHandler(this.button13_Click);
			// 
			// button14
			// 
			this.button14.Location = new System.Drawing.Point(520, 0);
			this.button14.Name = "button14";
			this.button14.Size = new System.Drawing.Size(40, 23);
			this.button14.TabIndex = 36;
			this.button14.Text = "Write";
			this.button14.Click += new System.EventHandler(this.button14_Click);
			// 
			// numericUpDown2
			// 
			this.numericUpDown2.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.numericUpDown2.Enabled = false;
			this.numericUpDown2.Location = new System.Drawing.Point(440, 424);
			this.numericUpDown2.Maximum = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.numericUpDown2.Minimum = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.numericUpDown2.Name = "numericUpDown2";
			this.numericUpDown2.Size = new System.Drawing.Size(64, 20);
			this.numericUpDown2.TabIndex = 37;
			this.numericUpDown2.Value = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			this.numericUpDown2.ValueChanged += new System.EventHandler(this.numericUpDown2_ValueChanged);
			// 
			// button9
			// 
			this.button9.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.button9.Enabled = false;
			this.button9.Location = new System.Drawing.Point(296, 424);
			this.button9.Name = "button9";
			this.button9.Size = new System.Drawing.Size(48, 23);
			this.button9.TabIndex = 31;
			this.button9.Text = "Begin";
			this.button9.Click += new System.EventHandler(this.button9_Click);
			// 
			// checkBox8
			// 
			this.checkBox8.Checked = true;
			this.checkBox8.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox8.Location = new System.Drawing.Point(136, 0);
			this.checkBox8.Name = "checkBox8";
			this.checkBox8.Size = new System.Drawing.Size(56, 24);
			this.checkBox8.TabIndex = 38;
			this.checkBox8.Text = "Base";
			this.checkBox8.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// button5
			// 
			this.button5.Location = new System.Drawing.Point(440, 0);
			this.button5.Name = "button5";
			this.button5.Size = new System.Drawing.Size(40, 23);
			this.button5.TabIndex = 39;
			this.button5.Text = "Mark";
			this.button5.Click += new System.EventHandler(this.button5_Click);
			// 
			// checkBox7
			// 
			this.checkBox7.Checked = true;
			this.checkBox7.CheckState = System.Windows.Forms.CheckState.Checked;
			this.checkBox7.Location = new System.Drawing.Point(224, 0);
			this.checkBox7.Name = "checkBox7";
			this.checkBox7.Size = new System.Drawing.Size(40, 24);
			this.checkBox7.TabIndex = 40;
			this.checkBox7.Text = "Cr";
			this.checkBox7.CheckedChanged += new System.EventHandler(this.somethingChanged);
			// 
			// label10
			// 
			this.label10.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.label10.Location = new System.Drawing.Point(8, 424);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(144, 16);
			this.label10.TabIndex = 41;
			// 
			// button12
			// 
			this.button12.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.button12.Location = new System.Drawing.Point(160, 424);
			this.button12.Name = "button12";
			this.button12.Size = new System.Drawing.Size(24, 23);
			this.button12.TabIndex = 42;
			this.button12.Text = "S";
			this.button12.Click += new System.EventHandler(this.button12_Click);
			// 
			// button15
			// 
			this.button15.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.button15.Location = new System.Drawing.Point(184, 424);
			this.button15.Name = "button15";
			this.button15.Size = new System.Drawing.Size(24, 23);
			this.button15.TabIndex = 43;
			this.button15.Text = "E";
			this.button15.Click += new System.EventHandler(this.button15_Click);
			// 
			// button16
			// 
			this.button16.Location = new System.Drawing.Point(560, 0);
			this.button16.Name = "button16";
			this.button16.Size = new System.Drawing.Size(32, 23);
			this.button16.TabIndex = 44;
			this.button16.Text = "WX";
			this.button16.Click += new System.EventHandler(this.button16_Click);
			// 
			// MainView
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(800, 446);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button16,
																		  this.button15,
																		  this.button12,
																		  this.label10,
																		  this.checkBox7,
																		  this.button5,
																		  this.checkBox3,
																		  this.checkBox8,
																		  this.numericUpDown2,
																		  this.button14,
																		  this.button13,
																		  this.button11,
																		  this.button10,
																		  this.button9,
																		  this.button8,
																		  this.label9,
																		  this.label8,
																		  this.button7,
																		  this.checkBox6,
																		  this.label7,
																		  this.label6,
																		  this.label5,
																		  this.label4,
																		  this.label3,
																		  this.label2,
																		  this.label1,
																		  this.checkBox5,
																		  this.checkBox4,
																		  this.numericUpDown1,
																		  this.checkBox2,
																		  this.checkBox1,
																		  this.button4,
																		  this.button1,
																		  this.button2,
																		  this.button3,
																		  this.button6});
			this.Name = "MainView";
			this.Text = "MainView";
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown2)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args) 
		{
			if (args.Length == 0)
			{
				Application.Run(new MainView());
			}
			else
			{
				Application.Run(new MainView(args[0]));
			}
		}

		public MultiSource GetMultiSource() { return multiSource; }

		public int getRawZoom() { return sourceControl[0].zoom; }
		public void setRawZoom(int i) { sourceControl[0].zoom = i; }
		public int getLumpZoom() { return sourceControl[1].zoom; }
		public void setLumpZoom(int i) { sourceControl[1].zoom = i; sourceControl[2].zoom = i; sourceControl[3].zoom = i; }

		public Source GetSource() { if (multiSource == null) { return null; } return multiSource.GetSource(); }

		public int GetZoom() { return zoom; }
		public long GetZoomWidth(int width) { return zoom*width/2; }
		public long GetZoomWidth() { return GetZoomWidth(screenWidth); }
		public bool CenterEnabled() { return checkBox4.Checked; }
		public bool ZeroEnabled() { return checkBox5.Checked; }
		public bool ClipEnabled() { return checkBox6.Checked; }

		protected void SetPosition(long pos)
		{
			if (pos > (long)numericUpDown1.Maximum) 
			{
				pos = (long)numericUpDown1.Maximum;
			}
			if (pos < (long)numericUpDown1.Minimum) 
			{
				pos = (long)numericUpDown1.Minimum;
			}
			if ((long)numericUpDown1.Value != pos) 
			{
				numericUpDown1.Value = pos;
			} 
			else 
			{
				Refresh();
			}
		}

		public long GetPosition()
		{
			return (long)numericUpDown1.Value;
		}

		public override void Refresh()
		{
			label8.Text = zoom.ToString();

			screenWidth = panel1.Width - 2*ViewScreen.SideBorder;
			screenHeight = panel1.Height;
			int nchannel = 0;
			int channelHeight = 0;

			if (multiSource != null) 
			{
				label10.Text = multiSource.GetStart().ToString() + " - " + multiSource.GetEnd().ToString();
				multiSource.SetPosition(GetPosition());
				nchannel = multiSource.GetSource().GetNumChannels();
				channelHeight = (screenHeight-20 - (ViewScreen.StatusHeight + ViewScreen.SliderHeight)) / nchannel;

				button10.Enabled = multiSource.GetErrorTotal() > 0;

				string st = "";
				if (multiSource.RecordOriented()) 
				{
					Record rec = multiSource.GetRecord(GetPosition());
					if (rec != null) 
					{
						numericUpDown2.Minimum = 1;
						numericUpDown2.Maximum = multiSource.GetNumRecords();
						if (numericUpDown2.Value != rec.GetNumber()) 
						{
							ignoreRecnum = true;
							numericUpDown2.Value = rec.GetNumber();
						}
						numericUpDown2.Enabled = true;
						button9.Enabled = true;
						button13.Enabled = true;
						long relpos = GetPosition() - rec.GetStart();
						st = "pos " + relpos +
							" cnt " + rec.GetCount() +
							" sp " + ((TapeDecoder)multiSource).GetSpacing() +
							", " + rec.GetErrors() + " err, " +
							multiSource.GetErrorTotal() + " Err " +
							multiSource.GetNumRecords() + " Rec";
					}
					else
					{
						int n = multiSource.GetNumRecords();
						if (n > 0) 
						{
							numericUpDown2.Minimum = 1;
							numericUpDown2.Maximum = multiSource.GetNumRecords();
							numericUpDown2.Enabled = true;
							button9.Enabled = true;
							button13.Enabled = true;
							st = multiSource.GetErrorTotal() + " Total errors  " + n + " Records";
						}
						else
						{
							numericUpDown2.Enabled = false;
							button9.Enabled = false;
							button13.Enabled = false;
						}
					}
				}
				else
				{
					numericUpDown2.Enabled = false;
					st = multiSource.GetErrorTotal() + " Total errors";
				}
				label9.Text = st;

				int labelOffset = 24-8 + 10 + channelHeight/2;
				label1.Location = new Point(8, labelOffset + channelHeight*(0));
				label2.Location = new Point(8, labelOffset + channelHeight*(1));
				label3.Location = new Point(8, labelOffset + channelHeight*(2));
				label4.Location = new Point(8, labelOffset + channelHeight*(3));
				label5.Location = new Point(8, labelOffset + channelHeight*(4));
				label6.Location = new Point(8, labelOffset + channelHeight*(5));
				label7.Location = new Point(8, labelOffset + channelHeight*(6));


				long spos = GetPosition() - GetZoomWidth()/2;
				long epos = spos + GetZoomWidth();

				int nlevel = 1;
				Source s = multiSource.GetSource().GetSource();
				for (; s != null; s = s.GetSource(), nlevel++);
				for (int j = 0; j < sourceControl.Length; j++) 
				{
					sourceControl[j].checkBox.Enabled = false;
				}
				s = multiSource.GetSource();
				for (int level = 0; level < nlevel; s = s.GetSource(), level++)
				{
					for (int j = 0; j < sourceControl.Length; j++) 
					{
						if (sourceControl[j].checkBox.Text.Equals(s.GetName())) 
						{
							sourceControl[j].checkBox.Enabled = true;
							break;
						}
					}
				}
			}

			base.Refresh();
		}

		private void OpenData(string filename)
		{
			CloseData();
			if (filename != null)
			{
				try
				{
					multiSource = new TapeDecoder(filename);
					Text = "MainView - " + filename;
					numericUpDown1.Minimum = 0;
					numericUpDown1.Maximum = multiSource.GetLength();
				} 
				catch (Exception ex)
				{
					label9.Text = ex.Message;
					multiSource = null;
					numericUpDown1.Minimum = 0;
					numericUpDown1.Maximum = 0;
					numericUpDown1.Value = 0;
				}
			}
			else
			{
				Text = "MainView";
			}
			zoom = 1;
			SetPosition(0);
		}

		private void CloseData()
		{
			if (multiSource != null) 
			{
				multiSource.Close();
				multiSource = null;
			}
		}

		private void RunCalibrate()
		{
			multiSource.Clone().Calibrate(progress, multiSource);
			this.InvokeGotFocus(this, new System.EventArgs());
		}

		private void RunMark()
		{
			multiSource.Clone().Mark(progress, multiSource);
			this.InvokeGotFocus(this, new System.EventArgs());
		}

		private void RunEvaluate()
		{
			multiSource.Clone().Evaluate(progress, multiSource);
			this.InvokeGotFocus(this, new System.EventArgs());
		}

		private void RunWrite()
		{
			multiSource.Clone().Write(progress, multiSource);
			this.InvokeGotFocus(this, new System.EventArgs());
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			CloseData();
			openFileDialog1.ShowDialog();
			if (openFileDialog1.FileName.Length > 0)
			{
				OpenData(openFileDialog1.FileName);
			}
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			if (zoom > 1) 
			{
				zoom /= 2;
			}
			Refresh();
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null)
			{
				if (2*GetZoomWidth() <= multiSource.GetLength()) 
				{
					zoom *= 2;
				}
			}
			Refresh();
		}

		private void panel1_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (((MouseEventArgs)e).Y < screenHeight - (ViewScreen.StatusHeight + ViewScreen.SliderHeight))
			{
				SetPosition(GetPosition() + GetZoomWidth((((MouseEventArgs)e).X - ViewScreen.SideBorder - screenWidth/2)));
			}
			else
			{
				if (((MouseEventArgs)e).Y < screenHeight - ViewScreen.SliderHeight)
				{
					SetPosition(GetPosition() + GetZoomWidth((((MouseEventArgs)e).X - ViewScreen.SideBorder - screenWidth/2)));
				}
				else
				{
					SetPosition(multiSource.GetLength()*(((MouseEventArgs)e).X - ViewScreen.SideBorder)/screenWidth);
				}
			}
		}

		private void panel1_Resize(object sender, System.EventArgs e)
		{
			Refresh();
		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null)
			{
				ConfigDialog c = new ConfigDialog(this);
				c.ShowDialog();
				c.Dispose();
				Refresh();
			}
		}

		private void button6_Click(object sender, System.EventArgs e)
		{
			zoom = 1;
			Refresh();
		}

		private void somethingChanged(object sender, System.EventArgs e)
		{
			Refresh();		
		}

		private void numericUpDown1_ValueChanged(object sender, System.EventArgs e)
		{
			SetPosition((long)numericUpDown1.Value);
		}

		private void button7_Click(object sender, System.EventArgs e)
		{		
			ColorDialog c = new ColorDialog(colors);
			c.ShowDialog();
			c.Dispose();
			sourceControl[0].color = colors.rawColor;
			sourceControl[1].color = colors.lumpColor;
			sourceControl[2].color = colors.baseColor;
			sourceControl[3].color = colors.directionColor;
			Refresh();
		}

		private void button8_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				if (progress != null) 
				{
					progress.CloseAll();
				}
				progress = new ProgressView("Evaluating...");
				progress.Show();
				new Thread(new ThreadStart(RunEvaluate)).Start();
			}
		}

		private void button9_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null && multiSource.RecordOriented()) 
			{
				long position = GetPosition();
				Record rec = multiSource.GetRecord(position);
				if (rec == null) 
				{
					rec = multiSource.GetPreviousRecord(position);
				}
				if (rec == null)
				{
					rec = multiSource.GetNextRecord(position);
				}
				if (rec != null)
				{
					long newpos = rec.GetStart();
					if (newpos != position) 
					{
						SetPosition(newpos);
					}
				}
			}
		}

		private void button10_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null && multiSource.RecordOriented()) 
			{
				multiSource.SetPosition(GetPosition());
				SetPosition(multiSource.GetNextError());
			}		
		}

		private void button11_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				if (progress != null) 
				{
					progress.CloseAll();
				}
				progress = new ProgressView("Calibrating...");
				progress.Show();
				new Thread(new ThreadStart(RunCalibrate)).Start();
			}
		}

		private void button13_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null && multiSource.RecordOriented()) 
			{
				long position = GetPosition();
				Record rec = multiSource.GetRecord(position);
				if (rec != null)
				{
					long newpos = rec.GetEnd();
					if (newpos != position) 
					{
						SetPosition(newpos);
					}
				}
			}
		}

		private void button14_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				if (progress != null) 
				{
					progress.CloseAll();
				}
				progress = new ProgressView("Writing...");
				progress.Show();
				new Thread(new ThreadStart(RunWrite)).Start();
			}
		}

		private void numericUpDown2_ValueChanged(object sender, System.EventArgs e)
		{
			if (ignoreRecnum) 
			{
				ignoreRecnum = false;
				return;
			}
			int i = (int)numericUpDown2.Value;
			if (multiSource != null)
			{
				Record rec = multiSource.GetRecord(i);
				if (rec != null) 
				{
					SetPosition(rec.GetStart());
				}
			}
		}

		private void button5_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				if (progress != null) 
				{
					progress.CloseAll();
				}
				progress = new ProgressView("Marking...");
				progress.Show();
				new Thread(new ThreadStart(RunMark)).Start();
			}
		}

		private void button12_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				multiSource.SetStart(GetPosition());
			}
			Refresh();
		}

		private void button15_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				multiSource.SetEnd(GetPosition());
			}
			Refresh();
		}

		private void button16_Click(object sender, System.EventArgs e)
		{
			if (multiSource != null) 
			{
				multiSource.WriteInfo();
			}
		}
	}
}
