/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;

namespace a7tlib
{
	/// <summary>
	/// Summary description for MultiSource.
	/// </summary>
	public interface MultiSource
	{
		DataFile GetDataFile();
		Source GetSource();
		void Calibrate(ProgressWatcher p);
		void Calibrate(ProgressWatcher p, MultiSource transfer);
		void Mark(ProgressWatcher p);
		void Mark(ProgressWatcher p, MultiSource transfer);
		void Evaluate(ProgressWatcher p);
		void Evaluate(ProgressWatcher p, MultiSource transfer);
		void Write(ProgressWatcher p);
		void Write(ProgressWatcher p, MultiSource transfer);
		void WriteInfo();
		MultiSource Clone();
		void Close();

		long GetStart();
		long GetEnd();
		void SetStart(long pos);
		void SetEnd(long pos);
		long GetLength();
		void SetPosition(long position);
		void SetPosition(long position, long length);
		long GetPosition();
		void Advance();
		void ReEvaluate();
		int GetErrorCount();
		int GetErrorTotal();
		long GetNextError();

		bool RecordOriented();
		int GetNumRecords();
		Record GetRecord(int index);
		Record GetNextRecord();
		Record GetNextRecord(long position);
		Record GetNextRecord(Record record);
		Record GetRecord();
		Record GetRecord(long position);
		Record GetPreviousRecord();
		Record GetPreviousRecord(long position);
		Record GetPreviousRecord(Record record);

		bool HasActivity();
		int GetActivityCountHere();
		int GetActivityLumpedHere();
		int GetActivityStatusHere();
		bool HasData();
		bool IsDataValidHere();
		int GetDataHere();
	}
}
