/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using a7tlib;

namespace a7tview
{
	/// <summary>
	/// Summary description for PlotView.
	/// </summary>
	public class PlotView : System.Windows.Forms.Form
	{
		private Plottable plot;
		private Color[] colors = new Color[3];
		private CheckBox[] legend = new CheckBox[6];

		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.CheckBox checkBox1;
		private System.Windows.Forms.CheckBox checkBox2;
		private System.Windows.Forms.CheckBox checkBox3;
		private System.Windows.Forms.CheckBox checkBox4;
		private System.Windows.Forms.CheckBox checkBox5;
		private System.Windows.Forms.CheckBox checkBox6;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public PlotView(Plottable p)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			colors[0] = Color.Black;
			colors[1] = Color.Blue;
			colors[2] = Color.Red;

			legend[0] = checkBox1;
			legend[1] = checkBox2;
			legend[2] = checkBox3;
			legend[3] = checkBox4;
			legend[4] = checkBox5;
			legend[5] = checkBox6;

			plot = p;
			Text = plot.GetName();
			label1.Text = plot.GetXLabel();
			label2.Text = plot.GetYLabel();
			if (plot.IsXMarker()) 
			{
				label3.Text = plot.GetXMarker().ToString();
			}

			int i = 0;
			for (; i < legend.Length && i < plot.GetNumDatasets(); i++) 
			{
				legend[i].Text = plot.GetDatasetName(i);
				legend[i].ForeColor = colors[i % colors.Length];
				legend[i].Checked = true;
				legend[i].Enabled = true;
				legend[i].Visible = true;
			}
			for (; i < legend.Length; i++) 
			{
				legend[i].Enabled = false;
				legend[i].Visible = false;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.panel1 = new System.Windows.Forms.Panel();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.checkBox2 = new System.Windows.Forms.CheckBox();
			this.checkBox3 = new System.Windows.Forms.CheckBox();
			this.checkBox4 = new System.Windows.Forms.CheckBox();
			this.checkBox5 = new System.Windows.Forms.CheckBox();
			this.checkBox6 = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(112, 272);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(184, 23);
			this.label1.TabIndex = 0;
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(8, 152);
			this.label2.TabIndex = 1;
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// panel1
			// 
			this.panel1.Location = new System.Drawing.Point(32, 40);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(344, 200);
			this.panel1.TabIndex = 2;
			this.panel1.Visible = false;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(264, 8);
			this.label3.Name = "label3";
			this.label3.TabIndex = 3;
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(312, 240);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(64, 16);
			this.label4.TabIndex = 4;
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(24, 240);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(64, 16);
			this.label5.TabIndex = 5;
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// checkBox1
			// 
			this.checkBox1.Location = new System.Drawing.Point(400, 48);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.Size = new System.Drawing.Size(136, 24);
			this.checkBox1.TabIndex = 6;
			this.checkBox1.Text = "checkBox1";
			this.checkBox1.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// checkBox2
			// 
			this.checkBox2.Location = new System.Drawing.Point(400, 80);
			this.checkBox2.Name = "checkBox2";
			this.checkBox2.Size = new System.Drawing.Size(136, 24);
			this.checkBox2.TabIndex = 7;
			this.checkBox2.Text = "checkBox2";
			this.checkBox2.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// checkBox3
			// 
			this.checkBox3.Location = new System.Drawing.Point(400, 112);
			this.checkBox3.Name = "checkBox3";
			this.checkBox3.Size = new System.Drawing.Size(136, 24);
			this.checkBox3.TabIndex = 8;
			this.checkBox3.Text = "checkBox3";
			this.checkBox3.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// checkBox4
			// 
			this.checkBox4.Location = new System.Drawing.Point(400, 144);
			this.checkBox4.Name = "checkBox4";
			this.checkBox4.Size = new System.Drawing.Size(136, 24);
			this.checkBox4.TabIndex = 9;
			this.checkBox4.Text = "checkBox4";
			this.checkBox4.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// checkBox5
			// 
			this.checkBox5.Location = new System.Drawing.Point(400, 176);
			this.checkBox5.Name = "checkBox5";
			this.checkBox5.Size = new System.Drawing.Size(136, 24);
			this.checkBox5.TabIndex = 10;
			this.checkBox5.Text = "checkBox5";
			this.checkBox5.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// checkBox6
			// 
			this.checkBox6.Location = new System.Drawing.Point(400, 208);
			this.checkBox6.Name = "checkBox6";
			this.checkBox6.Size = new System.Drawing.Size(136, 24);
			this.checkBox6.TabIndex = 11;
			this.checkBox6.Text = "checkBox6";
			this.checkBox6.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// PlotView
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 310);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.checkBox6,
																		  this.checkBox5,
																		  this.checkBox4,
																		  this.checkBox3,
																		  this.checkBox2,
																		  this.checkBox1,
																		  this.label5,
																		  this.label4,
																		  this.label3,
																		  this.panel1,
																		  this.label2,
																		  this.label1});
			this.Name = "PlotView";
			this.Text = "PlotView";
			this.ResumeLayout(false);

		}
		#endregion

		protected override void OnPaint(PaintEventArgs e)
		{
			int n = plot.GetNumDatasets();
			if (n > legend.Length) 
			{
				n = legend.Length;
			}
			int[][] ydata = new int[n][];
			Point[][] points = new Point[n][];
			int[] xdata = plot.GetDataset(0);
			for (int i = 0; i < n; i++) 
			{
				if (legend[i].Checked) 
				{
					ydata[i] = plot.GetDataset(i+1);
					points[i] = new Point[xdata.Length];
				}
			}

			double minX = 1000000000;
			double maxX = -1000000000;
			double minY = 1000000000;
			double maxY = -1000000000;
			for (int i = 0; i < n; i++) 
			{
				if (legend[i].Checked) 
				{
					for (int j = 0; j < xdata.Length; j++)
					{
						double x = xdata[j];
						double y = ydata[i][j];
						if (x > maxX) 
						{
							maxX = x;
						}
						if (x < minX) 
						{
							minX = x;
						}
						if (y > maxY) 
						{
							maxY = y;
						}
						if (y < minY) 
						{
							minY = y;
						}
					}
				}
			}
			label4.Text = maxX.ToString();
			label5.Text = minX.ToString();

			base.OnPaint(e);
			Graphics g = e.Graphics;
			g.FillRectangle(Brushes.White, panel1.Left, panel1.Top, panel1.Width, panel1.Height);

			double XScale = 1.0;
			if (plot.IsXLog()) 
			{
				double v = maxX - minX;
				if (v > 0) 
				{
					v = System.Math.Log(v);
					XScale = (double)panel1.Width / v;
				}
			} 
			else if (maxX > minX)
			{
				XScale = (double)panel1.Width / (maxX - minX);
			}

			double YScale = 1.0;
			if (plot.IsYLog()) 
			{
				double v = maxY - minY;
				if (v > 0) 
				{
					v = System.Math.Log(v);
					YScale = (double)panel1.Height / v;
				}
			} 
			else if (maxY > minY)
			{
				YScale = (double)panel1.Height / (maxY - minY);
			}

			if (plot.IsXMarker()) 
			{
				double x = (double)plot.GetXMarker() - minX;
				if (x > 0.0 && plot.IsXLog()) 
				{
					x = System.Math.Log(x);
				}
				x = XScale*x;
				g.DrawLine(new Pen(Color.Yellow),
					new Point(panel1.Left + (int)x, panel1.Top),
					new Point(panel1.Left + (int)x, panel1.Top + panel1.Height - 1));
			}

			for (int i = 0; i < n; i++) 
			{
				if (legend[i].Checked) 
				{
					for (int j = 0; j < xdata.Length; j++)
					{
						double x = (double)xdata[j] - minX;
						if (x > 0 && plot.IsXLog()) 
						{
							x = System.Math.Log(x);
						}
						double y = (double)ydata[i][j] - minY;
						if (y > 0 && plot.IsYLog()) 
						{
							y = System.Math.Log(y);
						}
						x = XScale*x;
						y = YScale*y;
						points[i][j] = new Point(panel1.Left + (int)x, panel1.Top + panel1.Height - (int)y);
					}
					g.DrawLines(new Pen(colors[i % colors.Length]), points[i]);
				}
			}

			g.Flush();
		}

		private void checkBox_CheckedChanged(object sender, System.EventArgs e)
		{
			Refresh();
		}
	}
}
