/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using a7tlib;

namespace a7tview
{
	/// <summary>
	/// Summary description for ProgressView.
	/// </summary>
	public class ProgressView : System.Windows.Forms.Form, ProgressWatcher
	{
		private bool proceed = true;
		private bool finished = false;
		private Plottable myplot = null;
		private PlotView myplotview = null;

		private System.Windows.Forms.ProgressBar progressBar1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button button1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ProgressView(string title)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			Text = title;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.progressBar1 = new System.Windows.Forms.ProgressBar();
			this.label1 = new System.Windows.Forms.Label();
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// progressBar1
			// 
			this.progressBar1.Location = new System.Drawing.Point(8, 32);
			this.progressBar1.Name = "progressBar1";
			this.progressBar1.Size = new System.Drawing.Size(272, 16);
			this.progressBar1.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(216, 16);
			this.label1.TabIndex = 1;
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(232, 8);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(48, 23);
			this.button1.TabIndex = 2;
			this.button1.Text = "Stop";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// ProgressView
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 62);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button1,
																		  this.label1,
																		  this.progressBar1});
			this.Name = "ProgressView";
			this.Text = "Evaluating...";
			this.ResumeLayout(false);

		}
		#endregion

		public void ReportProgress(string stage, int current, int final)
		{
			if (!proceed) 
			{
				throw new StopException();
			}
			label1.Text = stage;
			progressBar1.Minimum = 0;
			progressBar1.Maximum = final;
			progressBar1.Value = current;
			InvokeGotFocus(this, new EventArgs());
		}

		public void ReportProgress(int more)
		{
			if (!proceed) 
			{
				throw new StopException();
			}
			progressBar1.Value += more;
			InvokeGotFocus(this, new EventArgs());
		}

		public void Finished()
		{
			proceed = true;
			ReportProgress("Done", 100, 100);
			if (myplot != null) 
			{
				button1.Text = "Plot";
			} 
			else 
			{
				button1.Text = "Close";
			}
			finished = true;
			Refresh();
		}

		public void SetPlot(Plottable plot)
		{
			myplot = plot;
		}

		public PlotView GetPlotView()
		{
			if (myplot != null)
			{
				return new PlotView(myplot);
			}
			return null;
		}

		public void CloseAll()
		{
			if (myplotview != null) 
			{
				myplotview.Close();
			}
			Close();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			if (!finished)
			{
				proceed = false;
			}
			else if (myplot != null && myplotview == null) 
			{
				myplotview = new PlotView(myplot);
				myplotview.Show();
				button1.Text = "Close";
				Refresh();
			}
			else
			{
				CloseAll();
			}
		}
	}
}
