/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


using System;

namespace a7tlib
{
	/// <summary>
	/// Summary description for Record.
	/// </summary>
	public class Record
	{
		private int number;
		private long start;
		private long end;
		private int count = 0;
		private int errors = 0;
		private int fixups = 0;
		private bool motionForward = true;

		public Record(int number, long start, long end, bool motionForward)
		{
			this.number = number;
			this.start = start;
			this.end = end;
			this.motionForward = motionForward;
			end = start;
		}

		public int GetNumber() { return number; }
		public long GetStart() { return start; }
		public long GetEnd() { return end; }
		public int GetCount() { return count; }
		public void SetCount(int v) { count = v; }
		public int GetErrors() { return errors; }
		public void SetErrors(int errors) { this.errors = errors; }
		public int GetFixups() { return fixups; }
		public void SetFixups(int fixups) { this.fixups = fixups; }
		public bool GetMotionForward() { return motionForward; }
		public void SetMotionForward(bool mf) { motionForward = mf; }

		internal void Write(System.IO.TextWriter ow, int indent)
		{
			string errs = "";
			if (errors > 0) 
			{
				errs = " errors=\"" + errors + "\"";
			}
			if (fixups > 0) 
			{
				errs += " fixups=\"" + fixups + "\"";
			}
			string inds = new String(' ', indent);
			ow.WriteLine(inds + "<record start=\"" + start + "\" end=\"" + end + "\"" + errs + " />");
		}
	}
}
