/**********************************
 *
 * Copyright (C) 2004 Paul Pierce
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 *********************************/


/*
 * Compare 7-track tape images
 */

#include <stdlib.h>
#include <stdio.h>


void main(argc, argv)
	int argc;
	char **argv;
{
	FILE *f1;
	FILE *f2;
	char *fn1;
	char *fn2;
	int filenum;
	int recnum;
	int reclen1;
	int reclen2;
	int could_be_eof1;
	int could_be_eof2;
	int ndiff;
	int c1;
	int c2;

	if (argc != 3) {
		fprintf(stderr, "Usage: t7cmp <file1> <file2>\n");
		exit(1);
	}
	fn1 = argv[1];
	fn2 = argv[2];

	f1 = fopen(fn1, "rb");
	if (f1 == NULL) {
		perror(fn1);
		exit(1);
	}

	f2 = fopen(fn2, "rb");
	if (f2 == NULL) {
		perror(fn2);
		exit(1);
	}

	c1 = fgetc(f1);
	if ((c1 & 0x80) == 0) {
		fprintf(stderr, "%s not a 7-track tape image\n", fn1);
		exit(1);
	}
	c2 = fgetc(f2);
	if ((c2 & 0x80) == 0) {
		fprintf(stderr, "%s not a 7-track tape image\n", fn2);
		exit(1);
	}
	filenum = 1;
	recnum = 0;
	for (;;) {
		recnum++;
		reclen1 = 0;
		could_be_eof1 = c1 == 0x8F;
		reclen2 = 0;
		could_be_eof2 = c2 == 0x8F;
		ndiff = 0;

		c1 &= 0x7F;
		c2 &= 0x7F;
		for (;;) {

			if (c1 != c2) {
				ndiff++;
			}
			if (c1 != EOF && (c1 & 0x80) == 0) {
				reclen1++;
				c1 = fgetc(f1);
			}
			if (c2 != EOF && (c2 & 0x80) == 0) {
				reclen2++;
				c2 = fgetc(f2);
			}
			if ((c1 == EOF || (c1 & 0x80) != 0) &&
				(c2 == EOF || (c2 & 0x80) != 0)) {
				break;
			}
		}

		if (ndiff > 0 || reclen1 != reclen2) {
			printf("%5d.%6d %d different", filenum, recnum, ndiff);
			if (reclen1 != reclen2) {
				printf(", lengths %d / %d", reclen1, reclen2);
			}
			printf("\n");
		}

		if (could_be_eof1 && reclen1 == 1 ||
		    could_be_eof2 && reclen2 == 1) {
			filenum++;
			recnum = 0;
		}

		if (c1 == EOF && c2 == EOF) {
			break;
		}
	}
}
