/*
 * Reverse all bytes in a file
 * from front to back
 */

#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>

#define BUFSIZE 16384

unsigned char lobuf[BUFSIZE];
unsigned char hibuf[BUFSIZE];

void main(argc, argv)
	int	argc;
	char **argv;
{
	unsigned long fsize;
	unsigned long lo;
	unsigned long hi;
	int n;
	int m;
	int fi;
	int fo;
	unsigned char *p, *q;
	int i;
	unsigned char t;

	if (argc != 3) {
		fprintf(stderr, "Usage: byterev <infile> <outfile>\n");
		exit(1);
	}
	fi = open(argv[1], O_RDONLY | O_BINARY, 0);
	if (fi == -1) {
		perror(argv[1]);
		exit(1);
	}
	fo = open(argv[2], O_WRONLY | O_CREAT | O_BINARY, 0644);
	if (fo == -1) {
		perror(argv[2]);
		exit(1);
	}

	fsize = lseek(fi, 0, SEEK_END);

	for (lo = 0, hi = fsize;
		 hi - lo > 2*BUFSIZE;
		 lo += BUFSIZE, hi -= BUFSIZE) {
		lseek(fi, lo, SEEK_SET);
		m = read(fi, lobuf, BUFSIZE);
		if (m != BUFSIZE) {
			fprintf(stderr, "Short read %d should be %d\n", m, BUFSIZE);
			exit(1);
		}
		lseek(fi, hi - BUFSIZE, SEEK_SET);
		m = read(fi, hibuf, BUFSIZE);
		if (m != BUFSIZE) {
			fprintf(stderr, "Short read %d should be %d\n", m, BUFSIZE);
			exit(1);
		}
		for (i = BUFSIZE, p = lobuf, q = hibuf + BUFSIZE - 1;
			 i > 0;
			 i--, p++, q--) {
			t = *p;
			*p = *q;
			*q = t;
		}
		lseek(fo, lo, SEEK_SET);
		m = write(fo, lobuf, BUFSIZE);
		if (m != BUFSIZE) {
			fprintf(stderr, "Short write %d should be %d\n", m, BUFSIZE);
			exit(1);
		}
		lseek(fo, hi - BUFSIZE, SEEK_SET);
		m = write(fo, hibuf, BUFSIZE);
		if (m != BUFSIZE) {
			fprintf(stderr, "Short write %d should be %d\n", m, BUFSIZE);
			exit(1);
		}
	}

	if (hi > lo) {
		n = (hi - lo + 1)/2;

		lseek(fi, lo, SEEK_SET);
		m = read(fi, lobuf, n);
		if (m != n) {
			fprintf(stderr, "Short read %d should be %d\n", m, n);
			exit(1);
		}
		lseek(fi, hi - n, SEEK_SET);
		m = read(fi, hibuf, n);
		if (m != n) {
			fprintf(stderr, "Short read %d should be %d\n", m, n);
			exit(1);
		}
		for (i = n, p = lobuf, q = hibuf + n - 1;
			 i > 0;
			 i--, p++, q--) {
			t = *p;
			*p = *q;
			*q = t;
		}
		lseek(fo, lo, SEEK_SET);
		m = write(fo, lobuf, n);
		if (m != n) {
			fprintf(stderr, "Short write %d should be %d\n", m, n);
			exit(1);
		}
		lseek(fo, hi - n, SEEK_SET);
		m = write(fo, hibuf, n);
		if (m != n) {
			fprintf(stderr, "Short write %d should be %d\n", m, n);
			exit(1);
		}
	}

	close(fi);
	close(fo);
	exit(0);
}
