/*
 * Edit 7-track tape image from one file to another
 */

#include <stdlib.h>
#include <stdio.h>

#define EXT_CHAR	1
#define EXT_REC		2
#define EXT_FILE	3
#define EXT_ALL		4
#define EXT_MARK	5

void main(argc, argv)
	int argc;
	char **argv;
{
	FILE *fi;
	FILE *fo;
	int copy;
	int extent;
	int count;
	int lineno;
	int could_be_eof;
	int bof;
	int c;
	int next_c;
	int next_c_valid;
	int first;

	if (argc != 3) {
		fprintf(stderr, "Usage: g7tedit <infile> <outfile>\n");
		fprintf(stderr, "Edit commands from stdin: {+-}{crfma} [<n>]\n");
		fprintf(stderr, " + copy from input; - skip\n");
		fprintf(stderr, " character, record, file, all;\n");
		fprintf(stderr, " +m add a file mark\n");
		fprintf(stderr, " <n> how many, default 1\n");
		exit(1);
	}

	fi = fopen(argv[1], "rb");
	if (fi == NULL) {
		perror(argv[1]);
		exit(1);
	}

	fo = fopen(argv[2], "wb");
	if (fo == NULL) {
		perror(argv[2]);
		exit(1);
	}

	lineno = 1;
	could_be_eof = 0;
	next_c_valid = 0;
	for (;;) {
		/* Get command */
		count = 1;
		extent = EXT_CHAR;
		for (;;) {
			c = fgetc(stdin);
			if (c == EOF) {
				goto done;
			}
			if (c == '\n') {
				lineno++;
				continue;
			}
			if (c != ' ' && c != '\t') {
				break;
			}
		}
		if (c == '+') {
			copy = 1;
		} else if (c == '-') {
			copy = 0;
		} else {
			fprintf(stderr, "line %d syntax error at start of command\n");
			exit(1);
		}
		for (;;) {
			c = fgetc(stdin);
			if (c == EOF) {
				goto done;
			}
			if (c != ' ' && c != '\t') {
				break;
			}
		}
		if (c == 'c') {
			extent = EXT_CHAR;
		} else if (c == 'r') {
			extent = EXT_REC;
		} else if (c == 'f') {
			extent = EXT_FILE;
		} else if (c == 'a') {
			extent = EXT_ALL;
		} else if (c == 'm') {
			extent = EXT_MARK;
		} else {
			fprintf(stderr, "line %d syntax error after +/-\n");
			exit(1);
		}
		for (;;) {
			c = fgetc(stdin);
			if (c == EOF) {
				goto done;
			}
			if (c >= 'a' && c <= 'z') {
				continue;
			}
			if (c != ' ' && c != '\t') {
				break;
			}
		}
		if (c >= '0' && c <= '9') {
			count = c - '0';
			for (;;) {
				c = fgetc(stdin);
				if (c >= '0' && c <= '9') {
					count = 10*count + c - '0';
				} else {
					break;
				}
			}
		}
		if (c == '\n') {
			lineno++;
		} else if (c != ' ' && c != '\t') {
			fprintf(stderr, "line %d syntax error after command\n");
			exit(1);
		}

		/* Execute command */

		first = 1;
		if (extent == EXT_MARK) {
			if (copy) {
				fputc(0x8F, fo);
			}

		} else if (next_c_valid && next_c == EOF) {
			fprintf(stderr, "Ran out of data\n");
			exit(1);
		} else for (;;) {
			if (next_c_valid) {
				c = next_c;
				next_c_valid = 0;
			} else {
				c = fgetc(fi);
				if (c == EOF) {
					next_c_valid = 1;
					next_c = c;
					break;
				}
			}

			if ((c & 0x80) != 0 && could_be_eof == 2) {
				bof = 1;
			} else {
				bof = 0;
			}

			if (c == 0x8F) {
				could_be_eof = 1;
			} else if (could_be_eof == 1 && c == 0x0F) {
				could_be_eof = 2;
			} else if (c != 0) {
				could_be_eof = 0;
			}

			if (extent == EXT_CHAR) {
				--count;
				if (count == 0) {
					if (copy) {
						fputc(c, fo);
					}
					break;
				}
			} else if (!first && extent == EXT_REC && (c & 0x80) != 0 ||
				       extent == EXT_FILE && bof) {
				--count;
				if (count == 0) {
					next_c = c;
					next_c_valid = 1;
					break;
				}
			}
			if (copy) {
				fputc(c, fo);
			}
			first = 0;
		}
	}
done:
	fclose(fi);
	fclose(fo);
}