#include <stdio.h>
#include <stdlib.h>

#define BUFSIZE (16*1024*1024)
unsigned char tapedata[BUFSIZE];

int reverse(int n);

void main(int argc, char **argv)
{
	FILE *f;
	int n;

	if (argc != 3) {
		fprintf(stderr, "Usage: g7trev <infile> <outfile>\n");
	}

	f = fopen(argv[1], "rb");
	if (f == NULL) {
		perror(argv[1]);
		exit(1);
	}
	n = fread(tapedata, 1, BUFSIZE, f);
	if (n <= 0) {
		perror(argv[1]);
		exit(1);
	}
	fclose(f);

	f = fopen(argv[2], "wb");
	if (f == NULL) {
		perror(argv[2]);
		exit(1);
	}
	printf("Read  %6d at %08X-%08X, end %08X\n",
		n, tapedata, &tapedata[n-1], &tapedata[BUFSIZE-1]);

	n = reverse(n);

	printf("Write %6d at %08X-%08X\n",
		n, tapedata, &tapedata[n-1]);

	if (fwrite(tapedata, n, 1, f) != 1) {
		perror(argv[2]);
		exit(1);
	}
	fclose(f);
	exit(0);
}

int reverse(int n)
{
	unsigned char *p, *q, *r;
	unsigned char *ep;

	p = tapedata;
	ep = &tapedata[n];
	q = &tapedata[BUFSIZE];

	if (*p == 0) {
		p += 4;
		n -= 4;
	} else {
		p++;
		n--;
	}

	while (n) {
		for (; n && q-5 > ep; ) {
			*--q = *p++; --n;
			if (n == 0 || *(unsigned long *)p == 0) {
				n = 0;
				break;
			}
			if (*p == 0) {
				q -= 4;
				*(unsigned long *)q = *(unsigned long *)p;
				p += 4;
			} else {
				*--q = *p++; --n;
			}
		}
		for (r = tapedata; p < ep; *r++ = *p++);
		ep = r;
		p = tapedata;
	}

	tapedata[0] = 0;
	tapedata[1] = 0;
	tapedata[2] = 0;
	tapedata[3] = 1;
	for (r = tapedata + 4; q < &tapedata[BUFSIZE]; *r++ = *q++);
	return r - tapedata;
}


