		name	mt7

_data		segment public 'DATA'
_data		ends

dgroup		group _data

_text		segment public 'CODE'
_text		ends


_buf0		segment para public 'BUF'

		db	32767 dup (?)
		db	32767 dup (?)
		db	?

_buf0		ends

_buf1		segment para public 'BUF'

		db	32767 dup (?)
		db	32767 dup (?)
		db	?

_buf1		ends

_buf2		segment para public 'BUF'

		db	32767 dup (?)
		db	32767 dup (?)
		db	?

_buf2		ends

_buf3		segment para public 'BUF'

		db	32767 dup (?)
		db	32767 dup (?)
		db	?

_buf3		ends

_buf4		segment para public 'BUF'

		db	32767 dup (?)
		db	32767 dup (?)
		db	?

_buf4		ends

_buf5		segment para public 'BUF'

		db	32767 dup (?)
		db	32767 dup (?)
		db	?

_buf5		ends


data_port	equ	0320H
status_port	equ	0321H
reset_port	equ	0321H
toggle_port	equ	0322H
control_port	equ	0323H

st_tc		equ	20H	; active hi
st_rdy		equ	10H	; active hi
st_ldp		equ	08H	; active hi
st_rds		equ	01H	; active hi

ct_doff 	equ	40H	; active hi
ct_rwc		equ	10H	; active lo with toggle
ct_src		equ	08H	; active lo with toggle
ct_sfc		equ	04H	; active lo with toggle
ct_dma		equ	02H	; active hi
ct_tc		equ	01H	; active hi

dma_channel	equ	3
dma_read_cmd	equ	057H
dma_mask	equ	007H
dma_addr_port	equ	006H
dma_count_port	equ	007H
dma_stat_port	equ	008H
dma_mask_port	equ	00AH
dma_cmd_port	equ	00BH
dma_init_port	equ	00CH
dma_page_port	equ	082H

_data		segment

shadow		db	?
base_page	db	?
base_seg	dw	?

_data		ends

_text		segment
		assume	cs: _text, ds: dgroup

		public	_mt7_init
_mt7_init	proc	near

		push	bp
		mov	bp, sp
		push	bx
		push	si
		push	di

		mov	dx, reset_port
		out	dx, al
		mov	al, ct_doff + ct_rwc + ct_src + ct_sfc + ct_tc
		mov	dx, control_port
		out	dx, al
		mov	shadow, al
		mov	dx, status_port
		in	al, dx
		and	al, st_rdy

		pop	di
		pop	si
		pop	bx
		pop	bp
		ret

_mt7_init	endp

		public	_mt7_rdy
_mt7_rdy	proc	near

		mov	dx, status_port
		in	al, dx
		and	al, st_rdy
		ret

_mt7_rdy	endp

		public	_mt7_fwd
_mt7_fwd	proc	near

		mov	al, ct_doff + ct_rwc + ct_src + ct_tc + ct_dma
		mov	dx, control_port
		out	dx, al
		mov	shadow, al
		ret

_mt7_fwd	endp

		public	_mt7_rev
_mt7_rev	proc	near

		mov	al, ct_doff + ct_rwc + ct_sfc + ct_tc + ct_dma
		mov	dx, control_port
		out	dx, al
		mov	shadow, al
		ret

_mt7_rev	endp

		public	_mt7_rwd
_mt7_rwd	proc	near

		mov	al, ct_doff + ct_sfc + ct_src
		mov	dx, control_port
		out	dx, al
		mov	dx, toggle_port
		out	dx, al
		mul	dx
		mov	dx, toggle_port
		out	dx, al
		mov	al, shadow
		mov	dx, control_port
		out	dx, al
		ret

_mt7_rwd	endp

		public	_mt7_run
_mt7_run	proc	near

		mov	dx, toggle_port
		out	dx, al
		sti

_mt7_run	endp

		public	_mt7_read
_mt7_read	proc	near

		push	bp
		mov	bp, sp
		push	bx
		push	si
		push	di

		cli
		call	mt7_initdma

		mov	ah, base_page
		mov	di, 0

		mov	bl, shadow
		mov	bh, bl
		and	bh, not ct_tc

		mov	dx, control_port
		mov	al, bh
		out	dx, al
		mov	al, bl
		out	dx, al

		mov	al, dma_channel 	; start dma chip
		mov	dx, dma_mask_port	;
		out	dx, al			;

		mov	dx, toggle_port 	; start tape motion
		out	dx, al			;

		mov	cx, 0
		mov	dx, status_port
read_w1:	in	al, dx
		and	al, st_tc
		jnz	read_s1
		loop	read_w1
		mov	si, -1
		jmp	read_done

read_s2:	mov	si, [bp+4]
		mov	dx, cx
		sub	dx, [bp+6]
		sub	si, dx
		sub	si, dx
		sub	si, dx
		sub	si, dx
		add	word ptr [si], 1
		adc	word ptr [si+2], 0

read_s1:	add	di, 1
		adc	ah, 0
		mov	dx, dma_page_port
		mov	al, ah
		out	dx, al

		mov	dx, control_port
		mov	al, bh
		out	dx, al
		mov	al, bl
		out	dx, al
		mov	cx, [bp+6]
		mov	dx, status_port
read_w2:	in	al, dx
		and	al, st_tc
		jnz	read_s2
		loop	read_w2
		mov	si, 0

read_done:	mov	dx, toggle_port
		out	dx, al
		mov	al, shadow
		and	al, 0FFH - ct_dma
		mov	dx, control_port
		out	dx, al
		mov	shadow, al

		mov	al, dma_mask		; set mask port
		mov	dx, dma_mask_port	;
		out	dx, al			;

		sti
		mov	bx, [bp+8]
		mov	word ptr [bx], di
		sub	ah, base_page
		mov	byte ptr [bx+2], ah
		mov	byte ptr [bx+3], 0
		mov	ax, si

		pop	di
		pop	si
		pop	bx
		pop	bp
		ret

_mt7_read	endp

mt7_initdma	proc	near

		mov	al, dma_mask		; set mask port
		mov	dx, dma_mask_port	;
		out	dx, al			;

		push	ax			; delay
		xor	ax, ax			;
		mul	ax			;
		pop	ax			;

		mov	dx, dma_init_port	;
		out	dx, al			;

		mov	dx, dma_count_port	;
		mov	al, 0FFH		;
		out	dx, al			;
		mov	al, 0FFH		;
		out	dx, al			;

		mov	dx, dma_addr_port	;
		mov	al, 0			;
		out	dx, al			;
		mov	al, 0			;
		out	dx, al			;
		out	dx, al			;
		mov	dx, dma_page_port	;
		mov	al, base_page		;
		out	dx, al			;

		mov	al, dma_read_cmd	; output direction command
		mov	dx, dma_cmd_port	;
		out	dx, al			;

		push	ax			; delay
		xor	ax, ax			;
		mul	ax			;
		pop	ax			;

		ret

mt7_initdma	endp

		public	_mt7_clrbuf
_mt7_clrbuf	proc	near

		push	es
		push	bx
		push	si
		push	di
		mov	dx, _buf0
		add	dx, 00FFFH
		and	dx, 0F000H
		mov	base_seg, dx
		mov	cx, 5
clrloop:	xchg	cx, bx

		mov	di, 0
		mov	cx, 08000H
		push	dx
		pop	es
		rep stosw
		add	dx, 01000H

		xchg	cx, bx
		loop	clrloop

		mov	ax, base_seg
		shr	ah, 1
		shr	ah, 1
		shr	ah, 1
		shr	ah, 1
		mov	base_page, ah

		pop	di
		pop	si
		pop	bx
		pop	es
		ret

_mt7_clrbuf	endp

		public	_mt7_getbuf
_mt7_getbuf	proc	near

		push	bp
		mov	bp, sp
		push	bx
		push	si
		push	di
		push	ds
		push	es

		mov	dl, base_page
		mov	dh, 0
		mov	si, [bp+4]
		add	dx, [bp+6]
		mov	cl, 12
		shl	dx, cl

		mov	di, [bp+8]
		mov	cx, [bp+10]

		push	ds
		pop	es
		push	dx
		pop	ds

		rep movsb

		pop	es
		pop	ds
		pop	di
		pop	si
		pop	bx
		pop	bp
		ret

_mt7_getbuf	endp

		public	_mt7_putbuf
_mt7_putbuf	proc	near

		push	bp
		mov	bp, sp
		push	bx
		push	si
		push	di
		push	ds
		push	es

		mov	dl, base_page
		mov	dh, 0
		mov	di, [bp+4]
		add	dx, [bp+6]
		mov	cl, 12
		shl	dx, cl

		mov	si, [bp+8]
		mov	cx, [bp+10]

		push	dx
		pop	es

		rep movsb

		pop	es
		pop	ds
		pop	di
		pop	si
		pop	bx
		pop	bp
		ret

_mt7_putbuf	endp

_text		ends
		end
