
#include <stdio.h>

#define MAXRETRY 25
#define FIXRETRY  9
/*
#define MAXRETRY 1
#define FIXRETRY 0
*/

#define SAMPLES 	600
#define HISTOFF 	6
#define HISTSHIM	4
#define HV800		21
#define NHIST		SAMPLES+HISTOFF+100
long	hist[NHIST];
long	hsum;
long	hcnt;

#define BUFSIZE 2048
unsigned char  buf1[BUFSIZE];
unsigned char  buf2[BUFSIZE];

long	lastlen;
int	lasterr;

#define LENSAMP 20
long	ls_count[LENSAMP][2];
long	ls_pcount[LENSAMP][2];
long	ls_len[LENSAMP];
long	ls_other[2];
long	ls_used;
long	ls_pused;

FILE	*f;
FILE	*flog;

char	fname[100];
char	flogn[100];
char	*ext = 0;
int	fstart = 0;
int	fbpi = 0;

int	fn;
long	r;

char	s[100];

unsigned short parity[256] = {
	0x400, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x100, 0x200, 0x200, 0x100, 0x200, 0x100, 0x100, 0x200,
	0x200, 0x100, 0x100, 0x200, 0x100, 0x200, 0x200, 0x100,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400
};

long record();
long fix();

main(argc, argv)
	int	argc;
	char	**argv;
{
	int	i;
	int	t;
	int	retry;
	int	m;
	long	n;
	int	pos;
	long	min;
	long	max;
	int	chan;
	int	par;
	int	nfile;
	int	nrec;
	long	bpi;

	if (argc < 2 || argc > 4) {
		fprintf(stderr, "Usage: t7 file [logfile] [nfile]\n");
		exit(1);
	}
	setupfiles(argc, argv);

	nfile = -1;
	nrec = -1;
	if (argc > 2) {
		if (argv[2][0] == 'r') {
			nrec = atoi(&argv[2][1]);
			if (nrec <= 0) {
				fprintf(stderr, "Invalid nrec %d\n", nrec);
				exit(1);
			}
			nfile = 1;
		} else {
			nfile = atoi(argv[2]);
			if (nfile <= 0) {
				fprintf(stderr, "Invalid nfile %d\n", nfile);
				exit(1);
			}
		}
	}

	if (flog != NULL) {
		fprintf(flog, "%s\n\n", argv[1]);
		printf("Comments?\n");
		for (;;) {
			gets(s);
			if (s[0] != 0 && s[0] != '\n') {
				fprintf(flog, "%s\n", s);
				continue;
			}
			break;
		}
		fprintf(flog, "\n");
	}

	t = mt7_init();

	while (!mt7_rdy()) {
		printf("Not ready\r");
	}
	printf("Reading     \n");

	hsum = 0;
	hcnt = 0;
	bpi = 0;

	ls_used = 0;
	ls_pused = 0;
	ls_other[0] = 0;
	ls_other[1] = 0;

	fn = 0;
	do {
		fn++;
		min = 1000000;
		max = 0;
		r = 0;
		do {
			pos = 0;
			for (retry = 0; retry <= MAXRETRY; retry++) {
				if (pos == 0) {
					n = record(1);
					if (n != 0) {
						pos = 1;
					}
				} else if (retry < MAXRETRY) {
					n = record(0);
					if (n != 0) {
						pos = 0;
					}
				}
				if (n == -1 &&
				    retry >= MAXRETRY - FIXRETRY - 2 &&
				    retry <= MAXRETRY - 2) {
					n = fix(-1, -1);
				}
			fixed:
				if (n > 0) {
					if (n > 1) {
						r++;
						if (n < min)
							min = n;
						if (n > max)
							max = n;
					}
					if (write_record(n) != 0) {
						goto bad_err;
					}
					goto read_ok;
				}
				if (n == 0 && pos == 0 && retry >= 2) {
					printf("Blank tape\n");
					if (flog != NULL) {
						fprintf(flog, "Blank tape\n");
					}
					nrec = r;
					goto blank_tape;
				}
			}
			printf("Maximum retries\n");
			if (flog != NULL) {
				fprintf(flog, "Maximum retries\n");
				fflush(flog);
			}
		ask_again:
			chan = -1;
			par = -1;
			printf("abort skip take fix e{0-7} o{0-7} ? ");
			gets(s);
			switch (s[0]) {

			case 'a':
				if (flog != NULL) {
					fprintf(flog, "Operator chose to abort\n");
				}
				goto bad_err;

			case 's':
				if (flog != NULL) {
					fprintf(flog, "Operator chose to skip\n");
				}
				continue;

			case 't':
				if (flog != NULL) {
					fprintf(flog, "Operator chose to take\n");
				}
				n = lastlen;
				goto fixed;

			case 'o':
				par++;
			case 'e':
				par++;
				if (s[1] != '\0' && s[1] != '\n') {
					chan = s[1] - '0';
					if (chan < 0 || chan > 7)
						goto ask_again;
				}
			case 'f':
				if (flog != NULL) {
			     fprintf(flog, "Operator chose to fix %s\n", s);
				}
				n = fix(chan, par);
				goto fixed;

			default:
				goto ask_again;
			}
	read_ok:
			if (pos == 0) {
				record(1);
			}
			if (r > 999 && (r % 1000) == 0) {
				printf("Record %ld\n", r);
				if (flog != NULL) {
					fprintf(flog, "Record %ld\n", r);
				}
				syncfiles();
			}
			continue;
		} while (n > 1 && r != nrec);
	blank_tape:
		if (hsum > hcnt) {
			bpi = 800*HV800*hcnt / hsum;
		}
		printf("file %d. %ld records, min %ld max %ld  %ld BPI\n",
		       fn, r, min, max, bpi);
		if (flog != NULL) {
			fprintf(flog, "file %d. %ld records, min %ld max %ld  %ld BPI\n",
			       fn, r, min, max, bpi);
		}
		hsum = 0;
		hcnt = 0;
		lenrep();
		syncfiles();
	} while (fn != nfile && r > 0 && r != nrec);
bad_err:
	ls_pused = 0;
	if (nfile != 1) {
		printf("\nSummary  %d files\n", fn);
		if (flog != NULL) {
			fprintf(flog, "\nSummary  %d files\n", fn);
		}
		lenrep();
	}
	fclose(f);
}

long
record(fwd)
	int	fwd;
{
	int	t;
	long	len;
	int	err;
	long	i;
	long	j;
	long	n;
	long	m;
	long	hi;
	long	peak;
	long	std;
	long	over;


	for (i = 0; i < NHIST; i++) {
		hist[i] = 0;
	}

	mt7_clrbuf();

	if (fwd) {
		mt7_fwd();
	} else {
		mt7_rev();
	}

	len = 0;
	t = mt7_read(&hist[HISTOFF], SAMPLES, &len);

#ifdef PDATA
	printf("mt7_read returns %d len %ld\n", t, len);

if (len > 5*65536) exit(1);
#endif
	if (t == -1 || len == 0) {
		lastlen = 0;
		lasterr = 0;
		return 0;
	}
	err = 0;

#ifdef HIST
	n = 0;
	m = 0;
	hi = 0;
	peak = 0;
	for (i = 0; i < SAMPLES; i++) {
		if (hist[i] > m) {
			peak = i;
			m = hist[i];
		}
	}
	hsum += peak;
	hcnt++;
	std = peak + peak/2;
	over = 0;
	for (i = 0; i < SAMPLES; ) {
		for (j = 0; j < 10; j++) {
			if (hist[i+j] != 0)
				break;
		}
		if (j < 10) {
#ifdef PHIST
			printf("%4ld. ", i);
#endif
			for (j = 0; j < 10; j++) {
				if (hist[i] != 0) {
					n += hist[i];
					m += i*hist[i];
					hi = i;
					if (i > std) {
						over += hist[i];
					}
				}
#ifdef PHIST
				printf(" %6d", hist[i]);
#endif
				i++;
			}
#ifdef PHIST
			printf("\n");
#endif
		} else {
			i += 10;
		}
	}
	m = (m - hist[hi]*hi) / (n - hist[hi]);
	printf("\nsamples %8ld (%ld) average %4ld hi %4ld\n", n, t, m, hi);
	printf("peak %4ld std %4ld over %8ld\n", peak, std, over);
	if (over > 1) {
		err = 0x800;
	}

#else /* HIST */
	n = len - 1;

	if (n > 1) {
		m = 0;
		for (i = 0; i < SAMPLES; i++) {
			if (hist[i] > m) {
				peak = i;
				m = hist[i];
			}
		}
		hsum += peak;
		hcnt++;
		std = 4*peak - peak/2 - HISTSHIM;
		for (i = peak + peak/2 + HISTSHIM;
		     i < std && i < SAMPLES;
		     i++) {
			if (hist[i] != 0) {
				printf("peak %ld  bad %ld-%ld  hit %ld\n",
					peak, peak + peak/2, std, i);
				if (flog != NULL) {
					fprintf(flog, "peak %ld  bad %ld-%ld  hit %ld\n",
						peak, peak + peak/2, std, i);
				}
				err = 0x800;
			}
		}
       }

#ifdef PDATA
	printf("\nrecord length %ld\n", n);
#endif
#endif
	if (!fwd) {
#ifdef PDATA
		printf("reversing bytes\n");
#endif
		if (n+1 > BUFSIZE) {
			for (i = 0, j = n+1 - BUFSIZE;
			     i <= j;
			     i += BUFSIZE, j -= BUFSIZE) {
				mt7_getbuf(i, buf1, BUFSIZE);
				mt7_getbuf(j, buf2, BUFSIZE);
				for (m = 0; m < BUFSIZE; m++) {
					t = buf1[m];
					buf1[m] = buf2[BUFSIZE-1 - m];
					buf2[BUFSIZE-1 - m] = t;
				}
				mt7_putbuf(i, buf2, BUFSIZE);
				mt7_putbuf(j, buf1, BUFSIZE);
			}
		} else {
			mt7_getbuf(0L, buf1, BUFSIZE);
			m = (n+1)/2;
			for (i = 0; i < m; i++) {
				t = buf1[i];
				buf1[i] = buf1[n-i];
				buf1[n-i] = t;
			}
			mt7_putbuf(0L, buf1, BUFSIZE);
		}
	}

	err |= compute_err(n);
	if (fbpi == 0 &&
	    hsum > hcnt) {
		long	bpi;

		if (err & 0x100) {
			ext = "BIN";
		} else {
			ext = "BCD";
		}
		bpi = 800*HV800/hsum;
		if (bpi < 378) {
			fbpi = 200;
		} else if (bpi < 678) {
			fbpi = 556;
		} else {
			fbpi = 800;
		}
	}

#ifdef PDATA
	printf("Parity/LRC %03X\n", err);

	mt7_getbuf(0L, buf1, 96);
	for (i = 0; i <= n && i < 96; i++) {
		printf(" %02X", buf1[i]);
		if (i % 24 == 23)
			printf("\n");
	}
	printf("\n");
#endif

	lastlen = n;
	lasterr = err;

	if (err == 0x100) {
		lensamp(n, 1);
		return n;
	} else if (err == 0x200) {
		lensamp(n, 0);
		return n;
	} else {
		printf("Read error %03X  file %d record %ld length %ld\n",
			err, fn, r, n);
		if (flog != NULL) {
			fprintf(flog, "Read error %03X  file %d record %ld length %ld\n",
				err, fn, r, n);
		}
		if (n < 9) {
			mt7_getbuf(0L, buf1, n);
			for (i = 0; i < n; i++) {
				printf(" %02X", buf1[i]);
				if (flog != NULL) {
					fprintf(flog, " %02X", buf1[i]);
				}
			}
			printf("\n");
			if (flog != NULL) {
				fprintf(flog, "\n");
			}
		} else {
			mt7_getbuf(0L, buf1, 4);
			printf(" %02X %02X %02X %02X ...",
			    buf1[0], buf1[1], buf1[2], buf1[3]);
			if (flog != NULL) {
				fprintf(flog, " %02X %02X %02X %02X ...",
				    buf1[0], buf1[1], buf1[2], buf1[3]);
			}
			mt7_getbuf(n - 5, buf1, 5);
			printf(" %02X %02X %02X %02X %02X\n",
			    buf1[0], buf1[1], buf1[2], buf1[3], buf1[4]);
			if (flog != NULL) {
				fprintf(flog, " %02X %02X %02X %02X %02X\n",
				    buf1[0], buf1[1], buf1[2], buf1[3], buf1[4]);
			}
		}
		if (flog != NULL) {
			fflush(flog);
		}
		return -1;
	}
}

long
fix(chan, par)
	int	chan;
	int	par;
{
	long	i;
	long	ii;
	long	j;
	long	odd;
	long	even;
	long	bad;
	long	err;
	unsigned char t;
	int	nchan;

	if (par == -1) {
		odd = 0;
		even = 0;
		bad = 0;
		for (i = 0; i < lastlen; ) {
			mt7_getbuf(i, buf1, BUFSIZE);
			for (j = 0; j < BUFSIZE && i < lastlen; j++, i++) {
				if (parity[buf1[j]] & 0x100) {
					odd++;
				}
				if (parity[buf1[j]] & 0x200) {
					even++;
				}
				if (parity[buf1[j]] & 0x400) {
					bad++;
				}
			}
		}
		printf("Out of %ld characters, %ld odd %ld even %ld bad %ld other\n",
		       lastlen, odd, even, bad, lastlen - odd - even);
		if (flog != NULL) {
			fprintf(flog, "Out of %ld characters, %ld odd %ld even %ld bad %ld other\n",
			       lastlen, odd, even, bad, lastlen - odd - even);
		}
		if (bad > 0)
			return -1;
		if (odd > even) {
			par = 1;
		} else {
			par = 0;
		}
	}
	if (chan == -1) {
		for (i = 0; i < 8; i++) {
			if ((lasterr & 0xFF) == (1 << i)) {
				chan = i;
				printf("Correcting on channel %d\n", chan);
				if (flog != NULL) {
					fprintf(flog, "Correcting on channel %d\n",
						chan);
				}
				break;
			}
		}
	}
	if (chan == -1) {
		printf("More than one channel in error\n");
		if (flog != NULL) {
			fprintf(flog, "More than one channel in error\n");
		}
		return -1;
	}

	chan = (1 << chan);
	nchan = 0x7F - chan;
	if (par) {
		par = 0x100;
	} else {
		par = 0x200;
	}
	for (i = 0; i < lastlen; ) {
		ii = i;
		mt7_getbuf(ii, buf1, BUFSIZE);
		for (j = 0; j < BUFSIZE && i < lastlen; j++, i++) {
			t = buf1[j] & nchan;
			if (parity[t] != par)
				t |= chan;
			if (parity[t] != par) {
				t = buf1[j] ^ chan;
				printf("Can't correct %d. %03X or %03X\n",
					i, buf1[j] | parity[buf1[j]], t | parity[t]);
			}
			if (t != buf1[j]) {
				printf("Correct byte %ld from %02X to %02X\n",
					i, buf1[j], t);
				if (flog != NULL) {
					fprintf(flog, "Correct byte %ld from %02X to %02X\n",
						i, buf1[j], t);
				}
				buf1[j] = t;
			}
		}
		mt7_putbuf(ii, buf1, BUFSIZE);
	}

	err = compute_err(lastlen);

#ifdef PDATA
	printf("Parity/LRC %03X\n", err);

	mt7_getbuf(0L, buf1, 96);
	for (i = 0; i <= lastlen && i < 96; i++) {
		printf(" %02X", buf1[i]);
		if (i % 24 == 23)
			printf("\n");
	}
	printf("\n");
#endif

	lasterr = err;

	if (err != par) {
		printf(" now error %03X\n", err);
		if (flog != NULL) {
			fprintf(flog, "New error %03X\n", err);
		}
		return -1;
	}

	return lastlen;
}

compute_err(len)
	long	len;
{
	int	err;
	long	i;
	long	j;

	err = 0;
	for (i = 0; i < len; ) {
		mt7_getbuf(i, buf1, BUFSIZE);
		for (j = 0; j < BUFSIZE && i < len; j++, i++) {
			err ^= buf1[j];
			err |= parity[buf1[j]];
		}
	}
	mt7_getbuf(len, buf1, 1);
	err ^= buf1[0];

	return err;
}

lensamp(len, par)
	long	len;
	int	par;
{
	int	i;

	for (i = 0; i < ls_used; i++) {
		if (ls_len[i] == len) {
			ls_count[i][par]++;
			return;
		}
	}
	if (ls_used < LENSAMP) {
		ls_len[ls_used] = len;
		ls_count[ls_used][0] = 0;
		ls_count[ls_used][1] = 0;
		ls_count[ls_used][par]++;
		ls_used++;
		return;
	}
	ls_other[par]++;
}

lenrep()
{
	int	i;
	long	odd;
	long	even;

	printf("\n     Length     Odd        Even\n");
	if (flog != NULL) {
		fprintf(flog, "\n     Length     Odd        Even\n");
	}
	for (i = 0; i < ls_used; i++) {
		odd = ls_count[i][1];
		even = ls_count[i][0];
		if (i < ls_pused) {
			odd -= ls_pcount[i][1];
			even -= ls_pcount[i][0];
		}
		printf("%10ld %10ld %10ld\n", ls_len[i], odd, even);
		if (flog != NULL) {
			fprintf(flog,"%10ld %10ld %10ld\n", ls_len[i], odd, even);
		}
		ls_pcount[i][0] = ls_count[i][0];
		ls_pcount[i][1] = ls_count[i][1];
	}
	ls_pused = ls_used;
	if (flog != NULL) {
		fflush(flog);
	}
}

write_record(len)
	long	len;
{
	long	off;
	int	m;
	int	n;

	if (f == NULL) {
		if (ready_files() == -1)
			return;
	}
	mt7_getbuf(0L, buf1, 1);
	buf1[0] |= 0x80;
	mt7_putbuf(0L, buf1, 1);

	off = 0;
	while (len > 0) {
		if (len > sizeof(buf1)) {
			n = sizeof(buf1);
		} else {
			n = len;
		}
		mt7_getbuf(off, buf1, n);
		m = fwrite(buf1, 1, n, f);
		if (m != n) {
			perror("Write error\n");
			if (flog != NULL) {
				fprintf(flog, "Write error\n");
			}
			return -1;
		}
		len -= n;
		off += n;
	}
	return 0;
}

setupfiles(argc, argv)
	int	argc;
	char	**argv;
{

	strcpy(fname, argv[1]);
	strcpy(flogn, argv[1]);
	{
		char *p;
		for (p = flogn; *p && *p != '.'; p++);
		if (*p == '.')
			*p = '\0';
	}
	strcat(flogn, ".log");
	openfiles();
}

openfiles()
{

	f = NULL;
	flog = fopen(flogn, "w");
	if (flog == NULL) {
		perror(flogn);
		exit(1);
	}
}

syncfiles()
{

	fclose(f);
	f = NULL;
	if (flog != NULL) {
		fclose(flog);
		flog = NULL;
	}
	flog = fopen(flogn, "a");
}

ready_files()
{

	if (!fstart) {
		char *p;

		if (ext == 0) {
			printf("Skipping filemark\n");
			if (flog != NULL) {
				fprintf(flog, "Skipping filemark\n");
			}
			return -1;
		}
		for (p = fname; *p && *p != '.'; p++);
		if (*p == '\0') {
			strcat(fname, ".");
			strcat(fname, ext);
		}
		printf("%s at %d BPI\n", fname, fbpi);
		if (flog != NULL) {
			fprintf(flog, "%s at %d BPI\n", fname, fbpi);
		}
		f = fopen(fname, "wb");
		if (f == NULL) {
			perror(fname);
			exit(1);
		}
		fstart = 1;
	} else {
		f = fopen(fname, "ab");
		if (f == NULL) {
			perror(fname);
			exit(1);
		}
	}
	return 0;
}
