/*
 * Record info about 7-track tape images
 */

#include <stdlib.h>
#include <stdio.h>

unsigned char parity[256];


void main(argc, argv)
	int argc;
	char **argv;
{
	FILE *f;
	int filenum;
	int recnum;
	int cur_reclen;
	int cur_reccnt;
	int cur_recnum;
	int cur_parity;
	int cur_badparity;
	int reclen;
	int even;
	int odd;
	int lrc;
	int total_zero;
	int contig_zero;
	int prev_contig_zero;
	int lrc_state;
	int good_lrc;
	int bad_lrc;
	int could_be_eof;
	int c;
	int i;

	if (argc != 2) {
		fprintf(stderr, "Usage: g7tinfo <file>\n");
		exit(1);
	}

	f = fopen(argv[1], "rb");
	if (f == NULL) {
		perror(argv[1]);
		exit(1);
	}

	for (i = 0; i < sizeof(parity); i++) {
		unsigned char b;
		int c;

		for (c = 0, b = 1; b; b <<= 1) {
			if (i & b) {
				c++;
			}
		}
		parity[i] = c & 1;
	}

	c = fgetc(f);
	if ((c & 0x80) == 0) {
		fprintf(stderr, "Not a 7-track tape image\n");
		exit(1);
	}
	filenum = 1;
	recnum = 0;
	cur_reclen = -1;
	cur_reccnt = 0;
	good_lrc = 0;
	bad_lrc = 0;
	for (;;) {
		recnum++;
		reclen = 0;
		even = 0;
		odd = 0;
		lrc = 0;
		total_zero = 0;
		contig_zero = 0;
		prev_contig_zero = 0;
		could_be_eof = c == 0x8F;

		c &= 0x7F;
		for (;;) {
			reclen++;
			if (prev_contig_zero != 0) {
				total_zero += prev_contig_zero;
				prev_contig_zero = 0;
			}
			if (c == 0) {
				contig_zero++;
			} else {
				if (contig_zero != 0) {
					prev_contig_zero = contig_zero;
					contig_zero = 0;
				}
				if (parity[c]) {
					odd++;
				} else {
					even++;
				}
				lrc ^= c;
			}

			c = fgetc(f);
			if (c == EOF || (c & 0x80) != 0) {
				break;
			}
		}

		lrc_state = 0;
		if (prev_contig_zero != 0) {
			if (prev_contig_zero > 2) {
				reclen -= prev_contig_zero + 1;
				if (lrc == 0) {
					lrc_state = 1;
				} else {
					lrc_state = 2;
				}
			} else {
				total_zero += prev_contig_zero;
				prev_contig_zero = 0;
			}
		}

		if (reclen != cur_reclen || cur_parity != (odd > even)) {
			if (cur_reccnt > 0) {
				printf("%3d %6d. %6dx %6d",
					   filenum, recnum - cur_reccnt, cur_reccnt, cur_reclen);
				if (cur_parity) {
					printf("  odd");
					if (cur_badparity > 0) {
						printf("; %d even", cur_badparity);
					}
				} else {
					printf("  even");
					if (cur_badparity > 0) {
						printf("; %d odd", cur_badparity);
					}
				}
				if (total_zero > 0) {
					printf(" %d zero", total_zero);
				}
				if (good_lrc + bad_lrc > 0) {
					printf(" lrc");
					if (bad_lrc > 0) {
						printf(" %d err", bad_lrc);
					}
				}
				printf("\n");
			}
			cur_reclen = reclen;
			cur_reccnt = 1;
			cur_recnum = recnum;
			if (odd > even) {
				cur_parity = 1;
				cur_badparity = even;
			} else {
				cur_parity = 0;
				cur_badparity = odd;
			}
			good_lrc = 0;
			bad_lrc = 0;
		} else {
			cur_reccnt++;
			if (cur_parity) {
				cur_badparity += even;
			} else {
				cur_badparity += odd;
			}
		}
		if (lrc_state == 1) {
			good_lrc++;
		} else if (lrc_state == 2) {
			bad_lrc++;
		}

		if (could_be_eof && reclen == 1) {
			printf("End of file\n");
			filenum++;
			recnum = 0;
			cur_reclen = -1;
			cur_reccnt = 0;
		}

		if (c == EOF) {
			break;
		}
	}
}