
#include <stdlib.h>
#include <stdio.h>
#include "asciibcd.h"
#include "cvtpar.h"
#include "prsf2.h"

char fin[300], fon[300];
unsigned char bcdascii[256];

void makerev()
{
	int	i;
	unsigned char space = 050;

	for (i = 0; i < 256; i++) {
		bcdascii[i] = space;
	}
	for (i = 1; i < 64; i++) {
		bcdascii[asciibcd[i]] = evenpar[i];
		bcdascii[asciialt[i]] = evenpar[i];
	}
	for (i = 'a'; i <= 'z'; i++) {
		bcdascii[i] = bcdascii[i + 'A' - 'a'];
	}

#ifdef DEBUG
	for (i = 0; i < 256; i++) {
		if (bcdascii[i] != space) {
			printf("%c %03o\n", i, bcdascii[i]);
		}
	}
#endif
}

main(argc, argv)
	int	argc;
	char	**argv;
{
	register int c;
	static unsigned char buf[160];
	FILE *fi, *fo;
	int reclen;
	int chrcnt;

	reclen = 84;
	parsefiles(argc, argv, "txt", "bcd", &reclen);
	if ((fi = fopen(fin, "r")) == NULL) {
		perror(fin);
		exit(1);
	}
	if ((fo = fopen(fon, "wb")) == NULL) {
		perror(fon);
		exit(1);
	}

	makerev();

	chrcnt = 0;
	while ( (c = fgetc(fi)) != EOF ) {
		if (c == '\n' || c == '\f') {
			while (chrcnt < reclen) {
				if (chrcnt == 0) {
					fputc(bcdascii[' '] | 0200, fo);
				} else {
					fputc(bcdascii[' '], fo);
				}
				chrcnt++;
			}
			chrcnt = 0;
			if (c == '\f') {
				fputc(0217, fo);
			}
		} else if (c == '\t') {
			if (chrcnt == 0) {
				fputc(bcdascii[' '] | 0200, fo);
			} else {
				fputc(bcdascii[' '], fo);
			}
			chrcnt++;
			while (chrcnt % 8 != 0) {
				fputc(bcdascii[' '], fo);
				chrcnt++;
			}
		} else if (chrcnt == 0) {
			fputc(bcdascii[c] | 0200, fo);
			chrcnt++;
		} else {
			fputc(bcdascii[c], fo);
			chrcnt++;
		}
	}
	if (chrcnt > 0) {
		while (chrcnt < reclen) {
			fputc(bcdascii[' '], fo);
			chrcnt++;
		}
	}
}
